/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.google.common.collect.Lists;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.api.sink.SaveModeExecuteWrapper;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.core.starter.execution.PluginUtil;
import org.apache.seatunnel.core.starter.utils.ConfigBuilder;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.JobDefineCheckException;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.classloader.ClassLoaderService;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SinkConfig;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.actions.TransformAction;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.parse.ConfigParserUtil;
import org.apache.seatunnel.engine.core.parse.JobConfigParser;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelTransformPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class MultipleTableJobConfigParser {
    private static final Logger log = LoggerFactory.getLogger(MultipleTableJobConfigParser.class);
    private final IdGenerator idGenerator;
    private final JobConfig jobConfig;
    private final List<URL> commonPluginJars;
    private final Config seaTunnelJobConfig;
    private final ReadonlyConfig envOptions;
    private final JobConfigParser fallbackParser;
    private final boolean isStartWithSavePoint;

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig) {
        this(jobDefineFilePath, idGenerator, jobConfig, Collections.emptyList(), false);
    }

    public MultipleTableJobConfigParser(Config seaTunnelJobConfig, IdGenerator idGenerator, JobConfig jobConfig) {
        this(seaTunnelJobConfig, idGenerator, jobConfig, Collections.emptyList(), false);
    }

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars, boolean isStartWithSavePoint) {
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.commonPluginJars = commonPluginJars;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.seaTunnelJobConfig = ConfigBuilder.of(Paths.get(jobDefineFilePath, new String[0]));
        this.envOptions = ReadonlyConfig.fromConfig(this.seaTunnelJobConfig.getConfig("env"));
        this.fallbackParser = new JobConfigParser(idGenerator, commonPluginJars, isStartWithSavePoint);
    }

    public MultipleTableJobConfigParser(Config seaTunnelJobConfig, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars, boolean isStartWithSavePoint) {
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.commonPluginJars = commonPluginJars;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.seaTunnelJobConfig = seaTunnelJobConfig;
        this.envOptions = ReadonlyConfig.fromConfig(seaTunnelJobConfig.getConfig("env"));
        this.fallbackParser = new JobConfigParser(idGenerator, commonPluginJars, isStartWithSavePoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutablePair<List<Action>, Set<URL>> parse(ClassLoaderService classLoaderService) {
        List<? extends Config> sourceConfigs = TypesafeConfigUtils.getConfigList(this.seaTunnelJobConfig, "source", Collections.emptyList());
        List<? extends Config> transformConfigs = TypesafeConfigUtils.getConfigList(this.seaTunnelJobConfig, "transform", Collections.emptyList());
        List<? extends Config> sinkConfigs = TypesafeConfigUtils.getConfigList(this.seaTunnelJobConfig, "sink", Collections.emptyList());
        List<URL> connectorJars = this.getConnectorJarList(sourceConfigs, sinkConfigs);
        if (!this.commonPluginJars.isEmpty()) {
            connectorJars.addAll(this.commonPluginJars);
        }
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = classLoaderService == null ? new SeaTunnelChildFirstClassLoader(connectorJars, parentClassLoader) : classLoaderService.getClassLoader(Long.parseLong(this.jobConfig.getJobContext().getJobId()), connectorJars);
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            ConfigParserUtil.checkGraph(sourceConfigs, transformConfigs, sinkConfigs);
            this.fillJobConfig();
            LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap = new LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>>();
            log.info("start generating all sources.");
            for (int configIndex = 0; configIndex < sourceConfigs.size(); ++configIndex) {
                Config sourceConfig = sourceConfigs.get(configIndex);
                Tuple2<String, List<Tuple2<CatalogTable, Action>>> tuple2 = this.parseSource(configIndex, sourceConfig, classLoader);
                tableWithActionMap.put(tuple2._1(), tuple2._2());
            }
            log.info("start generating all transforms.");
            this.parseTransforms(transformConfigs, classLoader, tableWithActionMap);
            log.info("start generating all sinks.");
            ArrayList<Action> sinkActions = new ArrayList<Action>();
            for (int configIndex = 0; configIndex < sinkConfigs.size(); ++configIndex) {
                Config sinkConfig = sinkConfigs.get(configIndex);
                sinkActions.addAll(this.parseSink(configIndex, sinkConfig, classLoader, tableWithActionMap));
            }
            Set<URL> factoryUrls = this.getUsedFactoryUrls(sinkActions);
            ImmutablePair<List<Action>, Set<URL>> immutablePair = new ImmutablePair<List<Action>, Set<URL>>(sinkActions, factoryUrls);
            return immutablePair;
        }
        finally {
            Thread.currentThread().setContextClassLoader(parentClassLoader);
            if (classLoaderService != null) {
                classLoaderService.releaseClassLoader(Long.parseLong(this.jobConfig.getJobContext().getJobId()), connectorJars);
            }
        }
    }

    public Set<URL> getUsedFactoryUrls(List<Action> sinkActions) {
        HashSet<URL> urls = new HashSet<URL>();
        this.fillUsedFactoryUrls(sinkActions, urls);
        return urls;
    }

    private List<URL> getConnectorJarList(List<? extends Config> sourceConfigs, List<? extends Config> sinkConfigs) {
        List<PluginIdentifier> factoryIds = Stream.concat(sourceConfigs.stream().map(ConfigParserUtil::getFactoryId).map(factory -> PluginIdentifier.of("seatunnel", "source", factory)), sinkConfigs.stream().map(ConfigParserUtil::getFactoryId).map(factory -> PluginIdentifier.of("seatunnel", "sink", factory))).collect(Collectors.toList());
        return new SeaTunnelSinkPluginDiscovery().getPluginJarPaths(factoryIds);
    }

    private void fillUsedFactoryUrls(List<Action> actions, Set<URL> result) {
        actions.forEach(action -> {
            result.addAll(action.getJarUrls());
            if (!action.getUpstream().isEmpty()) {
                this.fillUsedFactoryUrls(action.getUpstream(), result);
            }
        });
    }

    void addCommonPluginJarsToAction(Action action) {
        action.getJarUrls().addAll(this.commonPluginJars);
        if (!action.getUpstream().isEmpty()) {
            action.getUpstream().forEach(this::addCommonPluginJarsToAction);
        }
    }

    private void fillJobConfig() {
        this.jobConfig.getJobContext().setJobMode(this.envOptions.get(EnvCommonOptions.JOB_MODE));
        if (StringUtils.isEmpty(this.jobConfig.getName()) || this.jobConfig.getName().equals("SeaTunnel") || this.jobConfig.getName().equals(EnvCommonOptions.JOB_NAME.defaultValue())) {
            this.jobConfig.setName(this.envOptions.get(EnvCommonOptions.JOB_NAME));
        }
        this.envOptions.toMap().forEach((k, v) -> this.jobConfig.getEnvOptions().put((String)k, v));
    }

    private static <T extends Factory> boolean isFallback(ClassLoader classLoader, Class<T> factoryClass, String factoryId, Consumer<T> virtualCreator) {
        Optional<T> factory = FactoryUtil.discoverOptionalFactory(classLoader, factoryClass, factoryId);
        if (!factory.isPresent()) {
            return true;
        }
        try {
            virtualCreator.accept(factory.get());
        }
        catch (Exception e) {
            if (e instanceof UnsupportedOperationException && "The Factory has not been implemented and the deprecated Plugin will be used.".equals(e.getMessage())) {
                log.warn("The Factory has not been implemented and the deprecated Plugin will be used.");
                return true;
            }
            log.debug(ExceptionUtils.getMessage(e));
        }
        return false;
    }

    private int getParallelism(ReadonlyConfig config) {
        return Math.max(1, config.getOptional(CommonOptions.PARALLELISM).orElse(this.envOptions.get(CommonOptions.PARALLELISM)));
    }

    public Tuple2<String, List<Tuple2<CatalogTable, Action>>> parseSource(int configIndex, Config sourceConfig, ClassLoader classLoader) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(sourceConfig);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse("default-identifier");
        int parallelism = this.getParallelism(readonlyConfig);
        boolean fallback = MultipleTableJobConfigParser.isFallback(classLoader, TableSourceFactory.class, factoryId, factory -> factory.createSource(null));
        if (fallback) {
            Tuple2<CatalogTable, Action> tuple = this.fallbackParser.parseSource(sourceConfig, this.jobConfig, tableId, parallelism);
            return new Tuple2<String, List<Tuple2<CatalogTable, Action>>>(tableId, Collections.singletonList(tuple));
        }
        Tuple2 tuple2 = FactoryUtil.createAndPrepareSource(readonlyConfig, classLoader, factoryId);
        HashSet<URL> factoryUrls = new HashSet<URL>();
        factoryUrls.addAll(this.getSourcePluginJarPaths(sourceConfig));
        ArrayList actions = new ArrayList();
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createSourceActionName(configIndex, factoryId);
        SeaTunnelSource source = tuple2._1();
        source.setJobContext(this.jobConfig.getJobContext());
        PluginUtil.ensureJobModeMatch(this.jobConfig.getJobContext(), source);
        SourceAction action = new SourceAction(id, actionName, tuple2._1(), factoryUrls, new HashSet<ConnectorJarIdentifier>());
        action.setParallelism(parallelism);
        for (CatalogTable catalogTable : tuple2._2()) {
            actions.add(new Tuple2(catalogTable, action));
        }
        return new Tuple2<String, List<Tuple2<CatalogTable, Action>>>(tableId, actions);
    }

    public void parseTransforms(List<? extends Config> transformConfigs, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        if (CollectionUtils.isEmpty(transformConfigs) || transformConfigs.isEmpty()) {
            return;
        }
        LinkedList<Config> configList = new LinkedList<Config>(transformConfigs);
        int index = 0;
        while (!configList.isEmpty()) {
            this.parseTransform(index++, configList, classLoader, tableWithActionMap);
        }
    }

    private void parseTransform(int index, Queue<Config> transforms, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        Config config = transforms.poll();
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(config);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        HashSet<URL> jarUrls = new HashSet<URL>();
        jarUrls.addAll(this.getTransformPluginJarPaths(config));
        List<String> inputIds = ConfigParserUtil.getInputIds(readonlyConfig);
        List<Object> inputs = inputIds.stream().map(tableWithActionMap::get).filter(Objects::nonNull).peek(input -> {
            if (input.size() > 1) {
                throw new JobDefineCheckException("Adding transform to multi-table source is not supported.");
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
        if (inputs.isEmpty()) {
            if (transforms.isEmpty()) {
                inputs = MultipleTableJobConfigParser.findLast(tableWithActionMap);
            } else {
                transforms.offer(config);
                return;
            }
        }
        String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse("default-identifier");
        Set inputActions = inputs.stream().map(Tuple2::_2).collect(Collectors.toCollection(LinkedHashSet::new));
        MultipleTableJobConfigParser.checkProducedTypeEquals(inputActions);
        int spareParallelism = ((Action)((Tuple2)inputs.get(0))._2()).getParallelism();
        int parallelism = readonlyConfig.getOptional(CommonOptions.PARALLELISM).orElse(spareParallelism);
        CatalogTable catalogTable = (CatalogTable)((Tuple2)inputs.get(0))._1();
        SeaTunnelTransform<?> transform = FactoryUtil.createAndPrepareTransform(catalogTable, readonlyConfig, classLoader, factoryId);
        transform.setJobContext(this.jobConfig.getJobContext());
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createTransformActionName(index, factoryId);
        TransformAction transformAction = new TransformAction(id, actionName, new ArrayList<Action>(inputActions), transform, jarUrls, new HashSet<ConnectorJarIdentifier>());
        transformAction.setParallelism(parallelism);
        tableWithActionMap.put(tableId, Collections.singletonList(new Tuple2<CatalogTable, TransformAction>(transform.getProducedCatalogTable(), transformAction)));
    }

    public static SeaTunnelDataType<?> getProducedType(Action action) {
        if (action instanceof SourceAction) {
            try {
                return ((SourceAction)action).getSource().getProducedCatalogTables().get(0).getSeaTunnelRowType();
            }
            catch (UnsupportedOperationException e) {
                return ((SourceAction)action).getSource().getProducedType();
            }
        }
        if (action instanceof TransformAction) {
            return ((TransformAction)action).getTransform().getProducedCatalogTable().getSeaTunnelRowType();
        }
        throw new UnsupportedOperationException();
    }

    public static void checkProducedTypeEquals(Set<Action> inputActions) {
        SeaTunnelDataType<?> expectedType = MultipleTableJobConfigParser.getProducedType(new ArrayList<Action>(inputActions).get(0));
        for (Action action : inputActions) {
            SeaTunnelDataType<?> producedType = MultipleTableJobConfigParser.getProducedType(action);
            if (expectedType.equals(producedType)) continue;
            throw new JobDefineCheckException("Transform/Sink don't support processing data with two different structures.");
        }
    }

    @Deprecated
    private static <T> T findLast(LinkedHashMap<?, T> map) {
        int size = map.size();
        int i = 1;
        for (T value : map.values()) {
            if (i == size) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public List<SinkAction<?, ?, ?, ?>> parseSink(int configIndex, Config sinkConfig, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(sinkConfig);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        List<String> inputIds = ConfigParserUtil.getInputIds(readonlyConfig);
        List<Object> inputVertices = inputIds.stream().map(tableWithActionMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (inputVertices.isEmpty()) {
            inputVertices = Collections.singletonList(MultipleTableJobConfigParser.findLast(tableWithActionMap));
        } else if (inputVertices.size() > 1) {
            for (List inputVertex : inputVertices) {
                if (inputVertex.size() <= 1) continue;
                throw new JobDefineCheckException("Sink don't support simultaneous writing of data from multi-table source and other sources.");
            }
        }
        boolean fallback = MultipleTableJobConfigParser.isFallback(classLoader, TableSinkFactory.class, factoryId, factory -> factory.createSink(null));
        if (fallback) {
            return this.fallbackParser.parseSinks(configIndex, inputVertices, sinkConfig, this.jobConfig);
        }
        HashSet<URL> jarUrls = new HashSet<URL>();
        jarUrls.addAll(this.getSinkPluginJarPaths(sinkConfig));
        ArrayList sinkActions = new ArrayList();
        if (inputVertices.size() > 1) {
            Set inputActions = inputVertices.stream().flatMap(Collection::stream).map(Tuple2::_2).collect(Collectors.toCollection(LinkedHashSet::new));
            MultipleTableJobConfigParser.checkProducedTypeEquals(inputActions);
            Tuple2 inputActionSample = (Tuple2)((List)inputVertices.get(0)).get(0);
            SinkAction<?, ?, ?, ?> sinkAction = this.createSinkAction((CatalogTable)inputActionSample._1(), inputActions, readonlyConfig, classLoader, jarUrls, new HashSet<ConnectorJarIdentifier>(), factoryId, ((Action)inputActionSample._2()).getParallelism(), configIndex);
            sinkActions.add(sinkAction);
            return sinkActions;
        }
        for (Tuple2 tuple : (List)inputVertices.get(0)) {
            SinkAction<?, ?, ?, ?> sinkAction = this.createSinkAction((CatalogTable)tuple._1(), Collections.singleton(tuple._2()), readonlyConfig, classLoader, jarUrls, new HashSet<ConnectorJarIdentifier>(), factoryId, ((Action)tuple._2()).getParallelism(), configIndex);
            sinkActions.add(sinkAction);
        }
        Optional<SinkAction<?, ?, ?, ?>> multiTableSink = this.tryGenerateMultiTableSink(sinkActions, readonlyConfig, classLoader, factoryId, configIndex);
        return multiTableSink.map(Collections::singletonList).orElse(sinkActions);
    }

    private Optional<SinkAction<?, ?, ?, ?>> tryGenerateMultiTableSink(List<SinkAction<?, ?, ?, ?>> sinkActions, ReadonlyConfig options, ClassLoader classLoader, String factoryId, int configIndex) {
        if (sinkActions.stream().anyMatch(action -> !(action.getSink() instanceof SupportMultiTableSink))) {
            log.info("Unsupported multi table sink api, rollback to sink template");
            return Optional.empty();
        }
        HashMap<String, SeaTunnelSink> sinks = new HashMap<String, SeaTunnelSink>();
        Set<URL> jars = sinkActions.stream().flatMap(a -> a.getJarUrls().stream()).collect(Collectors.toSet());
        sinkActions.forEach(action -> {
            SeaTunnelSink sink = action.getSink();
            String tableId = action.getConfig().getMultipleRowTableId();
            sinks.put(tableId, sink);
        });
        SeaTunnelSink sink = FactoryUtil.createMultiTableSink(sinks, options, classLoader);
        String actionName = JobConfigParser.createSinkActionName(configIndex, factoryId, "MultiTableSink");
        SinkAction multiTableAction = new SinkAction(this.idGenerator.getNextId(), actionName, sinkActions.get(0).getUpstream(), sink, jars, new HashSet<ConnectorJarIdentifier>());
        multiTableAction.setParallelism(sinkActions.get(0).getParallelism());
        return Optional.of(multiTableAction);
    }

    private SinkAction<?, ?, ?, ?> createSinkAction(CatalogTable catalogTable, Set<Action> inputActions, ReadonlyConfig readonlyConfig, ClassLoader classLoader, Set<URL> factoryUrls, Set<ConnectorJarIdentifier> connectorJarIdentifiers, String factoryId, int parallelism, int configIndex) {
        SeaTunnelSink sink = FactoryUtil.createAndPrepareSink(catalogTable, readonlyConfig, classLoader, factoryId);
        sink.setJobContext(this.jobConfig.getJobContext());
        SinkConfig actionConfig = new SinkConfig(catalogTable.getTableId().toTablePath().toString());
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createSinkActionName(configIndex, factoryId, actionConfig.getMultipleRowTableId());
        SinkAction sinkAction = new SinkAction(id, actionName, new ArrayList<Action>(inputActions), sink, factoryUrls, connectorJarIdentifiers, actionConfig);
        if (!this.isStartWithSavePoint) {
            MultipleTableJobConfigParser.handleSaveMode(sink);
        }
        sinkAction.setParallelism(parallelism);
        return sinkAction;
    }

    public static void handleSaveMode(SeaTunnelSink<?, ?, ?, ?> sink) {
        SupportSaveMode saveModeSink;
        Optional<SaveModeHandler> saveModeHandler;
        if (SupportSaveMode.class.isAssignableFrom(sink.getClass()) && (saveModeHandler = (saveModeSink = (SupportSaveMode)((Object)sink)).getSaveModeHandler()).isPresent()) {
            try (SaveModeHandler handler = saveModeHandler.get();){
                new SaveModeExecuteWrapper(handler).execute();
            }
            catch (Exception e) {
                throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.HANDLE_SAVE_MODE_FAILED, (Throwable)e);
            }
        }
    }

    private List<URL> getSourcePluginJarPaths(Config sourceConfig) {
        SeaTunnelSourcePluginDiscovery sourcePluginDiscovery = new SeaTunnelSourcePluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", "source", sourceConfig.getString("plugin_name"));
        List<URL> pluginJarPaths = sourcePluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier));
        return pluginJarPaths;
    }

    private List<URL> getTransformPluginJarPaths(Config transformConfig) {
        SeaTunnelTransformPluginDiscovery transformPluginDiscovery = new SeaTunnelTransformPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", "transform", transformConfig.getString("plugin_name"));
        List<URL> pluginJarPaths = transformPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier));
        return pluginJarPaths;
    }

    private List<URL> getSinkPluginJarPaths(Config sinkConfig) {
        SeaTunnelSinkPluginDiscovery sinkPluginDiscovery = new SeaTunnelSinkPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", "sink", sinkConfig.getString("plugin_name"));
        List<URL> pluginJarPaths = sinkPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier));
        return pluginJarPaths;
    }
}

