/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.master;

import com.google.common.collect.Lists;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.apache.seatunnel.engine.common.Constant;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobResult;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointManager;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.checkpoint.CompletedCheckpoint;
import org.apache.seatunnel.engine.server.dag.DAGUtils;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalPlan;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.dag.physical.PlanUtils;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.metrics.JobMetricsUtil;
import org.apache.seatunnel.engine.server.metrics.SeaTunnelMetricsContext;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.scheduler.JobScheduler;
import org.apache.seatunnel.engine.server.scheduler.PipelineBaseScheduler;
import org.apache.seatunnel.engine.server.task.operation.CleanTaskGroupContextOperation;
import org.apache.seatunnel.engine.server.task.operation.GetTaskGroupMetricsOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;

public class JobMaster {
    private static final ILogger LOGGER = Logger.getLogger(JobMaster.class);
    private PhysicalPlan physicalPlan;
    private final Data jobImmutableInformationData;
    private final NodeEngine nodeEngine;
    private final ExecutorService executorService;
    private final FlakeIdGenerator flakeIdGenerator;
    private final ResourceManager resourceManager;
    private final JobHistoryService jobHistoryService;
    private CheckpointManager checkpointManager;
    private CompletableFuture<JobResult> jobMasterCompleteFuture;
    private ClassLoader classLoader;
    private JobImmutableInformation jobImmutableInformation;
    private JobScheduler jobScheduler;
    private LogicalDag logicalDag;
    private JobDAGInfo jobDAGInfo;
    private final IMap<PipelineLocation, Map<TaskGroupLocation, SlotProfile>> ownedSlotProfilesIMap;
    private final IMap<Object, Object> runningJobStateIMap;
    private final IMap<Object, Object> runningJobStateTimestampsIMap;
    private CompletableFuture<Void> scheduleFuture;
    private volatile boolean restore = false;
    private boolean isPhysicalDAGIInfo = true;
    private final EngineConfig engineConfig;
    private boolean isRunning = true;
    private Map<Integer, CheckpointPlan> checkpointPlanMap;
    private final IMap<Long, JobInfo> runningJobInfoIMap;
    private final IMap<Long, HashMap<TaskLocation, SeaTunnelMetricsContext>> metricsImap;
    private volatile boolean needRestore = true;
    private CheckpointConfig jobCheckpointConfig;
    private String errorMessage;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public JobMaster(@NonNull Data jobImmutableInformationData, @NonNull NodeEngine nodeEngine, @NonNull ExecutorService executorService, @NonNull ResourceManager resourceManager, @NonNull JobHistoryService jobHistoryService, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap, @NonNull IMap ownedSlotProfilesIMap, @NonNull IMap<Long, JobInfo> runningJobInfoIMap, @NonNull IMap<Long, HashMap<TaskLocation, SeaTunnelMetricsContext>> metricsImap, EngineConfig engineConfig) {
        if (jobImmutableInformationData == null) {
            throw new NullPointerException("jobImmutableInformationData is marked non-null but is null");
        }
        if (nodeEngine == null) {
            throw new NullPointerException("nodeEngine is marked non-null but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (jobHistoryService == null) {
            throw new NullPointerException("jobHistoryService is marked non-null but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked non-null but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked non-null but is null");
        }
        if (ownedSlotProfilesIMap == null) {
            throw new NullPointerException("ownedSlotProfilesIMap is marked non-null but is null");
        }
        if (runningJobInfoIMap == null) {
            throw new NullPointerException("runningJobInfoIMap is marked non-null but is null");
        }
        if (metricsImap == null) {
            throw new NullPointerException("metricsImap is marked non-null but is null");
        }
        this.jobImmutableInformationData = jobImmutableInformationData;
        this.nodeEngine = nodeEngine;
        this.executorService = executorService;
        this.flakeIdGenerator = this.nodeEngine.getHazelcastInstance().getFlakeIdGenerator("SeaTunnelIdGenerator");
        this.ownedSlotProfilesIMap = ownedSlotProfilesIMap;
        this.resourceManager = resourceManager;
        this.jobHistoryService = jobHistoryService;
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
        this.runningJobInfoIMap = runningJobInfoIMap;
        this.engineConfig = engineConfig;
        this.metricsImap = metricsImap;
    }

    public void init(long initializationTimestamp, boolean restart, boolean canRestoreAgain) throws Exception {
        this.jobImmutableInformation = (JobImmutableInformation)this.nodeEngine.getSerializationService().toObject(this.jobImmutableInformationData);
        this.jobCheckpointConfig = this.createJobCheckpointConfig(this.engineConfig.getCheckpointConfig(), this.jobImmutableInformation.getJobConfig().getEnvOptions());
        LOGGER.info(String.format("Init JobMaster for Job %s (%s) ", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId()));
        LOGGER.info(String.format("Job %s (%s) needed jar urls %s", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.getPluginJarsUrls()));
        this.classLoader = new SeaTunnelChildFirstClassLoader(this.jobImmutableInformation.getPluginJarsUrls());
        this.logicalDag = (LogicalDag)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.nodeEngine.getSerializationService(), this.classLoader, this.jobImmutableInformation.getLogicalDag());
        Tuple2<PhysicalPlan, Map<Integer, CheckpointPlan>> planTuple = PlanUtils.fromLogicalDAG(this.logicalDag, this.nodeEngine, this.jobImmutableInformation, initializationTimestamp, this.executorService, this.flakeIdGenerator, this.runningJobStateIMap, this.runningJobStateTimestampsIMap, this.engineConfig.getQueueType(), this.jobCheckpointConfig);
        this.physicalPlan = planTuple.f0();
        this.physicalPlan.setJobMaster(this);
        this.checkpointPlanMap = planTuple.f1();
        if (!canRestoreAgain) {
            this.neverNeedRestore();
        }
        Exception initException = null;
        try {
            this.initCheckPointManager();
        }
        catch (Exception e) {
            initException = e;
        }
        this.initStateFuture();
        if (initException != null) {
            if (restart) {
                this.cancelJob();
            }
            throw initException;
        }
    }

    public void initCheckPointManager() throws CheckpointStorageException {
        this.checkpointManager = new CheckpointManager(this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.isStartWithSavePoint(), this.nodeEngine, this, this.checkpointPlanMap, this.jobCheckpointConfig, this.executorService, this.runningJobStateIMap);
    }

    private CheckpointConfig createJobCheckpointConfig(CheckpointConfig defaultCheckpointConfig, Map<String, Object> jobEnv) {
        CheckpointConfig jobCheckpointConfig = new CheckpointConfig();
        jobCheckpointConfig.setCheckpointTimeout(defaultCheckpointConfig.getCheckpointTimeout());
        jobCheckpointConfig.setCheckpointInterval(defaultCheckpointConfig.getCheckpointInterval());
        CheckpointStorageConfig jobCheckpointStorageConfig = new CheckpointStorageConfig();
        jobCheckpointStorageConfig.setStorage(defaultCheckpointConfig.getStorage().getStorage());
        jobCheckpointStorageConfig.setStoragePluginConfig(defaultCheckpointConfig.getStorage().getStoragePluginConfig());
        jobCheckpointStorageConfig.setMaxRetainedCheckpoints(defaultCheckpointConfig.getStorage().getMaxRetainedCheckpoints());
        jobCheckpointConfig.setStorage(jobCheckpointStorageConfig);
        if (jobEnv.containsKey(EnvCommonOptions.CHECKPOINT_INTERVAL.key())) {
            jobCheckpointConfig.setCheckpointInterval(Long.parseLong(jobEnv.get(EnvCommonOptions.CHECKPOINT_INTERVAL.key()).toString()));
        }
        return jobCheckpointConfig;
    }

    public void initStateFuture() {
        this.jobMasterCompleteFuture = new CompletableFuture();
        PassiveCompletableFuture<JobResult> jobStatusFuture = this.physicalPlan.initStateFuture();
        jobStatusFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(LOGGER, (v, t) -> {
            if (JobStatus.FAILING.equals((Object)v.getStatus())) {
                this.physicalPlan.updateJobState(JobStatus.FAILING, JobStatus.FAILED);
            }
            this.errorMessage = v.getError();
            JobResult jobResult = new JobResult(this.physicalPlan.getJobStatus(), v.getError());
            this.cleanJob();
            this.jobMasterCompleteFuture.complete(jobResult);
        }));
    }

    public void run() {
        try {
            if (!this.restore) {
                this.jobScheduler = new PipelineBaseScheduler(this.physicalPlan, this);
                this.scheduleFuture = CompletableFuture.runAsync(() -> this.jobScheduler.startScheduling(), this.executorService);
                LOGGER.info(String.format("Job %s waiting for scheduler finished", this.physicalPlan.getJobFullName()));
                this.scheduleFuture.join();
                LOGGER.info(String.format("%s scheduler finished", this.physicalPlan.getJobFullName()));
            }
        }
        catch (Throwable e) {
            LOGGER.severe(String.format("Job %s (%s) run error with: %s", this.physicalPlan.getJobImmutableInformation().getJobConfig().getName(), this.physicalPlan.getJobImmutableInformation().getJobId(), ExceptionUtils.getMessage(e)));
            this.cancelJob();
        }
        finally {
            this.jobMasterCompleteFuture.join();
        }
    }

    public void handleCheckpointError(long pipelineId, boolean neverRestore) {
        if (neverRestore) {
            this.neverNeedRestore();
        }
        this.physicalPlan.getPipelineList().forEach(pipeline -> {
            if ((long)pipeline.getPipelineLocation().getPipelineId() == pipelineId) {
                pipeline.handleCheckpointError();
            }
        });
    }

    private void removeJobIMap() {
        Long jobId = this.getJobImmutableInformation().getJobId();
        this.runningJobStateTimestampsIMap.remove(jobId);
        this.getPhysicalPlan().getPipelineList().forEach(pipeline -> {
            this.runningJobStateIMap.remove(pipeline.getPipelineLocation());
            this.runningJobStateTimestampsIMap.remove(pipeline.getPipelineLocation());
            pipeline.getCoordinatorVertexList().forEach(coordinator -> {
                this.runningJobStateIMap.remove(coordinator.getTaskGroupLocation());
                this.runningJobStateTimestampsIMap.remove(coordinator.getTaskGroupLocation());
            });
            pipeline.getPhysicalVertexList().forEach(task -> {
                this.runningJobStateIMap.remove(task.getTaskGroupLocation());
                this.runningJobStateTimestampsIMap.remove(task.getTaskGroupLocation());
            });
        });
        this.runningJobStateIMap.remove(jobId);
        this.runningJobInfoIMap.remove(jobId);
    }

    public JobDAGInfo getJobDAGInfo() {
        if (this.jobDAGInfo == null) {
            this.jobDAGInfo = DAGUtils.getJobDAGInfo(this.logicalDag, this.jobImmutableInformation, this.engineConfig.getCheckpointConfig(), this.isPhysicalDAGIInfo);
        }
        return this.jobDAGInfo;
    }

    public PassiveCompletableFuture<Void> reSchedulerPipeline(SubPlan subPlan) {
        if (this.jobScheduler == null) {
            this.jobScheduler = new PipelineBaseScheduler(this.physicalPlan, this);
        }
        return new PassiveCompletableFuture<Void>(this.jobScheduler.reSchedulerPipeline(subPlan));
    }

    public void releasePipelineResource(SubPlan subPlan) {
        LOGGER.info(String.format("release the pipeline %s resource", subPlan.getPipelineFullName()));
        this.resourceManager.releaseResources(this.jobImmutableInformation.getJobId(), Lists.newArrayList(this.ownedSlotProfilesIMap.get(subPlan.getPipelineLocation()).values())).join();
        this.ownedSlotProfilesIMap.remove(subPlan.getPipelineLocation());
    }

    public void cleanJob() {
        this.jobHistoryService.storeJobInfo(this.jobImmutableInformation.getJobId(), this.getJobDAGInfo());
        this.jobHistoryService.storeFinishedJobState(this);
        this.removeJobIMap();
    }

    public Address queryTaskGroupAddress(TaskGroupLocation taskGroupLocation) {
        SlotProfile slotProfile;
        PipelineLocation pipelineLocation = new PipelineLocation(taskGroupLocation.getJobId(), taskGroupLocation.getPipelineId());
        Map<TaskGroupLocation, SlotProfile> taskGroupLocationSlotProfileMap = this.ownedSlotProfilesIMap.get(pipelineLocation);
        if (null != taskGroupLocationSlotProfileMap && null != (slotProfile = taskGroupLocationSlotProfileMap.get(taskGroupLocation))) {
            return slotProfile.getWorker();
        }
        throw new IllegalArgumentException("can't find task group address from taskGroupLocation: " + taskGroupLocation);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void cancelJob() {
        this.neverNeedRestore();
        this.physicalPlan.cancelJob();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public CheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    public PassiveCompletableFuture<JobResult> getJobMasterCompleteFuture() {
        return new PassiveCompletableFuture<JobResult>(this.jobMasterCompleteFuture);
    }

    public JobImmutableInformation getJobImmutableInformation() {
        return this.jobImmutableInformation;
    }

    public JobStatus getJobStatus() {
        return this.physicalPlan.getJobStatus();
    }

    public List<RawJobMetrics> getCurrJobMetrics() {
        HashMap<TaskGroupLocation, Address> taskGroupLocationSlotProfileMap = new HashMap<TaskGroupLocation, Address>();
        this.ownedSlotProfilesIMap.forEach((pipelineLocation, map2) -> {
            if (pipelineLocation.getJobId() == this.getJobImmutableInformation().getJobId()) {
                map2.forEach((taskGroupLocation, slotProfile) -> {
                    if (taskGroupLocation.getJobId() == this.getJobImmutableInformation().getJobId()) {
                        taskGroupLocationSlotProfileMap.put((TaskGroupLocation)taskGroupLocation, slotProfile.getWorker());
                    }
                });
            }
        });
        return this.getCurrJobMetrics(taskGroupLocationSlotProfileMap);
    }

    public List<RawJobMetrics> getCurrJobMetrics(List<PipelineLocation> pipelineLocations) {
        HashMap<TaskGroupLocation, Address> taskGroupLocationSlotProfileMap = new HashMap<TaskGroupLocation, Address>();
        this.ownedSlotProfilesIMap.forEach((pipelineLocation, map2) -> {
            if (pipelineLocations.contains(pipelineLocation)) {
                map2.forEach((taskGroupLocation, slotProfile) -> {
                    if (taskGroupLocation.getJobId() == this.getJobImmutableInformation().getJobId()) {
                        taskGroupLocationSlotProfileMap.put((TaskGroupLocation)taskGroupLocation, slotProfile.getWorker());
                    }
                });
            }
        });
        return this.getCurrJobMetrics(taskGroupLocationSlotProfileMap);
    }

    public List<RawJobMetrics> getCurrJobMetrics(Map<TaskGroupLocation, Address> taskGroupLocationSlotProfileMap) {
        HashMap<Address, List> taskGroupLocationMap = new HashMap<Address, List>();
        for (Map.Entry<TaskGroupLocation, Address> entry : taskGroupLocationSlotProfileMap.entrySet()) {
            taskGroupLocationMap.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        ArrayList<RawJobMetrics> metrics = new ArrayList<RawJobMetrics>();
        taskGroupLocationMap.forEach((address, taskGroupLocations) -> {
            try {
                if (this.nodeEngine.getClusterService().getMember((Address)address) != null) {
                    RawJobMetrics rawJobMetrics = (RawJobMetrics)NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new GetTaskGroupMetricsOperation((List<TaskGroupLocation>)taskGroupLocations), address).get();
                    metrics.add(rawJobMetrics);
                }
            }
            catch (HazelcastInstanceNotActiveException e) {
                LOGGER.warning(String.format("%s get current job metrics with exception: %s.", Arrays.toString(taskGroupLocations.toArray()), ExceptionUtils.getMessage(e)));
            }
            catch (Exception e) {
                throw new SeaTunnelEngineException(ExceptionUtils.getMessage(e));
            }
        });
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePipelineMetricsToHistory(PipelineLocation pipelineLocation) {
        List<RawJobMetrics> currJobMetrics = this.getCurrJobMetrics(Collections.singletonList(pipelineLocation));
        JobMetrics jobMetrics = JobMetricsUtil.toJobMetrics(currJobMetrics);
        long jobId = this.getJobImmutableInformation().getJobId();
        JobMaster jobMaster = this;
        synchronized (jobMaster) {
            this.jobHistoryService.storeFinishedPipelineMetrics(jobId, jobMetrics);
        }
        this.cleanTaskGroupContext(pipelineLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetricsContext(PipelineLocation pipelineLocation, PipelineStatus pipelineStatus) {
        if (pipelineStatus.equals((Object)PipelineStatus.FINISHED) && !this.checkpointManager.isSavePointEnd() || pipelineStatus.equals((Object)PipelineStatus.CANCELED)) {
            try {
                this.metricsImap.lock(Constant.IMAP_RUNNING_JOB_METRICS_KEY);
                HashMap<TaskLocation, SeaTunnelMetricsContext> centralMap = this.metricsImap.get(Constant.IMAP_RUNNING_JOB_METRICS_KEY);
                if (centralMap != null) {
                    List<TaskLocation> collect2 = centralMap.keySet().stream().filter(taskLocation -> taskLocation.getTaskGroupLocation().getPipelineLocation().equals(pipelineLocation)).collect(Collectors.toList());
                    collect2.forEach(centralMap::remove);
                    this.metricsImap.put(Constant.IMAP_RUNNING_JOB_METRICS_KEY, centralMap);
                }
            }
            finally {
                this.metricsImap.unlock(Constant.IMAP_RUNNING_JOB_METRICS_KEY);
            }
        }
    }

    private void cleanTaskGroupContext(PipelineLocation pipelineLocation) {
        Map<TaskGroupLocation, SlotProfile> slotProfileMap = this.ownedSlotProfilesIMap.get(pipelineLocation);
        if (slotProfileMap == null) {
            return;
        }
        slotProfileMap.forEach((taskGroupLocation, slotProfile) -> {
            try {
                if (this.nodeEngine.getClusterService().getMember(slotProfile.getWorker()) != null) {
                    NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new CleanTaskGroupContextOperation((TaskGroupLocation)taskGroupLocation), slotProfile.getWorker()).get();
                }
            }
            catch (HazelcastInstanceNotActiveException e) {
                LOGGER.warning(String.format("%s clean TaskGroupContext with exception: %s.", taskGroupLocation, ExceptionUtils.getMessage(e)));
            }
            catch (Exception e) {
                throw new SeaTunnelException(e.getMessage());
            }
        });
    }

    public PhysicalPlan getPhysicalPlan() {
        return this.physicalPlan;
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        this.physicalPlan.getPipelineList().forEach(pipeline -> {
            if (pipeline.getPipelineLocation().getPipelineId() != taskExecutionState.getTaskGroupLocation().getPipelineId()) {
                return;
            }
            pipeline.getCoordinatorVertexList().forEach(task -> {
                if (!task.getTaskGroupLocation().equals(taskExecutionState.getTaskGroupLocation())) {
                    return;
                }
                task.updateTaskExecutionState(taskExecutionState);
            });
            pipeline.getPhysicalVertexList().forEach(task -> {
                if (!task.getTaskGroupLocation().equals(taskExecutionState.getTaskGroupLocation())) {
                    return;
                }
                task.updateTaskExecutionState(taskExecutionState);
            });
        });
    }

    public CompletableFuture<Void> savePoint() {
        LOGGER.info(String.format("Begin do save point for Job %s (%s) ", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId()));
        PassiveCompletableFuture<CompletedCheckpoint>[] passiveCompletableFutures = this.checkpointManager.triggerSavePoints();
        return CompletableFuture.allOf(passiveCompletableFutures);
    }

    public Map<TaskGroupLocation, SlotProfile> getOwnedSlotProfiles(PipelineLocation pipelineLocation) {
        return this.ownedSlotProfilesIMap.get(pipelineLocation);
    }

    public void setOwnedSlotProfiles(@NonNull PipelineLocation pipelineLocation, @NonNull Map<TaskGroupLocation, SlotProfile> pipelineOwnedSlotProfiles) {
        if (pipelineLocation == null) {
            throw new NullPointerException("pipelineLocation is marked non-null but is null");
        }
        if (pipelineOwnedSlotProfiles == null) {
            throw new NullPointerException("pipelineOwnedSlotProfiles is marked non-null but is null");
        }
        this.ownedSlotProfilesIMap.put(pipelineLocation, pipelineOwnedSlotProfiles);
        try {
            RetryUtils.retryWithException(() -> pipelineOwnedSlotProfiles.equals(this.ownedSlotProfilesIMap.get(pipelineLocation)), new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof NullPointerException && this.isRunning, 2000L));
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException("Can not sync pipeline owned slot profiles with IMap", e);
        }
    }

    public SlotProfile getOwnedSlotProfiles(@NonNull TaskGroupLocation taskGroupLocation) {
        if (taskGroupLocation == null) {
            throw new NullPointerException("taskGroupLocation is marked non-null but is null");
        }
        return this.ownedSlotProfilesIMap.get(new PipelineLocation(taskGroupLocation.getJobId(), taskGroupLocation.getPipelineId())).get(taskGroupLocation);
    }

    public CompletableFuture<Void> getScheduleFuture() {
        return this.scheduleFuture;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void interrupt() {
        this.isRunning = false;
        this.jobMasterCompleteFuture.cancel(true);
    }

    public void markRestore() {
        this.restore = true;
    }

    public void neverNeedRestore() {
        this.needRestore = false;
    }

    public boolean isNeedRestore() {
        return this.needRestore;
    }
}

