/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.PipelineExecutionState;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorStatus;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.master.JobMaster;

public class SubPlan {
    private static final ILogger LOGGER = Logger.getLogger(SubPlan.class);
    public static final int PIPELINE_MAX_RESTORE_NUM = 3;
    private final List<PhysicalVertex> physicalVertexList;
    private final List<PhysicalVertex> coordinatorVertexList;
    private final int pipelineId;
    private final AtomicInteger finishedTaskNum = new AtomicInteger(0);
    private final AtomicInteger canceledTaskNum = new AtomicInteger(0);
    private final AtomicInteger failedTaskNum = new AtomicInteger(0);
    private final String pipelineFullName;
    private final IMap<Object, Object> runningJobStateIMap;
    private final IMap<Object, Long[]> runningJobStateTimestampsIMap;
    private CompletableFuture<PipelineExecutionState> pipelineFuture;
    private final PipelineLocation pipelineLocation;
    private AtomicReference<String> errorByPhysicalVertex = new AtomicReference();
    private final ExecutorService executorService;
    private JobMaster jobMaster;
    private PassiveCompletableFuture<Void> reSchedulerPipelineFuture;
    private Integer pipelineRestoreNum;
    private final Object restoreLock = new Object();
    private volatile PipelineStatus currPipelineStatus = PipelineStatus.INITIALIZING;

    public SubPlan(int pipelineId, int totalPipelineNum, long initializationTimestamp, @NonNull List<PhysicalVertex> physicalVertexList, @NonNull List<PhysicalVertex> coordinatorVertexList, @NonNull JobImmutableInformation jobImmutableInformation, @NonNull ExecutorService executorService, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap) {
        if (physicalVertexList == null) {
            throw new NullPointerException("physicalVertexList is marked non-null but is null");
        }
        if (coordinatorVertexList == null) {
            throw new NullPointerException("coordinatorVertexList is marked non-null but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked non-null but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked non-null but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked non-null but is null");
        }
        this.pipelineId = pipelineId;
        this.pipelineLocation = new PipelineLocation(jobImmutableInformation.getJobId(), pipelineId);
        this.pipelineFuture = new CompletableFuture();
        this.physicalVertexList = physicalVertexList;
        this.coordinatorVertexList = coordinatorVertexList;
        this.pipelineRestoreNum = 0;
        Long[] stateTimestamps = new Long[PipelineStatus.values().length];
        if (runningJobStateTimestampsIMap.get(this.pipelineLocation) == null) {
            stateTimestamps[PipelineStatus.INITIALIZING.ordinal()] = initializationTimestamp;
            runningJobStateTimestampsIMap.put(this.pipelineLocation, stateTimestamps);
        }
        if (runningJobStateIMap.get(this.pipelineLocation) == null) {
            stateTimestamps[PipelineStatus.CREATED.ordinal()] = System.currentTimeMillis();
            runningJobStateTimestampsIMap.put(this.pipelineLocation, stateTimestamps);
            runningJobStateIMap.put(this.pipelineLocation, PipelineStatus.CREATED);
        }
        this.currPipelineStatus = (PipelineStatus)((Object)runningJobStateIMap.get(this.pipelineLocation));
        this.pipelineFullName = String.format("Job %s (%s), Pipeline: [(%d/%d)]", jobImmutableInformation.getJobConfig().getName(), jobImmutableInformation.getJobId(), pipelineId, totalPipelineNum);
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
        this.executorService = executorService;
    }

    public synchronized PassiveCompletableFuture<PipelineExecutionState> initStateFuture() {
        this.errorByPhysicalVertex = new AtomicReference();
        this.physicalVertexList.forEach(physicalVertex -> this.addPhysicalVertexCallBack(physicalVertex.initStateFuture()));
        this.coordinatorVertexList.forEach(coordinator -> this.addPhysicalVertexCallBack(coordinator.initStateFuture()));
        this.pipelineFuture = new CompletableFuture();
        return new PassiveCompletableFuture<PipelineExecutionState>(this.pipelineFuture);
    }

    private void addPhysicalVertexCallBack(PassiveCompletableFuture<TaskExecutionState> future) {
        future.thenAcceptAsync(executionState -> {
            try {
                if (ExecutionState.CANCELED.equals(executionState.getExecutionState())) {
                    this.canceledTaskNum.incrementAndGet();
                } else if (ExecutionState.FAILED.equals(executionState.getExecutionState())) {
                    LOGGER.severe(String.format("Task %s Failed in %s, Begin to cancel other tasks in this pipeline.", executionState.getTaskGroupLocation(), this.getPipelineFullName()));
                    this.failedTaskNum.incrementAndGet();
                    this.errorByPhysicalVertex.compareAndSet(null, executionState.getThrowableMsg());
                    this.cancelPipeline();
                }
                if (this.finishedTaskNum.incrementAndGet() == this.physicalVertexList.size() + this.coordinatorVertexList.size()) {
                    PipelineStatus pipelineEndState = this.getPipelineEndState();
                    LOGGER.info(String.format("%s end with state %s", new Object[]{this.pipelineFullName, pipelineEndState}));
                    if (!this.checkNeedRestore(pipelineEndState)) {
                        this.subPlanDone(pipelineEndState);
                        this.turnToEndState(pipelineEndState);
                        this.pipelineFuture.complete(new PipelineExecutionState(this.pipelineId, pipelineEndState, this.errorByPhysicalVertex.get()));
                    } else {
                        this.turnToEndState(pipelineEndState);
                        if (this.prepareRestorePipeline()) {
                            this.restorePipeline();
                        } else {
                            this.pipelineFuture.complete(new PipelineExecutionState(this.pipelineId, pipelineEndState, this.errorByPhysicalVertex.get()));
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.severe(String.format("Never come here. handle %s %s error", executionState.getTaskGroupLocation(), executionState.getExecutionState()), e);
            }
        }, (Executor)this.executorService);
    }

    private PipelineStatus getPipelineEndState() {
        PipelineStatus pipelineStatus = null;
        if (this.failedTaskNum.get() > 0) {
            pipelineStatus = PipelineStatus.FAILED;
            this.jobMaster.getCheckpointManager().cancelCheckpoint(this.getPipelineId()).join();
        } else if (this.canceledTaskNum.get() > 0) {
            pipelineStatus = PipelineStatus.CANCELED;
            CheckpointCoordinatorState checkpointCoordinatorState = (CheckpointCoordinatorState)this.jobMaster.getCheckpointManager().cancelCheckpoint(this.getPipelineId()).join();
            if (CheckpointCoordinatorStatus.FAILED.equals((Object)checkpointCoordinatorState.getCheckpointCoordinatorStatus())) {
                pipelineStatus = PipelineStatus.FAILED;
                this.errorByPhysicalVertex.compareAndSet(null, checkpointCoordinatorState.getThrowableMsg());
            }
        } else {
            pipelineStatus = PipelineStatus.FINISHED;
            CheckpointCoordinatorState checkpointCoordinatorState = (CheckpointCoordinatorState)this.jobMaster.getCheckpointManager().waitCheckpointCoordinatorComplete(this.getPipelineId()).join();
            if (CheckpointCoordinatorStatus.FAILED.equals((Object)checkpointCoordinatorState.getCheckpointCoordinatorStatus())) {
                pipelineStatus = PipelineStatus.FAILED;
                this.errorByPhysicalVertex.compareAndSet(null, checkpointCoordinatorState.getThrowableMsg());
            } else if (CheckpointCoordinatorStatus.CANCELED.equals((Object)checkpointCoordinatorState.getCheckpointCoordinatorStatus())) {
                pipelineStatus = PipelineStatus.CANCELED;
                this.errorByPhysicalVertex.compareAndSet(null, checkpointCoordinatorState.getThrowableMsg());
            }
        }
        return pipelineStatus;
    }

    private boolean checkNeedRestore(PipelineStatus pipelineStatus) {
        return this.canRestorePipeline() && !PipelineStatus.FINISHED.equals((Object)pipelineStatus);
    }

    private void notifyCheckpointManagerPipelineEnd(PipelineStatus pipelineStatus) {
        if (this.jobMaster.getCheckpointManager() == null) {
            return;
        }
        this.jobMaster.getCheckpointManager().listenPipeline(this.getPipelineLocation().getPipelineId(), pipelineStatus).join();
    }

    private void subPlanDone(PipelineStatus pipelineStatus) throws Exception {
        RetryUtils.retryWithException(() -> {
            this.jobMaster.savePipelineMetricsToHistory(this.getPipelineLocation());
            this.jobMaster.removeMetricsContext(this.getPipelineLocation(), pipelineStatus);
            this.jobMaster.releasePipelineResource(this);
            this.notifyCheckpointManagerPipelineEnd(pipelineStatus);
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException(exception), 2000L));
    }

    public boolean canRestorePipeline() {
        return this.jobMaster.isNeedRestore() && this.getPipelineRestoreNum() < 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnToEndState(@NonNull PipelineStatus endState) throws Exception {
        if (endState == null) {
            throw new NullPointerException("endState is marked non-null but is null");
        }
        SubPlan subPlan = this;
        synchronized (subPlan) {
            if (this.currPipelineStatus.isEndState() && !endState.isEndState()) {
                String message = "Pipeline is trying to leave terminal state " + (Object)((Object)this.currPipelineStatus);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (!endState.isEndState()) {
                String message = "Need a end state, not " + (Object)((Object)endState);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            RetryUtils.retryWithException(() -> {
                this.updateStateTimestamps(endState);
                this.runningJobStateIMap.set(this.pipelineLocation, (Object)endState);
                return null;
            }, new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException(exception), 2000L));
            this.currPipelineStatus = endState;
            LOGGER.info(String.format("%s turn to end state %s.", new Object[]{this.pipelineFullName, this.currPipelineStatus}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePipelineState(@NonNull PipelineStatus current, @NonNull PipelineStatus targetState) throws Exception {
        if (current == null) {
            throw new NullPointerException("current is marked non-null but is null");
        }
        if (targetState == null) {
            throw new NullPointerException("targetState is marked non-null but is null");
        }
        SubPlan subPlan = this;
        synchronized (subPlan) {
            if (current.isEndState()) {
                String message = "Pipeline is trying to leave terminal state " + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (PipelineStatus.SCHEDULED.equals((Object)targetState) && !PipelineStatus.CREATED.equals((Object)current)) {
                String message = "Only [CREATED] pipeline can turn to [SCHEDULED]" + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (PipelineStatus.DEPLOYING.equals((Object)targetState) && !PipelineStatus.SCHEDULED.equals((Object)current)) {
                String message = "Only [SCHEDULED] pipeline can turn to [DEPLOYING]" + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (PipelineStatus.RUNNING.equals((Object)targetState) && !PipelineStatus.DEPLOYING.equals((Object)current)) {
                String message = "Only [DEPLOYING] pipeline can turn to [RUNNING]" + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (current.equals(this.runningJobStateIMap.get(this.pipelineLocation))) {
                LOGGER.info(String.format("%s turn from state %s to %s.", new Object[]{this.pipelineFullName, current, targetState}));
                RetryUtils.retryWithException(() -> {
                    this.updateStateTimestamps(targetState);
                    this.runningJobStateIMap.set(this.pipelineLocation, (Object)targetState);
                    return null;
                }, new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException(exception), 2000L));
                this.currPipelineStatus = targetState;
                return true;
            }
            return false;
        }
    }

    public synchronized void cancelPipeline() {
        for (int i = 0; i < 10; ++i) {
            try {
                LOGGER.warning("start cancel job " + this.pipelineFullName + " count = " + i);
                if (this.getPipelineState().isEndState()) {
                    LOGGER.warning(String.format("%s is in end state %s, can not be cancel", new Object[]{this.pipelineFullName, this.getPipelineState()}));
                }
                if (!PipelineStatus.CANCELING.equals(this.runningJobStateIMap.get(this.pipelineLocation))) {
                    this.updatePipelineState(this.getPipelineState(), PipelineStatus.CANCELING);
                }
                this.cancelCheckpointCoordinator();
                Optional<Exception> optionalException = this.cancelPipelineTasks();
                if (optionalException.isPresent()) {
                    throw optionalException.get();
                }
                break;
            }
            catch (HazelcastInstanceNotActiveException | OperationTimeoutException | InterruptedException e) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.warning(String.format("%s cancel error will retry", this.pipelineFullName), e);
                continue;
            }
            catch (Throwable e) {
                LOGGER.warning(String.format("%s cancel error", this.pipelineFullName), e);
                break;
            }
        }
    }

    private void cancelCheckpointCoordinator() {
        if (this.jobMaster.getCheckpointManager() != null) {
            this.jobMaster.getCheckpointManager().cancelCheckpoint(this.pipelineId).join();
        }
    }

    private Optional<Exception> cancelPipelineTasks() {
        List<CompletableFuture> coordinatorCancelList = this.coordinatorVertexList.stream().map(this::cancelTask).filter(Objects::nonNull).collect(Collectors.toList());
        List taskCancelList = this.physicalVertexList.stream().map(this::cancelTask).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            coordinatorCancelList.addAll(taskCancelList);
            CompletableFuture<Void> voidCompletableFuture = CompletableFuture.allOf(coordinatorCancelList.toArray(new CompletableFuture[0]));
            voidCompletableFuture.get();
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.severe(String.format("%s cancel error with exception: %s", this.pipelineFullName, ExceptionUtils.getMessage(e)));
            return Optional.of(e);
        }
    }

    private CompletableFuture<Void> cancelTask(@NonNull PhysicalVertex task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (!task.getExecutionState().isEndState() && !ExecutionState.CANCELING.equals(task.getExecutionState())) {
            return CompletableFuture.supplyAsync(() -> {
                task.cancel();
                return null;
            }, this.executorService);
        }
        return null;
    }

    private synchronized void reset() throws Exception {
        this.resetPipelineState();
        this.finishedTaskNum.set(0);
        this.canceledTaskNum.set(0);
        this.failedTaskNum.set(0);
        this.coordinatorVertexList.forEach(PhysicalVertex::reset);
        this.physicalVertexList.forEach(PhysicalVertex::reset);
    }

    private void updateStateTimestamps(@NonNull PipelineStatus targetState) {
        if (targetState == null) {
            throw new NullPointerException("targetState is marked non-null but is null");
        }
        Long[] stateTimestamps = this.runningJobStateTimestampsIMap.get(this.pipelineLocation);
        stateTimestamps[targetState.ordinal()] = System.currentTimeMillis();
        this.runningJobStateTimestampsIMap.set(this.pipelineLocation, stateTimestamps);
    }

    private void resetPipelineState() throws Exception {
        RetryUtils.retryWithException(() -> {
            PipelineStatus pipelineState = this.getPipelineState();
            if (!pipelineState.isEndState()) {
                String message = String.format("%s reset state failed, only end state can be reset, current is %s", new Object[]{this.getPipelineFullName(), pipelineState});
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            LOGGER.info(String.format("Reset pipeline %s state to %s", new Object[]{this.getPipelineFullName(), PipelineStatus.CREATED}));
            this.updateStateTimestamps(PipelineStatus.CREATED);
            this.runningJobStateIMap.set(this.pipelineLocation, (Object)PipelineStatus.CREATED);
            this.currPipelineStatus = PipelineStatus.CREATED;
            LOGGER.info(String.format("Reset pipeline %s state to %s complete", new Object[]{this.getPipelineFullName(), PipelineStatus.CREATED}));
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException(exception), 2000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareRestorePipeline() {
        Object object = this.restoreLock;
        synchronized (object) {
            try {
                Integer n = this.pipelineRestoreNum;
                Integer n2 = this.pipelineRestoreNum = Integer.valueOf(this.pipelineRestoreNum + 1);
                LOGGER.info(String.format("Restore time %s, pipeline %s", this.pipelineRestoreNum + "", this.pipelineFullName));
                if (this.jobMaster.getScheduleFuture() != null) {
                    this.jobMaster.getScheduleFuture().join();
                }
                if (this.reSchedulerPipelineFuture != null) {
                    this.reSchedulerPipelineFuture.join();
                }
                this.reset();
                this.jobMaster.getPhysicalPlan().addPipelineEndCallback(this);
                return true;
            }
            catch (Throwable e) {
                if (this.currPipelineStatus.isEndState()) {
                    return false;
                }
                this.jobMaster.getPhysicalPlan().addPipelineEndCallback(this);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePipeline() {
        Object object = this.restoreLock;
        synchronized (object) {
            try {
                if (this.jobMaster.getCheckpointManager().isCompletedPipeline(this.pipelineId)) {
                    this.forcePipelineFinish();
                }
                this.jobMaster.getCheckpointManager().reportedPipelineRunning(this.pipelineId, false);
                this.reSchedulerPipelineFuture = this.jobMaster.reSchedulerPipeline(this);
                if (this.reSchedulerPipelineFuture != null) {
                    this.reSchedulerPipelineFuture.join();
                }
            }
            catch (Throwable e) {
                LOGGER.severe(String.format("Restore pipeline %s error with exception: ", this.pipelineFullName), e);
                this.cancelPipeline();
            }
        }
    }

    private void forcePipelineFinish() {
        this.coordinatorVertexList.forEach(coordinator -> coordinator.updateTaskExecutionState(new TaskExecutionState(coordinator.getTaskGroupLocation(), ExecutionState.FINISHED)));
        this.physicalVertexList.forEach(task -> task.updateTaskExecutionState(new TaskExecutionState(task.getTaskGroupLocation(), ExecutionState.FINISHED)));
    }

    public synchronized void restorePipelineState() {
        if (this.getPipelineState().ordinal() < PipelineStatus.RUNNING.ordinal()) {
            this.cancelPipelineTasks();
        } else if (PipelineStatus.CANCELING.equals((Object)this.getPipelineState())) {
            this.cancelPipelineTasks();
        } else if (PipelineStatus.RUNNING.equals((Object)this.getPipelineState())) {
            this.jobMaster.getCheckpointManager().reportedPipelineRunning(this.getPipelineLocation().getPipelineId(), true);
        }
    }

    public List<PhysicalVertex> getPhysicalVertexList() {
        return this.physicalVertexList;
    }

    public List<PhysicalVertex> getCoordinatorVertexList() {
        return this.coordinatorVertexList;
    }

    public String getPipelineFullName() {
        return this.pipelineFullName;
    }

    public PipelineStatus getPipelineState() {
        return this.currPipelineStatus;
    }

    public PipelineLocation getPipelineLocation() {
        return this.pipelineLocation;
    }

    public void setJobMaster(JobMaster jobMaster) {
        this.jobMaster = jobMaster;
        this.coordinatorVertexList.forEach(coordinator -> coordinator.setJobMaster(jobMaster));
        this.physicalVertexList.forEach(task -> task.setJobMaster(jobMaster));
    }

    public int getPipelineRestoreNum() {
        return this.pipelineRestoreNum;
    }

    public void handleCheckpointError() {
        LOGGER.warning(String.format("%s checkpoint have error, cancel the pipeline", this.getPipelineFullName()));
        this.cancelPipeline();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public AtomicInteger getFinishedTaskNum() {
        return this.finishedTaskNum;
    }

    public AtomicInteger getCanceledTaskNum() {
        return this.canceledTaskNum;
    }

    public AtomicInteger getFailedTaskNum() {
        return this.failedTaskNum;
    }

    public IMap<Object, Object> getRunningJobStateIMap() {
        return this.runningJobStateIMap;
    }

    public IMap<Object, Long[]> getRunningJobStateTimestampsIMap() {
        return this.runningJobStateTimestampsIMap;
    }

    public CompletableFuture<PipelineExecutionState> getPipelineFuture() {
        return this.pipelineFuture;
    }

    public AtomicReference<String> getErrorByPhysicalVertex() {
        return this.errorByPhysicalVertex;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public JobMaster getJobMaster() {
        return this.jobMaster;
    }

    public PassiveCompletableFuture<Void> getReSchedulerPipelineFuture() {
        return this.reSchedulerPipelineFuture;
    }

    public Object getRestoreLock() {
        return this.restoreLock;
    }

    public PipelineStatus getCurrPipelineStatus() {
        return this.currPipelineStatus;
    }

    public void setPipelineFuture(CompletableFuture<PipelineExecutionState> pipelineFuture) {
        this.pipelineFuture = pipelineFuture;
    }

    public void setErrorByPhysicalVertex(AtomicReference<String> errorByPhysicalVertex) {
        this.errorByPhysicalVertex = errorByPhysicalVertex;
    }

    public void setReSchedulerPipelineFuture(PassiveCompletableFuture<Void> reSchedulerPipelineFuture) {
        this.reSchedulerPipelineFuture = reSchedulerPipelineFuture;
    }

    public void setPipelineRestoreNum(Integer pipelineRestoreNum) {
        this.pipelineRestoreNum = pipelineRestoreNum;
    }

    public void setCurrPipelineStatus(PipelineStatus currPipelineStatus) {
        this.currPipelineStatus = currPipelineStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubPlan)) {
            return false;
        }
        SubPlan other = (SubPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPipelineId() != other.getPipelineId()) {
            return false;
        }
        if (this.getPipelineRestoreNum() != other.getPipelineRestoreNum()) {
            return false;
        }
        List<PhysicalVertex> this$physicalVertexList = this.getPhysicalVertexList();
        List<PhysicalVertex> other$physicalVertexList = other.getPhysicalVertexList();
        if (this$physicalVertexList == null ? other$physicalVertexList != null : !((Object)this$physicalVertexList).equals(other$physicalVertexList)) {
            return false;
        }
        List<PhysicalVertex> this$coordinatorVertexList = this.getCoordinatorVertexList();
        List<PhysicalVertex> other$coordinatorVertexList = other.getCoordinatorVertexList();
        if (this$coordinatorVertexList == null ? other$coordinatorVertexList != null : !((Object)this$coordinatorVertexList).equals(other$coordinatorVertexList)) {
            return false;
        }
        AtomicInteger this$finishedTaskNum = this.getFinishedTaskNum();
        AtomicInteger other$finishedTaskNum = other.getFinishedTaskNum();
        if (this$finishedTaskNum == null ? other$finishedTaskNum != null : !this$finishedTaskNum.equals(other$finishedTaskNum)) {
            return false;
        }
        AtomicInteger this$canceledTaskNum = this.getCanceledTaskNum();
        AtomicInteger other$canceledTaskNum = other.getCanceledTaskNum();
        if (this$canceledTaskNum == null ? other$canceledTaskNum != null : !this$canceledTaskNum.equals(other$canceledTaskNum)) {
            return false;
        }
        AtomicInteger this$failedTaskNum = this.getFailedTaskNum();
        AtomicInteger other$failedTaskNum = other.getFailedTaskNum();
        if (this$failedTaskNum == null ? other$failedTaskNum != null : !this$failedTaskNum.equals(other$failedTaskNum)) {
            return false;
        }
        String this$pipelineFullName = this.getPipelineFullName();
        String other$pipelineFullName = other.getPipelineFullName();
        if (this$pipelineFullName == null ? other$pipelineFullName != null : !this$pipelineFullName.equals(other$pipelineFullName)) {
            return false;
        }
        IMap<Object, Object> this$runningJobStateIMap = this.getRunningJobStateIMap();
        IMap<Object, Object> other$runningJobStateIMap = other.getRunningJobStateIMap();
        if (this$runningJobStateIMap == null ? other$runningJobStateIMap != null : !this$runningJobStateIMap.equals(other$runningJobStateIMap)) {
            return false;
        }
        IMap<Object, Long[]> this$runningJobStateTimestampsIMap = this.getRunningJobStateTimestampsIMap();
        IMap<Object, Long[]> other$runningJobStateTimestampsIMap = other.getRunningJobStateTimestampsIMap();
        if (this$runningJobStateTimestampsIMap == null ? other$runningJobStateTimestampsIMap != null : !this$runningJobStateTimestampsIMap.equals(other$runningJobStateTimestampsIMap)) {
            return false;
        }
        CompletableFuture<PipelineExecutionState> this$pipelineFuture = this.getPipelineFuture();
        CompletableFuture<PipelineExecutionState> other$pipelineFuture = other.getPipelineFuture();
        if (this$pipelineFuture == null ? other$pipelineFuture != null : !this$pipelineFuture.equals(other$pipelineFuture)) {
            return false;
        }
        PipelineLocation this$pipelineLocation = this.getPipelineLocation();
        PipelineLocation other$pipelineLocation = other.getPipelineLocation();
        if (this$pipelineLocation == null ? other$pipelineLocation != null : !((Object)this$pipelineLocation).equals(other$pipelineLocation)) {
            return false;
        }
        AtomicReference<String> this$errorByPhysicalVertex = this.getErrorByPhysicalVertex();
        AtomicReference<String> other$errorByPhysicalVertex = other.getErrorByPhysicalVertex();
        if (this$errorByPhysicalVertex == null ? other$errorByPhysicalVertex != null : !this$errorByPhysicalVertex.equals(other$errorByPhysicalVertex)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        JobMaster this$jobMaster = this.getJobMaster();
        JobMaster other$jobMaster = other.getJobMaster();
        if (this$jobMaster == null ? other$jobMaster != null : !this$jobMaster.equals(other$jobMaster)) {
            return false;
        }
        PassiveCompletableFuture<Void> this$reSchedulerPipelineFuture = this.getReSchedulerPipelineFuture();
        PassiveCompletableFuture<Void> other$reSchedulerPipelineFuture = other.getReSchedulerPipelineFuture();
        if (this$reSchedulerPipelineFuture == null ? other$reSchedulerPipelineFuture != null : !this$reSchedulerPipelineFuture.equals(other$reSchedulerPipelineFuture)) {
            return false;
        }
        Object this$restoreLock = this.getRestoreLock();
        Object other$restoreLock = other.getRestoreLock();
        if (this$restoreLock == null ? other$restoreLock != null : !this$restoreLock.equals(other$restoreLock)) {
            return false;
        }
        PipelineStatus this$currPipelineStatus = this.getCurrPipelineStatus();
        PipelineStatus other$currPipelineStatus = other.getCurrPipelineStatus();
        return !(this$currPipelineStatus == null ? other$currPipelineStatus != null : !((Object)((Object)this$currPipelineStatus)).equals((Object)other$currPipelineStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubPlan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getPipelineId();
        result2 = result2 * 59 + this.getPipelineRestoreNum();
        List<PhysicalVertex> $physicalVertexList = this.getPhysicalVertexList();
        result2 = result2 * 59 + ($physicalVertexList == null ? 43 : ((Object)$physicalVertexList).hashCode());
        List<PhysicalVertex> $coordinatorVertexList = this.getCoordinatorVertexList();
        result2 = result2 * 59 + ($coordinatorVertexList == null ? 43 : ((Object)$coordinatorVertexList).hashCode());
        AtomicInteger $finishedTaskNum = this.getFinishedTaskNum();
        result2 = result2 * 59 + ($finishedTaskNum == null ? 43 : $finishedTaskNum.hashCode());
        AtomicInteger $canceledTaskNum = this.getCanceledTaskNum();
        result2 = result2 * 59 + ($canceledTaskNum == null ? 43 : $canceledTaskNum.hashCode());
        AtomicInteger $failedTaskNum = this.getFailedTaskNum();
        result2 = result2 * 59 + ($failedTaskNum == null ? 43 : $failedTaskNum.hashCode());
        String $pipelineFullName = this.getPipelineFullName();
        result2 = result2 * 59 + ($pipelineFullName == null ? 43 : $pipelineFullName.hashCode());
        IMap<Object, Object> $runningJobStateIMap = this.getRunningJobStateIMap();
        result2 = result2 * 59 + ($runningJobStateIMap == null ? 43 : $runningJobStateIMap.hashCode());
        IMap<Object, Long[]> $runningJobStateTimestampsIMap = this.getRunningJobStateTimestampsIMap();
        result2 = result2 * 59 + ($runningJobStateTimestampsIMap == null ? 43 : $runningJobStateTimestampsIMap.hashCode());
        CompletableFuture<PipelineExecutionState> $pipelineFuture = this.getPipelineFuture();
        result2 = result2 * 59 + ($pipelineFuture == null ? 43 : $pipelineFuture.hashCode());
        PipelineLocation $pipelineLocation = this.getPipelineLocation();
        result2 = result2 * 59 + ($pipelineLocation == null ? 43 : ((Object)$pipelineLocation).hashCode());
        AtomicReference<String> $errorByPhysicalVertex = this.getErrorByPhysicalVertex();
        result2 = result2 * 59 + ($errorByPhysicalVertex == null ? 43 : $errorByPhysicalVertex.hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result2 = result2 * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        JobMaster $jobMaster = this.getJobMaster();
        result2 = result2 * 59 + ($jobMaster == null ? 43 : $jobMaster.hashCode());
        PassiveCompletableFuture<Void> $reSchedulerPipelineFuture = this.getReSchedulerPipelineFuture();
        result2 = result2 * 59 + ($reSchedulerPipelineFuture == null ? 43 : $reSchedulerPipelineFuture.hashCode());
        Object $restoreLock = this.getRestoreLock();
        result2 = result2 * 59 + ($restoreLock == null ? 43 : $restoreLock.hashCode());
        PipelineStatus $currPipelineStatus = this.getCurrPipelineStatus();
        result2 = result2 * 59 + ($currPipelineStatus == null ? 43 : ((Object)((Object)$currPipelineStatus)).hashCode());
        return result2;
    }

    public String toString() {
        return "SubPlan(physicalVertexList=" + this.getPhysicalVertexList() + ", coordinatorVertexList=" + this.getCoordinatorVertexList() + ", pipelineId=" + this.getPipelineId() + ", finishedTaskNum=" + this.getFinishedTaskNum() + ", canceledTaskNum=" + this.getCanceledTaskNum() + ", failedTaskNum=" + this.getFailedTaskNum() + ", pipelineFullName=" + this.getPipelineFullName() + ", runningJobStateIMap=" + this.getRunningJobStateIMap() + ", runningJobStateTimestampsIMap=" + this.getRunningJobStateTimestampsIMap() + ", pipelineFuture=" + this.getPipelineFuture() + ", pipelineLocation=" + this.getPipelineLocation() + ", errorByPhysicalVertex=" + this.getErrorByPhysicalVertex() + ", executorService=" + this.getExecutorService() + ", jobMaster=" + this.getJobMaster() + ", reSchedulerPipelineFuture=" + this.getReSchedulerPipelineFuture() + ", pipelineRestoreNum=" + this.getPipelineRestoreNum() + ", restoreLock=" + this.getRestoreLock() + ", currPipelineStatus=" + (Object)((Object)this.getCurrPipelineStatus()) + ")";
    }
}

