/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.sql.impl.NodeServiceProvider;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.plan.cache.PlanCacheChecker;
import com.hazelcast.sql.impl.state.QueryClientStateRegistry;
import java.util.Set;
import java.util.UUID;

public class QueryStateRegistryUpdater {
    private final NodeServiceProvider nodeServiceProvider;
    private final QueryClientStateRegistry clientStateRegistry;
    private final PlanCacheChecker planCacheChecker;
    private volatile long stateCheckFrequency;
    private final Worker worker;

    public QueryStateRegistryUpdater(String instanceName, NodeServiceProvider nodeServiceProvider, QueryClientStateRegistry clientStateRegistry, PlanCacheChecker planCacheChecker, long stateCheckFrequency) {
        if (stateCheckFrequency <= 0L) {
            throw new IllegalArgumentException("State check frequency must be positive: " + stateCheckFrequency);
        }
        this.nodeServiceProvider = nodeServiceProvider;
        this.clientStateRegistry = clientStateRegistry;
        this.planCacheChecker = planCacheChecker;
        this.stateCheckFrequency = stateCheckFrequency;
        this.worker = new Worker(instanceName);
    }

    public void start() {
        this.worker.start();
    }

    public void shutdown() {
        this.worker.stop();
    }

    public void setStateCheckFrequency(long stateCheckFrequency) {
        this.stateCheckFrequency = stateCheckFrequency;
        this.worker.thread.interrupt();
    }

    private final class Worker
    implements Runnable {
        private final Object startMux = new Object();
        private final String instanceName;
        private Thread thread;
        private volatile boolean stopped;

        private Worker(String instanceName) {
            this.instanceName = instanceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.startMux;
            synchronized (object) {
                if (this.stopped || this.thread != null) {
                    return;
                }
                Thread thread = new Thread(this);
                thread.setName(QueryUtils.workerName(this.instanceName, "query-state-checker"));
                thread.setDaemon(true);
                thread.start();
                this.thread = thread;
            }
        }

        @Override
        public void run() {
            while (!this.stopped) {
                long currentStateCheckFrequency = QueryStateRegistryUpdater.this.stateCheckFrequency;
                try {
                    Thread.sleep(currentStateCheckFrequency);
                    this.checkClientState();
                    this.checkPlans();
                }
                catch (InterruptedException e) {
                    if (currentStateCheckFrequency != QueryStateRegistryUpdater.this.stateCheckFrequency) continue;
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }

        private void checkClientState() {
            Set<UUID> activeClientIds = QueryStateRegistryUpdater.this.nodeServiceProvider.getClientIds();
            QueryStateRegistryUpdater.this.clientStateRegistry.update(activeClientIds);
        }

        private void checkPlans() {
            if (QueryStateRegistryUpdater.this.planCacheChecker != null) {
                QueryStateRegistryUpdater.this.planCacheChecker.check();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.startMux;
            synchronized (object) {
                if (this.stopped) {
                    return;
                }
                this.stopped = true;
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
        }
    }
}

