/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import java.util.Objects;
import java.util.UUID;

public class SqlError {
    private final int code;
    private final String message;
    private final UUID originatingMemberId;
    private final boolean suggestionExists;
    private final String suggestion;

    public SqlError(int code, String message, UUID originatingMemberId) {
        this(code, message, originatingMemberId, false, null);
    }

    public SqlError(int code, String message, UUID originatingMemberId, boolean suggestionExists, String suggestion) {
        this.code = code;
        this.message = message;
        this.originatingMemberId = originatingMemberId;
        this.suggestionExists = suggestionExists;
        this.suggestion = suggestion;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public UUID getOriginatingMemberId() {
        return this.originatingMemberId;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlError sqlError = (SqlError)o;
        if (this.code != sqlError.code) {
            return false;
        }
        if (!this.message.equals(sqlError.message)) {
            return false;
        }
        if (!this.originatingMemberId.equals(sqlError.originatingMemberId)) {
            return false;
        }
        return !this.suggestionExists || !sqlError.suggestionExists || Objects.equals(this.suggestion, sqlError.suggestion);
    }

    public int hashCode() {
        int result2 = this.code;
        result2 = 31 * result2 + this.message.hashCode();
        result2 = 31 * result2 + this.originatingMemberId.hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.suggestion);
        return result2;
    }
}

