/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.kubernetes.KubernetesApiProvider;
import com.hazelcast.kubernetes.KubernetesClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KubernetesApiEndpointSlicesProvider
implements KubernetesApiProvider {
    @Override
    public String getEndpointsByServiceLabelUrlString() {
        return "%s/apis/discovery.k8s.io/v1/namespaces/%s/endpointslices?%s";
    }

    @Override
    public String getEndpointsByNameUrlString() {
        return "%s/apis/discovery.k8s.io/v1/namespaces/%s/endpointslices?labelSelector=kubernetes.io/service-name=%s";
    }

    @Override
    public String getEndpointsUrlString() {
        return "%s/apis/discovery.k8s.io/v1/namespaces/%s/endpointslices";
    }

    @Override
    public List<KubernetesClient.Endpoint> parseEndpointsList(JsonObject jsonObject) {
        ArrayList<KubernetesClient.Endpoint> endpoints = new ArrayList<KubernetesClient.Endpoint>();
        for (JsonValue item : KubernetesApiProvider.toJsonArray(jsonObject.get("items"))) {
            endpoints.addAll(this.parseEndpointSlices(item));
        }
        return endpoints;
    }

    @Override
    public List<KubernetesClient.Endpoint> parseEndpoints(JsonValue jsonValue) {
        return this.parseEndpointsList(jsonValue.asObject());
    }

    @Override
    public Map<KubernetesClient.EndpointAddress, String> extractServices(JsonObject endpointsListJson, List<KubernetesClient.EndpointAddress> privateAddresses) {
        HashMap<KubernetesClient.EndpointAddress, String> result2 = new HashMap<KubernetesClient.EndpointAddress, String>();
        HashSet<KubernetesClient.EndpointAddress> left = new HashSet<KubernetesClient.EndpointAddress>(privateAddresses);
        for (JsonValue item : KubernetesApiProvider.toJsonArray(endpointsListJson.get("items"))) {
            KubernetesClient.EndpointAddress address;
            JsonValue ownerRefsValue = item.asObject().get("metadata").asObject().get("ownerReferences");
            if (ownerRefsValue == null || ownerRefsValue.asArray().size() > 1 || !ownerRefsValue.asArray().get(0).asObject().get("kind").asString().equals("Service")) continue;
            String service = ownerRefsValue.asArray().get(0).asObject().get("name").asString();
            List<KubernetesClient.Endpoint> endpoints = this.parseEndpointSlices(item);
            if (endpoints.size() != 1 || !privateAddresses.contains(address = endpoints.get(0).getPrivateAddress())) continue;
            if (!result2.containsKey(address) || service.equals(this.extractTargetRefName(item))) {
                result2.put(address, service);
            }
            left.remove(address);
        }
        if (!left.isEmpty()) {
            throw this.noCorrespondingServicesException(left);
        }
        return result2;
    }

    private List<KubernetesClient.Endpoint> parseEndpointSlices(JsonValue jsonValue) {
        ArrayList<KubernetesClient.Endpoint> addresses = new ArrayList<KubernetesClient.Endpoint>();
        Integer endpointPort = this.extractPort(jsonValue);
        for (JsonValue endpoint : KubernetesApiProvider.toJsonArray(jsonValue.asObject().get("endpoints"))) {
            JsonValue ready2 = endpoint.asObject().get("conditions").asObject().get("ready");
            Map<String, String> additionalProperties = this.extractAdditionalPropertiesFrom(endpoint);
            for (JsonValue address : KubernetesApiProvider.toJsonArray(endpoint.asObject().get("addresses"))) {
                addresses.add(new KubernetesClient.Endpoint(new KubernetesClient.EndpointAddress(address.asString(), endpointPort), ready2.asBoolean(), additionalProperties));
            }
        }
        return addresses;
    }

    private String extractTargetRefName(JsonValue endpointItemJson) {
        return Optional.of(endpointItemJson).flatMap(e -> KubernetesApiProvider.toJsonArray(e.asObject().get("endpoints")).values().stream().findFirst()).map(e -> e.asObject().get("targetRef")).map(e -> e.asObject().get("name")).map(KubernetesApiProvider::convertToString).orElse(null);
    }

    @Override
    public Map<KubernetesClient.EndpointAddress, String> extractNodes(JsonObject jsonObject, List<KubernetesClient.EndpointAddress> privateAddresses) {
        HashMap<KubernetesClient.EndpointAddress, String> result2 = new HashMap<KubernetesClient.EndpointAddress, String>();
        HashSet<KubernetesClient.EndpointAddress> left = new HashSet<KubernetesClient.EndpointAddress>(privateAddresses);
        for (JsonValue item : KubernetesApiProvider.toJsonArray(jsonObject.get("items"))) {
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (JsonValue port : KubernetesApiProvider.toJsonArray(item.asObject().get("ports"))) {
                ports.add(port.asObject().get("port").asInt());
            }
            for (JsonValue endpoint : KubernetesApiProvider.toJsonArray(item.asObject().get("endpoints"))) {
                JsonObject endpointObject = endpoint.asObject();
                String nodeName = KubernetesApiProvider.convertToString(endpointObject.get("nodeName"));
                Map<KubernetesClient.EndpointAddress, String> nodes = this.extractNodes(endpointObject.get("addresses"), ports, nodeName);
                for (Map.Entry<KubernetesClient.EndpointAddress, String> nodeEntry : nodes.entrySet()) {
                    KubernetesClient.EndpointAddress address = nodeEntry.getKey();
                    if (!privateAddresses.contains(address)) continue;
                    result2.put(address, nodes.get(address));
                    left.remove(address);
                }
            }
        }
        if (!left.isEmpty()) {
            throw this.noNodeNameAssignedException(left);
        }
        return result2;
    }

    private Map<KubernetesClient.EndpointAddress, String> extractNodes(JsonValue addressesJson, List<Integer> ports, String nodeName) {
        HashMap<KubernetesClient.EndpointAddress, String> result2 = new HashMap<KubernetesClient.EndpointAddress, String>();
        for (JsonValue address : addressesJson.asArray()) {
            for (Integer port : ports) {
                result2.put(new KubernetesClient.EndpointAddress(address.asString(), port), nodeName);
            }
        }
        return result2;
    }
}

