/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.operation.PartitionWideCacheOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.cache.expiry.ExpiryPolicy;

public class CacheGetAllOperation
extends PartitionWideCacheOperation
implements ReadonlyOperation {
    private Set<Data> keys;
    private ExpiryPolicy expiryPolicy;

    public CacheGetAllOperation(String name, Set<Data> keys, ExpiryPolicy expiryPolicy) {
        super(name);
        this.keys = keys;
        this.expiryPolicy = expiryPolicy;
    }

    public CacheGetAllOperation() {
        this.keys = new HashSet<Data>();
    }

    @Override
    public void run() {
        ICacheService service = (ICacheService)this.getService();
        ICacheRecordStore cache = service.getOrCreateRecordStore(this.name, this.getPartitionId());
        int partitionId = this.getPartitionId();
        HashSet<Data> partitionKeySet = new HashSet<Data>();
        for (Data key : this.keys) {
            if (partitionId != this.getNodeEngine().getPartitionService().getPartitionId(key)) continue;
            partitionKeySet.add(key);
        }
        this.response = cache.getAll(partitionKeySet, this.expiryPolicy);
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", keys=").append(this.keys.toString());
        sb.append(", expiryPolicy=").append(this.expiryPolicy);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.expiryPolicy);
        if (this.keys == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                IOUtil.writeData(out, key);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        int size2 = in.readInt();
        if (size2 > -1) {
            this.keys = SetUtil.createHashSet(size2);
            for (int i = 0; i < size2; ++i) {
                Data key = IOUtil.readData(in);
                this.keys.add(key);
            }
        }
    }
}

