/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public class PhysicalColumn
extends Column {
    protected PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment) {
        super(name, dataType, columnLength, nullable, defaultValue, comment);
    }

    public static PhysicalColumn of(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment) {
        return new PhysicalColumn(name, dataType, columnLength, nullable, defaultValue, comment);
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public Column copy(SeaTunnelDataType<?> newType) {
        return PhysicalColumn.of(this.name, newType, this.columnLength, this.nullable, this.defaultValue, this.comment);
    }

    @Override
    public Column copy() {
        return PhysicalColumn.of(this.name, this.dataType, this.columnLength, this.nullable, this.defaultValue, this.comment);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalColumn)) {
            return false;
        }
        PhysicalColumn other = (PhysicalColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PhysicalColumn;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return "PhysicalColumn(super=" + super.toString() + ")";
    }
}

