/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.OsHelper;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.InputStream;
import java.util.BitSet;
import net.openhft.affinity.Affinity;

public final class ThreadAffinityHelper {
    private static final String AFFINITY_LIB_DISABLED = "hazelcast.affinity.lib.disabled";
    private static final ILogger LOGGER = Logger.getLogger(ThreadAffinityHelper.class);
    private static final boolean USE_HZ_LIB;

    private ThreadAffinityHelper() {
    }

    static boolean isAffinityAvailable() {
        if (USE_HZ_LIB) {
            return true;
        }
        try {
            boolean jnaAvailable = Affinity.isJNAAvailable();
            if (!jnaAvailable) {
                Logger.getLogger(ThreadAffinityHelper.class).warning("JNA is not available");
            }
            return jnaAvailable;
        }
        catch (NoClassDefFoundError e) {
            Logger.getLogger(ThreadAffinityHelper.class).warning("The OpenHFT Affinity jar isn't available: " + e.getMessage());
            return false;
        }
    }

    public static BitSet getAffinity() {
        try {
            if (USE_HZ_LIB) {
                return ThreadAffinityHelper.getAffinity0();
            }
            return Affinity.getAffinity();
        }
        catch (Exception ex) {
            LOGGER.warning("An error occurred while getting the affinity for the current thread", ex);
            return new BitSet();
        }
    }

    public static void setAffinity(BitSet cpuMask) {
        try {
            if (USE_HZ_LIB) {
                ThreadAffinityHelper.setAffinity0(cpuMask);
            } else {
                Affinity.setAffinity((BitSet)cpuMask);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("An error occurred while setting the affinity for the current thread", ex);
        }
    }

    private static native BitSet getAffinity0();

    private static native void setAffinity0(BitSet var0);

    private static String extractBundledLib() {
        InputStream src = null;
        try {
            src = IOUtil.getFileFromResourcesAsStream("lib/linux-x86_64/libaffinity_helper.so");
            File dest = File.createTempFile("hazelcast-libaffinity-helper-", ".so");
            IOUtil.copy(src, dest);
            String string2 = dest.getAbsolutePath();
            return string2;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        finally {
            IOUtil.closeResource(src);
        }
    }

    static {
        boolean hzAffinityLibLoaded = false;
        boolean libDisabled = StringUtil.equalsIgnoreCase("true", System.getProperty(AFFINITY_LIB_DISABLED));
        if (!libDisabled && OsHelper.isLinux() && !JVMUtil.is32bitJVM()) {
            try {
                System.load(ThreadAffinityHelper.extractBundledLib());
                hzAffinityLibLoaded = true;
            }
            catch (Throwable t) {
                LOGGER.fine("Could not load Hazelcast Linux x86_64 CPU affinity helper native shared library", t);
            }
        }
        USE_HZ_LIB = hzAffinityLibLoaded;
    }
}

