/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class MCChangeClusterVersionCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x201000;
    public static final int RESPONSE_MESSAGE_TYPE = 0x201001;
    private static final int REQUEST_MAJOR_VERSION_FIELD_OFFSET = 16;
    private static final int REQUEST_MINOR_VERSION_FIELD_OFFSET = 17;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 18;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MCChangeClusterVersionCodec() {
    }

    public static ClientMessage encodeRequest(byte majorVersion, byte minorVersion) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("MC.ChangeClusterVersion");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[18], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x201000);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 16, majorVersion);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 17, minorVersion);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.majorVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 16);
        request.minorVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 17);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x201001);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public byte majorVersion;
        public byte minorVersion;
    }
}

