/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.debezium;

import io.debezium.relational.TableId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.connectors.cdc.base.utils.SourceRecordUtils;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationSchema;

public abstract class AbstractDebeziumDeserializationSchema<T>
implements DebeziumDeserializationSchema<T> {
    protected final Map<TableId, byte[]> tableChangesStructMap = new HashMap<TableId, byte[]>();
    protected transient JsonConverter converter;

    public AbstractDebeziumDeserializationSchema(Map<TableId, Struct> tableIdTableChangeMap) {
        this.tableChangesStructMap.putAll(tableIdTableChangeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.serializeStruct((Struct)entry.getValue()))));
    }

    @Override
    public Map<TableId, byte[]> getHistoryTableChanges() {
        return new HashMap<TableId, byte[]>(this.tableChangesStructMap);
    }

    @Override
    public void deserialize(SourceRecord record, Collector<T> out) throws Exception {
        if (SourceRecordUtils.isSchemaChangeEvent(record)) {
            Struct recordValue = (Struct)record.value();
            List tableChangesStruct = (List)recordValue.get("tableChanges");
            tableChangesStruct.forEach(tableChangeStruct -> this.tableChangesStructMap.put(TableId.parse(tableChangeStruct.getString("id")), this.serializeStruct((Struct)tableChangeStruct)));
        }
    }

    private byte[] serializeStruct(Struct struct) {
        if (this.converter == null) {
            this.converter = new JsonConverter();
            Map<String, Boolean> configs = Collections.singletonMap("schemas.enable", true);
            this.converter.configure(configs, false);
        }
        return this.converter.fromConnectData("topic", struct.schema(), struct);
    }
}

