/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.header;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.header.ConnectHeader;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;

public class ConnectHeaders
implements Headers {
    private static final int EMPTY_HASH = Objects.hash(new LinkedList());
    private LinkedList<Header> headers;

    public ConnectHeaders() {
    }

    public ConnectHeaders(Iterable<Header> original) {
        if (original == null) {
            return;
        }
        if (original instanceof ConnectHeaders) {
            ConnectHeaders originalHeaders = (ConnectHeaders)original;
            if (!originalHeaders.isEmpty()) {
                this.headers = new LinkedList<Header>(originalHeaders.headers);
            }
        } else {
            this.headers = new LinkedList();
            for (Header header : original) {
                Objects.requireNonNull(header, "Unable to add a null header.");
                this.headers.add(header);
            }
        }
    }

    @Override
    public int size() {
        return this.headers == null ? 0 : this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers == null || this.headers.isEmpty();
    }

    @Override
    public Headers clear() {
        if (this.headers != null) {
            this.headers.clear();
        }
        return this;
    }

    @Override
    public Headers add(Header header) {
        Objects.requireNonNull(header, "Unable to add a null header.");
        if (this.headers == null) {
            this.headers = new LinkedList();
        }
        this.headers.add(header);
        return this;
    }

    protected Headers addWithoutValidating(String key, Object value, Schema schema) {
        return this.add(new ConnectHeader(key, new SchemaAndValue(schema, value)));
    }

    @Override
    public Headers add(String key, SchemaAndValue schemaAndValue) {
        this.checkSchemaMatches(schemaAndValue);
        return this.add(new ConnectHeader(key, schemaAndValue != null ? schemaAndValue : SchemaAndValue.NULL));
    }

    @Override
    public Headers add(String key, Object value, Schema schema) {
        return this.add(key, value != null || schema != null ? new SchemaAndValue(schema, value) : SchemaAndValue.NULL);
    }

    @Override
    public Headers addString(String key, String value) {
        return this.addWithoutValidating(key, value, value != null ? Schema.STRING_SCHEMA : Schema.OPTIONAL_STRING_SCHEMA);
    }

    @Override
    public Headers addBytes(String key, byte[] value) {
        return this.addWithoutValidating(key, value, value != null ? Schema.BYTES_SCHEMA : Schema.OPTIONAL_BYTES_SCHEMA);
    }

    @Override
    public Headers addBoolean(String key, boolean value) {
        return this.addWithoutValidating(key, value, Schema.BOOLEAN_SCHEMA);
    }

    @Override
    public Headers addByte(String key, byte value) {
        return this.addWithoutValidating(key, value, Schema.INT8_SCHEMA);
    }

    @Override
    public Headers addShort(String key, short value) {
        return this.addWithoutValidating(key, value, Schema.INT16_SCHEMA);
    }

    @Override
    public Headers addInt(String key, int value) {
        return this.addWithoutValidating(key, value, Schema.INT32_SCHEMA);
    }

    @Override
    public Headers addLong(String key, long value) {
        return this.addWithoutValidating(key, value, Schema.INT64_SCHEMA);
    }

    @Override
    public Headers addFloat(String key, float value) {
        return this.addWithoutValidating(key, Float.valueOf(value), Schema.FLOAT32_SCHEMA);
    }

    @Override
    public Headers addDouble(String key, double value) {
        return this.addWithoutValidating(key, value, Schema.FLOAT64_SCHEMA);
    }

    @Override
    public Headers addList(String key, List<?> value, Schema schema) {
        if (value == null) {
            return this.add(key, null, null);
        }
        this.checkSchemaType(schema, Schema.Type.ARRAY);
        return this.addWithoutValidating(key, value, schema);
    }

    @Override
    public Headers addMap(String key, Map<?, ?> value, Schema schema) {
        if (value == null) {
            return this.add(key, null, null);
        }
        this.checkSchemaType(schema, Schema.Type.MAP);
        return this.addWithoutValidating(key, value, schema);
    }

    @Override
    public Headers addStruct(String key, Struct value) {
        if (value == null) {
            return this.add(key, null, null);
        }
        this.checkSchemaType(value.schema(), Schema.Type.STRUCT);
        return this.addWithoutValidating(key, value, value.schema());
    }

    @Override
    public Headers addDecimal(String key, BigDecimal value) {
        if (value == null) {
            return this.add(key, null, null);
        }
        Schema schema = Decimal.schema(value.scale());
        Decimal.fromLogical(schema, value);
        return this.addWithoutValidating(key, value, schema);
    }

    @Override
    public Headers addDate(String key, Date value) {
        if (value != null) {
            org.apache.kafka.connect.data.Date.fromLogical(org.apache.kafka.connect.data.Date.SCHEMA, value);
        }
        return this.addWithoutValidating(key, value, org.apache.kafka.connect.data.Date.SCHEMA);
    }

    @Override
    public Headers addTime(String key, Date value) {
        if (value != null) {
            Time.fromLogical(Time.SCHEMA, value);
        }
        return this.addWithoutValidating(key, value, Time.SCHEMA);
    }

    @Override
    public Headers addTimestamp(String key, Date value) {
        if (value != null) {
            Timestamp.fromLogical(Timestamp.SCHEMA, value);
        }
        return this.addWithoutValidating(key, value, Timestamp.SCHEMA);
    }

    @Override
    public Header lastWithName(String key) {
        this.checkKey(key);
        if (this.headers != null) {
            ListIterator<Header> iter = this.headers.listIterator(this.headers.size());
            while (iter.hasPrevious()) {
                Header header = iter.previous();
                if (!key.equals(header.key())) continue;
                return header;
            }
        }
        return null;
    }

    @Override
    public Iterator<Header> allWithName(String key) {
        return new FilterByKeyIterator(this.iterator(), key);
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers == null ? Collections.emptyIterator() : this.headers.iterator();
    }

    @Override
    public Headers remove(String key) {
        this.checkKey(key);
        if (!this.isEmpty()) {
            Iterator<Header> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().key().equals(key)) continue;
                iterator.remove();
            }
        }
        return this;
    }

    @Override
    public Headers retainLatest() {
        if (!this.isEmpty()) {
            HashSet<String> keys = new HashSet<String>();
            ListIterator<Header> iter = this.headers.listIterator(this.headers.size());
            while (iter.hasPrevious()) {
                Header header = iter.previous();
                String key = header.key();
                if (keys.add(key)) continue;
                iter.remove();
            }
        }
        return this;
    }

    @Override
    public Headers retainLatest(String key) {
        this.checkKey(key);
        if (!this.isEmpty()) {
            boolean found = false;
            ListIterator<Header> iter = this.headers.listIterator(this.headers.size());
            while (iter.hasPrevious()) {
                String headerKey = iter.previous().key();
                if (!key.equals(headerKey)) continue;
                if (found) {
                    iter.remove();
                }
                found = true;
            }
        }
        return this;
    }

    @Override
    public Headers apply(String key, Headers.HeaderTransform transform) {
        this.checkKey(key);
        if (!this.isEmpty()) {
            ListIterator<Header> iter = this.headers.listIterator();
            while (iter.hasNext()) {
                Header orig = (Header)iter.next();
                if (!orig.key().equals(key)) continue;
                Header updated = transform.apply(orig);
                if (updated != null) {
                    iter.set(updated);
                    continue;
                }
                iter.remove();
            }
        }
        return this;
    }

    @Override
    public Headers apply(Headers.HeaderTransform transform) {
        if (!this.isEmpty()) {
            ListIterator<Header> iter = this.headers.listIterator();
            while (iter.hasNext()) {
                Header orig = (Header)iter.next();
                Header updated = transform.apply(orig);
                if (updated != null) {
                    iter.set(updated);
                    continue;
                }
                iter.remove();
            }
        }
        return this;
    }

    public int hashCode() {
        return this.isEmpty() ? EMPTY_HASH : Objects.hash(this.headers);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Headers) {
            Headers that = (Headers)obj;
            Iterator<Header> thisIter = this.iterator();
            Iterator thatIter = that.iterator();
            while (thisIter.hasNext() && thatIter.hasNext()) {
                if (Objects.equals(thisIter.next(), thatIter.next())) continue;
                return false;
            }
            return !thisIter.hasNext() && !thatIter.hasNext();
        }
        return false;
    }

    public String toString() {
        return "ConnectHeaders(headers=" + (this.headers != null ? this.headers : "") + ")";
    }

    @Override
    public ConnectHeaders duplicate() {
        return new ConnectHeaders(this);
    }

    private void checkKey(String key) {
        Objects.requireNonNull(key, "Header key cannot be null");
    }

    private void checkSchemaType(Schema schema, Schema.Type type) {
        if (schema.type() != type) {
            throw new DataException("Expecting " + (Object)((Object)type) + " but instead found " + (Object)((Object)schema.type()));
        }
    }

    void checkSchemaMatches(SchemaAndValue schemaAndValue) {
        if (schemaAndValue != null) {
            Schema schema = schemaAndValue.schema();
            if (schema == null) {
                return;
            }
            schema = schema.schema();
            Object value = schemaAndValue.value();
            if (value == null && !schema.isOptional()) {
                throw new DataException("A null value requires an optional schema but was " + schema);
            }
            if (value != null) {
                switch (schema.type()) {
                    case BYTES: {
                        if (value instanceof ByteBuffer) {
                            return;
                        }
                        if (value instanceof byte[]) {
                            return;
                        }
                        if (!(value instanceof BigDecimal) || !"org.apache.kafka.connect.data.Decimal".equals(schema.name())) break;
                        return;
                    }
                    case STRING: {
                        if (!(value instanceof String)) break;
                        return;
                    }
                    case BOOLEAN: {
                        if (!(value instanceof Boolean)) break;
                        return;
                    }
                    case INT8: {
                        if (!(value instanceof Byte)) break;
                        return;
                    }
                    case INT16: {
                        if (!(value instanceof Short)) break;
                        return;
                    }
                    case INT32: {
                        if (value instanceof Integer) {
                            return;
                        }
                        if (value instanceof Date && "org.apache.kafka.connect.data.Date".equals(schema.name())) {
                            return;
                        }
                        if (!(value instanceof Date) || !"org.apache.kafka.connect.data.Time".equals(schema.name())) break;
                        return;
                    }
                    case INT64: {
                        if (value instanceof Long) {
                            return;
                        }
                        if (!(value instanceof Date) || !"org.apache.kafka.connect.data.Timestamp".equals(schema.name())) break;
                        return;
                    }
                    case FLOAT32: {
                        if (!(value instanceof Float)) break;
                        return;
                    }
                    case FLOAT64: {
                        if (!(value instanceof Double)) break;
                        return;
                    }
                    case ARRAY: {
                        if (!(value instanceof List)) break;
                        return;
                    }
                    case MAP: {
                        if (!(value instanceof Map)) break;
                        return;
                    }
                    case STRUCT: {
                        if (!(value instanceof Struct)) break;
                        return;
                    }
                }
                throw new DataException("The value " + value + " is not compatible with the schema " + schema);
            }
        }
    }

    private static final class FilterByKeyIterator
    extends AbstractIterator<Header> {
        private final Iterator<Header> original;
        private final String key;

        private FilterByKeyIterator(Iterator<Header> original, String key) {
            this.original = original;
            this.key = key;
        }

        @Override
        protected Header makeNext() {
            while (this.original.hasNext()) {
                Header header = this.original.next();
                if (!header.key().equals(this.key)) continue;
                return header;
            }
            return (Header)this.allDone();
        }
    }
}

