/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sqlengine.zeta;

import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.sqlengine.SQLEngine;
import org.apache.seatunnel.transform.sqlengine.zeta.ZetaSQLFilter;
import org.apache.seatunnel.transform.sqlengine.zeta.ZetaSQLFunction;
import org.apache.seatunnel.transform.sqlengine.zeta.ZetaSQLType;

public class ZetaSQLEngine
implements SQLEngine {
    private String inputTableName;
    private String sql;
    private PlainSelect selectBody;
    private ZetaSQLFunction zetaSQLFunction;
    private ZetaSQLFilter zetaSQLFilter;
    private ZetaSQLType zetaSQLType;

    @Override
    public void init(String inputTableName, SeaTunnelRowType inputRowType, String sql) {
        this.inputTableName = inputTableName;
        this.sql = sql;
        this.zetaSQLType = new ZetaSQLType(inputRowType);
        this.zetaSQLFunction = new ZetaSQLFunction(inputRowType, this.zetaSQLType);
        this.zetaSQLFilter = new ZetaSQLFilter(this.zetaSQLFunction);
        this.parseSQL();
    }

    private void parseSQL() {
        try {
            Statement statement = CCJSqlParserUtil.parse(this.sql);
            this.validateSQL(statement);
            this.selectBody = (PlainSelect)((Select)statement).getSelectBody();
        }
        catch (JSQLParserException e) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("SQL parse failed: %s, cause: %s", this.sql, e.getMessage()));
        }
    }

    private void validateSQL(Statement statement) {
        try {
            if (!(statement instanceof Select)) {
                throw new IllegalArgumentException("Only supported DQL(select) SQL");
            }
            Select select = (Select)statement;
            if (!(select.getSelectBody() instanceof PlainSelect)) {
                throw new IllegalArgumentException("Unsupported SQL syntax: %s");
            }
            if (!(select.getSelectBody() instanceof PlainSelect)) {
                throw new IllegalArgumentException("Unsupported SQL syntax: %s");
            }
            PlainSelect selectBody = (PlainSelect)select.getSelectBody();
            FromItem fromItem = selectBody.getFromItem();
            if (fromItem instanceof Table) {
                Table table = (Table)fromItem;
                if (table.getSchemaName() != null) {
                    throw new IllegalArgumentException("Unsupported schema syntax");
                }
                if (table.getAlias() != null) {
                    throw new IllegalArgumentException("Unsupported table alias name syntax");
                }
                String tableName = table.getName();
                if (!this.inputTableName.equalsIgnoreCase(tableName)) {
                    throw new IllegalArgumentException(String.format("Table name: %s not found", tableName));
                }
            } else {
                throw new IllegalArgumentException("Unsupported sub table syntax");
            }
            if (selectBody.getJoins() != null) {
                throw new IllegalArgumentException("Unsupported table join syntax");
            }
            if (selectBody.getOrderByElements() != null) {
                throw new IllegalArgumentException("Unsupported ORDER BY syntax");
            }
            if (selectBody.getGroupBy() != null) {
                throw new IllegalArgumentException("Unsupported GROUP BY syntax");
            }
            if (selectBody.getLimit() != null || selectBody.getOffset() != null) {
                throw new IllegalArgumentException("Unsupported LIMIT,OFFSET syntax");
            }
            for (SelectItem selectItem : selectBody.getSelectItems()) {
                if (!(selectItem instanceof AllColumns)) continue;
                throw new IllegalArgumentException("Unsupported all columns select syntax");
            }
        }
        catch (Exception e) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("SQL validate failed: %s, cause: %s", this.sql, e.getMessage()));
        }
    }

    @Override
    public SeaTunnelRowType typeMapping() {
        List<SelectItem> selectItems = this.selectBody.getSelectItems();
        String[] fieldNames = new String[selectItems.size()];
        SeaTunnelDataType[] seaTunnelDataTypes = new SeaTunnelDataType[selectItems.size()];
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (!(selectItem instanceof SelectExpressionItem)) continue;
            SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
            Expression expression = expressionItem.getExpression();
            fieldNames[i] = expressionItem.getAlias() != null ? expressionItem.getAlias().getName() : (expression instanceof Column ? ((Column)expression).getColumnName() : expression.toString());
            seaTunnelDataTypes[i] = this.zetaSQLType.getExpressionType(expression);
        }
        return new SeaTunnelRowType(fieldNames, seaTunnelDataTypes);
    }

    @Override
    public SeaTunnelRow transformBySQL(SeaTunnelRow inputRow) {
        Object[] inputFields = this.scanTable(inputRow);
        boolean retain = this.zetaSQLFilter.executeFilter(this.selectBody.getWhere(), inputFields);
        if (!retain) {
            return null;
        }
        Object[] outputFields = this.project(inputFields);
        return new SeaTunnelRow(outputFields);
    }

    private Object[] scanTable(SeaTunnelRow inputRow) {
        return inputRow.getFields();
    }

    private Object[] project(Object[] inputFields) {
        List<SelectItem> selectItems = this.selectBody.getSelectItems();
        Object[] fields = new Object[selectItems.size()];
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
            Expression expression = expressionItem.getExpression();
            fields[i] = this.zetaSQLFunction.computeForValue(expression, inputFields);
        }
        return fields;
    }
}

