/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.slf4j.EventDataConverter;
import org.apache.logging.slf4j.Log4jMarker;
import org.apache.logging.slf4j.Log4jMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.impl.StaticMarkerBinder;
import org.slf4j.spi.LocationAwareLogger;

public class Log4jLogger
implements LocationAwareLogger,
Serializable {
    public static final String FQCN = Log4jLogger.class.getName();
    private static final long serialVersionUID = 7869000638091304316L;
    private static final Marker EVENT_MARKER = MarkerFactory.getMarker("EVENT");
    private static final EventDataConverter CONVERTER = Log4jLogger.createConverter();
    private final boolean eventLogger;
    private transient ExtendedLogger logger;
    private final String name;

    public Log4jLogger(ExtendedLogger logger, String name) {
        this.logger = logger;
        this.eventLogger = "EventLogger".equals(name);
        this.name = name;
    }

    @Override
    public void trace(String format2) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, format2);
    }

    @Override
    public void trace(String format2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, (org.apache.logging.log4j.Marker)null, format2, o);
    }

    @Override
    public void trace(String format2, Object arg1, Object arg2) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, (org.apache.logging.log4j.Marker)null, format2, arg1, arg2);
    }

    @Override
    public void trace(String format2, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, (org.apache.logging.log4j.Marker)null, format2, args);
    }

    @Override
    public void trace(String format2, Throwable t) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, (org.apache.logging.log4j.Marker)null, format2, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isEnabled(Level.TRACE, null, null);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isEnabled(Level.TRACE, Log4jLogger.getMarker(marker), null);
    }

    @Override
    public void trace(Marker marker, String s2) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s2);
    }

    @Override
    public void trace(Marker marker, String s2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s2, o);
    }

    @Override
    public void trace(Marker marker, String s2, Object o, Object o1) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s2, o, o1);
    }

    @Override
    public void trace(Marker marker, String s2, Object ... objects) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s2, objects);
    }

    @Override
    public void trace(Marker marker, String s2, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s2, throwable);
    }

    @Override
    public void debug(String format2) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, format2);
    }

    @Override
    public void debug(String format2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, (org.apache.logging.log4j.Marker)null, format2, o);
    }

    @Override
    public void debug(String format2, Object arg1, Object arg2) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, (org.apache.logging.log4j.Marker)null, format2, arg1, arg2);
    }

    @Override
    public void debug(String format2, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, (org.apache.logging.log4j.Marker)null, format2, args);
    }

    @Override
    public void debug(String format2, Throwable t) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, (org.apache.logging.log4j.Marker)null, format2, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isEnabled(Level.DEBUG, null, null);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isEnabled(Level.DEBUG, Log4jLogger.getMarker(marker), null);
    }

    @Override
    public void debug(Marker marker, String s2) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s2);
    }

    @Override
    public void debug(Marker marker, String s2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s2, o);
    }

    @Override
    public void debug(Marker marker, String s2, Object o, Object o1) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s2, o, o1);
    }

    @Override
    public void debug(Marker marker, String s2, Object ... objects) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s2, objects);
    }

    @Override
    public void debug(Marker marker, String s2, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s2, throwable);
    }

    @Override
    public void info(String format2) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, format2);
    }

    @Override
    public void info(String format2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.INFO, (org.apache.logging.log4j.Marker)null, format2, o);
    }

    @Override
    public void info(String format2, Object arg1, Object arg2) {
        this.logger.logIfEnabled(FQCN, Level.INFO, (org.apache.logging.log4j.Marker)null, format2, arg1, arg2);
    }

    @Override
    public void info(String format2, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.INFO, (org.apache.logging.log4j.Marker)null, format2, args);
    }

    @Override
    public void info(String format2, Throwable t) {
        this.logger.logIfEnabled(FQCN, Level.INFO, (org.apache.logging.log4j.Marker)null, format2, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isEnabled(Level.INFO, null, null);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isEnabled(Level.INFO, Log4jLogger.getMarker(marker), null);
    }

    @Override
    public void info(Marker marker, String s2) {
        this.logger.logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s2);
    }

    @Override
    public void info(Marker marker, String s2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s2, o);
    }

    @Override
    public void info(Marker marker, String s2, Object o, Object o1) {
        this.logger.logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s2, o, o1);
    }

    @Override
    public void info(Marker marker, String s2, Object ... objects) {
        this.logger.logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s2, objects);
    }

    @Override
    public void info(Marker marker, String s2, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s2, throwable);
    }

    @Override
    public void warn(String format2) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, format2);
    }

    @Override
    public void warn(String format2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.WARN, (org.apache.logging.log4j.Marker)null, format2, o);
    }

    @Override
    public void warn(String format2, Object arg1, Object arg2) {
        this.logger.logIfEnabled(FQCN, Level.WARN, (org.apache.logging.log4j.Marker)null, format2, arg1, arg2);
    }

    @Override
    public void warn(String format2, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.WARN, (org.apache.logging.log4j.Marker)null, format2, args);
    }

    @Override
    public void warn(String format2, Throwable t) {
        this.logger.logIfEnabled(FQCN, Level.WARN, (org.apache.logging.log4j.Marker)null, format2, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabled(Level.WARN, null, null);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isEnabled(Level.WARN, Log4jLogger.getMarker(marker), null);
    }

    @Override
    public void warn(Marker marker, String s2) {
        this.logger.logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s2);
    }

    @Override
    public void warn(Marker marker, String s2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s2, o);
    }

    @Override
    public void warn(Marker marker, String s2, Object o, Object o1) {
        this.logger.logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s2, o, o1);
    }

    @Override
    public void warn(Marker marker, String s2, Object ... objects) {
        this.logger.logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s2, objects);
    }

    @Override
    public void warn(Marker marker, String s2, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s2, throwable);
    }

    @Override
    public void error(String format2) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, format2);
    }

    @Override
    public void error(String format2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, (org.apache.logging.log4j.Marker)null, format2, o);
    }

    @Override
    public void error(String format2, Object arg1, Object arg2) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, (org.apache.logging.log4j.Marker)null, format2, arg1, arg2);
    }

    @Override
    public void error(String format2, Object ... args) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, (org.apache.logging.log4j.Marker)null, format2, args);
    }

    @Override
    public void error(String format2, Throwable t) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, (org.apache.logging.log4j.Marker)null, format2, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabled(Level.ERROR, null, null);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isEnabled(Level.ERROR, Log4jLogger.getMarker(marker), null);
    }

    @Override
    public void error(Marker marker, String s2) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s2);
    }

    @Override
    public void error(Marker marker, String s2, Object o) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s2, o);
    }

    @Override
    public void error(Marker marker, String s2, Object o, Object o1) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s2, o, o1);
    }

    @Override
    public void error(Marker marker, String s2, Object ... objects) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s2, objects);
    }

    @Override
    public void error(Marker marker, String s2, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s2, throwable);
    }

    @Override
    public void log(Marker marker, String fqcn, int level, String message, Object[] params, Throwable throwable) {
        Message msg;
        org.apache.logging.log4j.Marker log4jMarker;
        Level log4jLevel = Log4jLogger.getLevel(level);
        if (!this.logger.isEnabled(log4jLevel, log4jMarker = Log4jLogger.getMarker(marker), message, params)) {
            return;
        }
        if (CONVERTER != null && this.eventLogger && marker != null && marker.contains(EVENT_MARKER)) {
            msg = CONVERTER.convertEvent(message, params, throwable);
        } else if (params == null) {
            msg = new SimpleMessage(message);
        } else {
            msg = new ParameterizedMessage(message, params, throwable);
            if (throwable != null) {
                throwable = msg.getThrowable();
            }
        }
        this.logger.logMessage(fqcn, log4jLevel, log4jMarker, msg, throwable);
    }

    private static org.apache.logging.log4j.Marker getMarker(Marker marker) {
        if (marker == null) {
            return null;
        }
        if (marker instanceof Log4jMarker) {
            return ((Log4jMarker)marker).getLog4jMarker();
        }
        Log4jMarkerFactory factory = (Log4jMarkerFactory)StaticMarkerBinder.SINGLETON.getMarkerFactory();
        return ((Log4jMarker)factory.getMarker(marker)).getLog4jMarker();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.logger = LogManager.getContext().getLogger(this.name);
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    private static EventDataConverter createConverter() {
        try {
            LoaderUtil.loadClass("org.slf4j.ext.EventData");
            return new EventDataConverter();
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private static Level getLevel(int i) {
        switch (i) {
            case 0: {
                return Level.TRACE;
            }
            case 10: {
                return Level.DEBUG;
            }
            case 20: {
                return Level.INFO;
            }
            case 30: {
                return Level.WARN;
            }
            case 40: {
                return Level.ERROR;
            }
        }
        return Level.ERROR;
    }
}

