/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class CheckLightJobsOperation
extends Operation
implements IdentifiedDataSerializable {
    private long[] executionIds;

    public CheckLightJobsOperation() {
    }

    public CheckLightJobsOperation(long[] executionIds) {
        this.executionIds = executionIds;
    }

    @Override
    public Object getResponse() {
        return this.getJetServiceBackend().getJobCoordinationService().findUnknownExecutions(this.executionIds);
    }

    protected JetServiceBackend getJetServiceBackend() {
        Util.checkJetIsEnabled(this.getNodeEngine());
        assert (this.getServiceName().equals("hz:impl:jetService")) : "Service is not JetServiceBackend";
        return (JetServiceBackend)this.getService();
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 47;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLongArray(this.executionIds);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionIds = in.readLongArray();
    }
}

