/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.map.IMap;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class IMapOutputStream
extends OutputStream {
    private static final int CHUNK_SIZE = 131072;
    private final String prefix;
    private final IMap<String, byte[]> map;
    private final ByteBuffer currentChunk = ByteBuffer.allocate(131072);
    private final byte[] singleByteBuffer = new byte[1];
    private int currentChunkIndex;

    public IMapOutputStream(IMap<String, byte[]> map2, String prefix) {
        this.map = map2;
        this.prefix = prefix;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.flush();
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(this.currentChunkIndex);
        this.map.put(this.prefix, buf.array());
        this.currentChunkIndex = -1;
    }

    private boolean isClosed() {
        return this.currentChunkIndex < 0;
    }

    @Override
    public void write(@Nonnull byte[] b, int off, int len) throws IOException {
        int countToPut;
        if ((len | off) < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException(String.format("b.length == %,d, off == %,d, len == %,d", b.length, off, len));
        }
        if (this.isClosed()) {
            throw new IOException("Stream already closed");
        }
        for (int writeCount = 0; writeCount < len; writeCount += countToPut) {
            countToPut = Math.min(len - writeCount, this.currentChunk.remaining());
            this.currentChunk.put(b, off + writeCount, countToPut);
            if (this.currentChunk.remaining() != 0) continue;
            this.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.singleByteBuffer[0] = (byte)b;
        this.write(this.singleByteBuffer);
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed()) {
            return;
        }
        byte[] value = this.currentChunk.array();
        if (this.currentChunk.remaining() > 0) {
            value = Arrays.copyOf(value, this.currentChunk.position());
        }
        try {
            this.map.put(this.prefix + '_' + this.currentChunkIndex, value);
        }
        catch (Exception e) {
            throw new IOException("Writing to chunked IMap failed: " + e, e);
        }
        ++this.currentChunkIndex;
        JVMUtil.upcast(this.currentChunk).clear();
    }
}

