/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ConcurrencyUtil {
    public static final Executor CALLER_RUNS = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return "CALLER_RUNS";
        }
    };
    private static Executor defaultAsyncExecutor;

    private ConcurrencyUtil() {
    }

    public static Executor getDefaultAsyncExecutor() {
        return defaultAsyncExecutor;
    }

    public static void setDefaultAsyncExecutor(Executor executor) {
        defaultAsyncExecutor = executor;
    }

    public static <E> void setMax(E obj, AtomicLongFieldUpdater<E> updater, long value) {
        long current;
        do {
            if ((current = updater.get(obj)) < value) continue;
            return;
        } while (!updater.compareAndSet(obj, current, value));
    }

    public static boolean setIfEqualOrGreaterThan(AtomicLong oldValue, long newValue) {
        long local;
        do {
            if (newValue >= (local = oldValue.get())) continue;
            return false;
        } while (!oldValue.compareAndSet(local, newValue));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutSynchronized(ConcurrentMap<K, V> map2, K key, Object mutex, ConstructorFunction<K, V> func) {
        if (mutex == null) {
            throw new NullPointerException();
        }
        Object value = map2.get(key);
        if (value == null) {
            Object object = mutex;
            synchronized (object) {
                value = map2.get(key);
                if (value == null) {
                    value = func.createNew(key);
                    map2.put(key, value);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutSynchronized(ConcurrentMap<K, V> map2, K key, ContextMutexFactory contextMutexFactory, ConstructorFunction<K, V> func) {
        if (contextMutexFactory == null) {
            throw new NullPointerException();
        }
        Object value = map2.get(key);
        if (value == null) {
            try (ContextMutexFactory.Mutex mutex = contextMutexFactory.mutexFor(key);){
                ContextMutexFactory.Mutex mutex2 = mutex;
                synchronized (mutex2) {
                    value = map2.get(key);
                    if (value == null) {
                        value = func.createNew(key);
                        map2.put(key, value);
                    }
                }
            }
        }
        return value;
    }

    public static <K, V> V getOrPutIfAbsent(ConcurrentMap<K, V> map2, K key, ConstructorFunction<K, V> func) {
        Object value = map2.get(key);
        if (value == null) {
            value = func.createNew(key);
            V current = map2.putIfAbsent(key, value);
            value = current == null ? value : current;
        }
        return value;
    }

    static {
        Executor asyncExecutor = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : command -> new Thread(command).start();
        defaultAsyncExecutor = asyncExecutor;
    }
}

