/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;

public class SourceNoMoreElementOperation
extends Operation
implements IdentifiedDataSerializable {
    private TaskLocation currentTaskID;
    private TaskLocation enumeratorTaskID;

    public SourceNoMoreElementOperation() {
    }

    public SourceNoMoreElementOperation(TaskLocation currentTaskID, TaskLocation enumeratorTaskID) {
        this.currentTaskID = currentTaskID;
        this.enumeratorTaskID = enumeratorTaskID;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)server.getTaskExecutionService().getTask(this.enumeratorTaskID);
            task.readerFinished(this.currentTaskID.getTaskID());
            return null;
        }, new RetryUtils.RetryMaterial(10, true, exception -> exception instanceof NullPointerException && !server.taskIsEnded(this.enumeratorTaskID.getTaskGroupLocation()), 2000L));
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.currentTaskID);
        out.writeObject(this.enumeratorTaskID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.currentTaskID = (TaskLocation)in.readObject();
        this.enumeratorTaskID = (TaskLocation)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }
}

