/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.UnixStyleUsageFormatter;
import org.apache.seatunnel.core.starter.seatunnel.args.ClientCommandArgs;
import org.apache.seatunnel.core.starter.seatunnel.args.ServerCommandArgs;

public class CommandLineUtils {
    private static final String CLIENT_SHELL_NAME = "seatunnel.sh";
    private static final String SERVER_SHELL_NAME = "seatunnel.sh";

    private CommandLineUtils() {
        throw new UnsupportedOperationException("CommandLineUtils is a utility class and cannot be instantiated");
    }

    public static ClientCommandArgs parseSeaTunnelClientArgs(String[] args) {
        ClientCommandArgs clientCommandArgs = new ClientCommandArgs();
        JCommander jCommander = CommandLineUtils.getJCommander("seatunnel.sh", args, clientCommandArgs);
        clientCommandArgs.setSeatunnelParams(jCommander.getUnknownOptions());
        if (clientCommandArgs.isHelp()) {
            CommandLineUtils.printHelp(jCommander);
        }
        return clientCommandArgs;
    }

    public static ServerCommandArgs parseSeaTunnelServerArgs(String[] args) {
        ServerCommandArgs serverCommandArgs = new ServerCommandArgs();
        JCommander jCommander = CommandLineUtils.getJCommander("seatunnel.sh", args, serverCommandArgs);
        serverCommandArgs.setSeatunnelParams(jCommander.getUnknownOptions());
        if (serverCommandArgs.isHelp()) {
            CommandLineUtils.printHelp(jCommander);
        }
        return serverCommandArgs;
    }

    private static void printHelp(JCommander jCommander) {
        jCommander.setUsageFormatter(new UnixStyleUsageFormatter(jCommander));
        jCommander.usage();
        System.exit(234);
    }

    private static JCommander getJCommander(String shellName, String[] args, Object serverCommandArgs) {
        return JCommander.newBuilder().programName(shellName).addObject(serverCommandArgs).acceptUnknownOptions(true).args(args).build();
    }
}

