/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;

public class ReplaceFunction
extends TriExpression<String>
implements IdentifiedDataSerializable {
    public ReplaceFunction() {
    }

    private ReplaceFunction(Expression<?> original, Expression<?> from2, Expression<?> to2) {
        super(original, from2, to2);
    }

    public static ReplaceFunction create(Expression<?> original, Expression<?> from2, Expression<?> to2) {
        return new ReplaceFunction(original, from2, to2);
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        String original = StringFunctionUtils.asVarchar(this.operand1, row, context);
        if (original == null) {
            return null;
        }
        String from2 = StringFunctionUtils.asVarchar(this.operand2, row, context);
        if (from2 == null) {
            return null;
        }
        String to2 = StringFunctionUtils.asVarchar(this.operand3, row, context);
        if (to2 == null) {
            return null;
        }
        return StringFunctionUtils.replace(original, from2, to2);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 50;
    }
}

