/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.spi.annotation.Beta;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@Beta
public class CompactSerializationConfig {
    final Map<String, TriTuple<String, String, String>> typeNameToNamedRegistration;
    final Map<String, TriTuple<String, String, String>> classNameToNamedRegistration;
    final Map<String, TriTuple<Class, String, CompactSerializer>> typeNameToRegistration;
    final Map<Class, TriTuple<Class, String, CompactSerializer>> classToRegistration;
    private boolean enabled;

    public CompactSerializationConfig() {
        this.typeNameToRegistration = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>();
        this.classToRegistration = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>();
        this.typeNameToNamedRegistration = new ConcurrentHashMap<String, TriTuple<String, String, String>>();
        this.classNameToNamedRegistration = new ConcurrentHashMap<String, TriTuple<String, String, String>>();
    }

    public CompactSerializationConfig(CompactSerializationConfig compactSerializationConfig) {
        this.typeNameToRegistration = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>(compactSerializationConfig.typeNameToRegistration);
        this.classToRegistration = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>(compactSerializationConfig.classToRegistration);
        this.typeNameToNamedRegistration = new ConcurrentHashMap<String, TriTuple<String, String, String>>(compactSerializationConfig.typeNameToNamedRegistration);
        this.classNameToNamedRegistration = new ConcurrentHashMap<String, TriTuple<String, String, String>>(compactSerializationConfig.classNameToNamedRegistration);
        this.enabled = compactSerializationConfig.enabled;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        this.register0(clazz, clazz.getName(), null);
        return this;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz, @Nonnull String typeName, @Nonnull CompactSerializer<T> explicitSerializer) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        Preconditions.checkNotNull(typeName, "Type name cannot be null");
        Preconditions.checkNotNull(explicitSerializer, "Explicit serializer cannot be null");
        this.register0(clazz, typeName, explicitSerializer);
        return this;
    }

    private <T> void register0(Class<T> clazz, String typeName, CompactSerializer<T> explicitSerializer) {
        TriTuple<Class<T>, String, CompactSerializer<T>> registration = TriTuple.of(clazz, typeName, explicitSerializer);
        TriTuple<Class<T>, String, CompactSerializer<T>> oldRegistration = this.typeNameToRegistration.putIfAbsent(typeName, registration);
        if (oldRegistration != null) {
            throw new InvalidConfigurationException("Already have a registration for the type name " + typeName);
        }
        oldRegistration = this.classToRegistration.putIfAbsent(clazz, registration);
        if (oldRegistration != null) {
            throw new InvalidConfigurationException("Already have a registration for class " + clazz);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CompactSerializationConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactSerializationConfig that = (CompactSerializationConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.typeNameToRegistration, that.typeNameToRegistration) && Objects.equals(this.classToRegistration, that.classToRegistration) && Objects.equals(this.typeNameToNamedRegistration, that.typeNameToNamedRegistration) && Objects.equals(this.classNameToNamedRegistration, that.classNameToNamedRegistration);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.typeNameToRegistration, this.classToRegistration, this.typeNameToNamedRegistration, this.classNameToNamedRegistration);
    }
}

