/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class JetGetJobIdsCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16647168;
    public static final int RESPONSE_MESSAGE_TYPE = 16647169;
    private static final int REQUEST_ONLY_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetGetJobIdsCodec() {
    }

    public static ClientMessage encodeRequest(@Nullable String onlyName, long onlyJobId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Jet.GetJobIds");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16647168);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, onlyJobId);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, onlyName, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        if (initialFrame.content.length >= 24) {
            request.onlyJobId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
            request.isOnlyJobIdExists = true;
        } else {
            request.isOnlyJobIdExists = false;
        }
        if (iterator2.hasNext()) {
            request.onlyName = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
            request.isOnlyNameExists = true;
        } else {
            request.isOnlyNameExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse(Data response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16647169);
        clientMessage.add(initialFrame);
        DataCodec.encode(clientMessage, response);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator2.next();
        if (iterator2.hasNext()) {
            response.response = DataCodec.decode(iterator2);
            response.isResponseExists = true;
        } else {
            response.isResponseExists = false;
        }
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public Data response;
        public boolean isResponseExists;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        @Nullable
        public String onlyName;
        public long onlyJobId;
        public boolean isOnlyNameExists;
        public boolean isOnlyJobIdExists;
    }
}

