/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.operation;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.function.BiConsumer;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.serializable.OperationDataSerializerHook;

public abstract class AsyncOperation
extends Operation
implements IdentifiedDataSerializable {
    @Override
    public void beforeRun() {
        SeaTunnelServer service = (SeaTunnelServer)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    @Override
    public final void run() {
        PassiveCompletableFuture<?> future;
        try {
            future = this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
            return;
        }
        future.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (r, f) -> this.doSendResponse(f != null ? ExceptionUtil.peel(f) : r)));
    }

    protected abstract PassiveCompletableFuture<?> doRun() throws Exception;

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendResponse(Object value) {
        try {
            SeaTunnelServer service = (SeaTunnelServer)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
        finally {
            try {
                this.sendResponse(value);
            }
            catch (Exception e) {
                Throwable ex = ExceptionUtil.peel(e);
                if (value instanceof Throwable && ex instanceof HazelcastSerializationException) {
                    this.sendResponse(new SeaTunnelEngineException(ExceptionUtil.stackTraceToString(ex)));
                }
                throw e;
            }
        }
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public final int getFactoryId() {
        return OperationDataSerializerHook.FACTORY_ID;
    }
}

