/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.google.common.collect.Lists;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.common.loader.SeatunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.ProgressState;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskCallTimer;
import org.apache.seatunnel.engine.server.execution.TaskExecutionContext;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroup;
import org.apache.seatunnel.engine.server.execution.TaskGroupContext;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.execution.TaskTracker;
import org.apache.seatunnel.engine.server.task.TaskGroupImmutableInformation;
import org.apache.seatunnel.engine.server.task.operation.NotifyTaskStatusOperation;

public class TaskExecutionService {
    private final String hzInstanceName;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private volatile boolean isRunning = true;
    private final LinkedBlockingDeque<TaskTracker> threadShareTaskQueue = new LinkedBlockingDeque();
    private final ExecutorService executorService = Executors.newCachedThreadPool(new BlockingTaskThreadFactory());
    private final RunBusWorkSupplier runBusWorkSupplier = new RunBusWorkSupplier(this.executorService, this.threadShareTaskQueue);
    private final ConcurrentMap<TaskGroupLocation, TaskGroupContext> executionContexts = new ConcurrentHashMap<TaskGroupLocation, TaskGroupContext>();
    private final ConcurrentMap<TaskGroupLocation, CompletableFuture<Void>> cancellationFutures = new ConcurrentHashMap<TaskGroupLocation, CompletableFuture<Void>>();

    public TaskExecutionService(NodeEngineImpl nodeEngine, HazelcastProperties properties) {
        this.hzInstanceName = nodeEngine.getHazelcastInstance().getName();
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLoggingService().getLogger(TaskExecutionService.class);
    }

    public void start() {
        this.runBusWorkSupplier.runNewBusWork(false);
    }

    public void shutdown() {
        this.isRunning = false;
        this.executorService.shutdownNow();
    }

    public TaskGroupContext getExecutionContext(TaskGroupLocation taskGroupLocation) {
        return (TaskGroupContext)this.executionContexts.get(taskGroupLocation);
    }

    private void submitThreadShareTask(TaskGroupExecutionTracker taskGroupExecutionTracker, List<Task> tasks) {
        tasks.stream().map(t -> new TaskTracker((Task)t, taskGroupExecutionTracker)).forEach(this.threadShareTaskQueue::add);
    }

    private void submitBlockingTask(TaskGroupExecutionTracker taskGroupExecutionTracker, List<Task> tasks) {
        CountDownLatch startedLatch = new CountDownLatch(tasks.size());
        taskGroupExecutionTracker.blockingFutures = tasks.stream().map(t -> new BlockingWorker(new TaskTracker((Task)t, taskGroupExecutionTracker), startedLatch)).map(this.executorService::submit).collect(Collectors.toList());
        Util.uncheckRun(startedLatch::await);
    }

    public PassiveCompletableFuture<TaskExecutionState> deployTask(@NonNull Data taskImmutableInformation) {
        if (taskImmutableInformation == null) {
            throw new NullPointerException("taskImmutableInformation is marked @NonNull but is null");
        }
        TaskGroupImmutableInformation taskImmutableInfo = (TaskGroupImmutableInformation)this.nodeEngine.getSerializationService().toObject(taskImmutableInformation);
        return this.deployTask(taskImmutableInfo);
    }

    public <T extends Task> T getTask(TaskLocation taskLocation) {
        return this.getExecutionContext(taskLocation.getTaskGroupLocation()).getTaskGroup().getTask(taskLocation.getTaskID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassiveCompletableFuture<TaskExecutionState> deployTask(@NonNull TaskGroupImmutableInformation taskImmutableInfo) {
        if (taskImmutableInfo == null) {
            throw new NullPointerException("taskImmutableInfo is marked @NonNull but is null");
        }
        CompletableFuture<TaskExecutionState> resultFuture = new CompletableFuture<TaskExecutionState>();
        TaskGroup taskGroup = null;
        try {
            Set<URL> jars = taskImmutableInfo.getJars();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (!CollectionUtils.isEmpty(jars)) {
                classLoader = new SeatunnelChildFirstClassLoader(Lists.newArrayList(jars));
                taskGroup = (TaskGroup)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.nodeEngine.getSerializationService(), classLoader, taskImmutableInfo.getGroup());
            } else {
                taskGroup = (TaskGroup)this.nodeEngine.getSerializationService().toObject(taskImmutableInfo.getGroup());
            }
            this.logger.info(String.format("deploying task %s", taskGroup.getTaskGroupLocation()));
            TaskExecutionService taskExecutionService = this;
            synchronized (taskExecutionService) {
                if (this.executionContexts.containsKey(taskGroup.getTaskGroupLocation())) {
                    throw new RuntimeException(String.format("TaskGroupLocation: %s already exists", taskGroup.getTaskGroupLocation()));
                }
                return this.deployLocalTask(taskGroup, resultFuture, classLoader);
            }
        }
        catch (Throwable t) {
            this.logger.severe(String.format("TaskGroupID : %s  deploy error with Exception: %s", taskGroup != null && taskGroup.getTaskGroupLocation() != null ? taskGroup.getTaskGroupLocation().toString() : "taskGroupLocation is null", ExceptionUtils.getMessage(t)));
            resultFuture.complete(new TaskExecutionState(taskGroup != null && taskGroup.getTaskGroupLocation() != null ? taskGroup.getTaskGroupLocation() : null, ExecutionState.FAILED, t));
            return new PassiveCompletableFuture<TaskExecutionState>(resultFuture);
        }
    }

    public PassiveCompletableFuture<TaskExecutionState> deployLocalTask(@NonNull TaskGroup taskGroup, @NonNull CompletableFuture<TaskExecutionState> resultFuture) {
        if (taskGroup == null) {
            throw new NullPointerException("taskGroup is marked @NonNull but is null");
        }
        if (resultFuture == null) {
            throw new NullPointerException("resultFuture is marked @NonNull but is null");
        }
        return this.deployLocalTask(taskGroup, resultFuture, Thread.currentThread().getContextClassLoader());
    }

    public PassiveCompletableFuture<TaskExecutionState> deployLocalTask(@NonNull TaskGroup taskGroup, @NonNull CompletableFuture<TaskExecutionState> resultFuture, @NonNull ClassLoader classLoader) {
        if (taskGroup == null) {
            throw new NullPointerException("taskGroup is marked @NonNull but is null");
        }
        if (resultFuture == null) {
            throw new NullPointerException("resultFuture is marked @NonNull but is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked @NonNull but is null");
        }
        try {
            taskGroup.init();
            Collection<Task> tasks = taskGroup.getTasks();
            CompletableFuture<Void> cancellationFuture = new CompletableFuture<Void>();
            TaskGroupExecutionTracker executionTracker = new TaskGroupExecutionTracker(cancellationFuture, taskGroup, resultFuture);
            ConcurrentHashMap<Long, TaskExecutionContext> taskExecutionContextMap = new ConcurrentHashMap<Long, TaskExecutionContext>();
            Map<Boolean, List<Task>> byCooperation = tasks.stream().peek(task -> {
                TaskExecutionContext taskExecutionContext = new TaskExecutionContext((Task)task, this.nodeEngine);
                task.setTaskExecutionContext(taskExecutionContext);
                taskExecutionContextMap.put(task.getTaskID(), taskExecutionContext);
            }).collect(Collectors.partitioningBy(Task::isThreadsShare));
            this.executionContexts.put(taskGroup.getTaskGroupLocation(), new TaskGroupContext(taskGroup, classLoader));
            this.cancellationFutures.put(taskGroup.getTaskGroupLocation(), cancellationFuture);
            this.submitThreadShareTask(executionTracker, byCooperation.get(true));
            this.submitBlockingTask(executionTracker, byCooperation.get(false));
            taskGroup.setTasksContext(taskExecutionContextMap);
        }
        catch (Throwable t) {
            this.logger.severe(ExceptionUtils.getMessage(t));
            resultFuture.completeExceptionally(t);
        }
        resultFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.logger, (r, s2) -> {
            this.logger.info(String.format("Task %s complete with state %s", r.getTaskGroupLocation(), r.getExecutionState()));
            long sleepTime = 1000L;
            boolean notifyStateSuccess = false;
            while (this.isRunning && !notifyStateSuccess) {
                InvocationFuture invoke = this.nodeEngine.getOperationService().createInvocationBuilder("st:impl:seaTunnelServer", (Operation)new NotifyTaskStatusOperation(taskGroup.getTaskGroupLocation(), (TaskExecutionState)r), this.nodeEngine.getMasterAddress()).invoke();
                try {
                    invoke.get();
                    notifyStateSuccess = true;
                }
                catch (InterruptedException e) {
                    this.logger.severe(e);
                    Thread.interrupted();
                }
                catch (ExecutionException e) {
                    this.logger.warning(ExceptionUtils.getMessage(e));
                    this.logger.warning(String.format("notify the job of the task(%s) status failed, retry in %s millis", taskGroup.getTaskGroupLocation(), sleepTime));
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ex) {
                        this.logger.severe(e);
                        Thread.interrupted();
                    }
                }
            }
        }));
        return new PassiveCompletableFuture<TaskExecutionState>(resultFuture);
    }

    public void cancelTaskGroup(TaskGroupLocation taskGroupLocation) {
        this.logger.info(String.format("Task (%s) need cancel.", taskGroupLocation));
        if (this.cancellationFutures.containsKey(taskGroupLocation)) {
            ((CompletableFuture)this.cancellationFutures.get(taskGroupLocation)).cancel(false);
        } else {
            this.logger.warning(String.format("need cancel taskId : %s is not exist", taskGroupLocation));
        }
    }

    public final class TaskGroupExecutionTracker {
        private final TaskGroup taskGroup;
        final CompletableFuture<TaskExecutionState> future;
        volatile List<Future<?>> blockingFutures = Collections.emptyList();
        private final AtomicInteger completionLatch;
        private final AtomicReference<Throwable> executionException = new AtomicReference();
        private final AtomicBoolean isCancel = new AtomicBoolean(false);

        TaskGroupExecutionTracker(@NonNull CompletableFuture<Void> cancellationFuture, @NonNull TaskGroup taskGroup, CompletableFuture<TaskExecutionState> future) {
            if (cancellationFuture == null) {
                throw new NullPointerException("cancellationFuture is marked @NonNull but is null");
            }
            if (taskGroup == null) {
                throw new NullPointerException("taskGroup is marked @NonNull but is null");
            }
            if (future == null) {
                throw new NullPointerException("future is marked @NonNull but is null");
            }
            this.future = future;
            this.completionLatch = new AtomicInteger(taskGroup.getTasks().size());
            this.taskGroup = taskGroup;
            cancellationFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(TaskExecutionService.this.logger, (r, e) -> {
                this.isCancel.set(true);
                if (e == null) {
                    e = new IllegalStateException("cancellationFuture should be completed exceptionally");
                }
                this.exception((Throwable)e);
                this.blockingFutures.forEach(f -> f.cancel(false));
            }));
        }

        void exception(Throwable t) {
            this.executionException.compareAndSet(null, t);
        }

        void taskDone() {
            TaskExecutionService.this.logger.info("taskDone: " + this.taskGroup.getTaskGroupLocation());
            if (this.completionLatch.decrementAndGet() == 0) {
                TaskGroupLocation taskGroupLocation = this.taskGroup.getTaskGroupLocation();
                TaskExecutionService.this.executionContexts.remove(taskGroupLocation);
                TaskExecutionService.this.cancellationFutures.remove(taskGroupLocation);
                Throwable ex = this.executionException.get();
                if (ex == null) {
                    this.future.complete(new TaskExecutionState(taskGroupLocation, ExecutionState.FINISHED, null));
                } else if (this.isCancel.get()) {
                    this.future.complete(new TaskExecutionState(taskGroupLocation, ExecutionState.CANCELED, null));
                } else {
                    this.future.complete(new TaskExecutionState(taskGroupLocation, ExecutionState.FAILED, ex));
                }
            }
        }

        boolean executionCompletedExceptionally() {
            return this.executionException.get() != null;
        }
    }

    public final class RunBusWorkSupplier {
        ExecutorService executorService;
        LinkedBlockingDeque<TaskTracker> taskQueue;

        public RunBusWorkSupplier(ExecutorService executorService, LinkedBlockingDeque<TaskTracker> taskqueue) {
            this.executorService = executorService;
            this.taskQueue = taskqueue;
        }

        public boolean runNewBusWork(boolean checkTaskQueue) {
            if (!checkTaskQueue || this.taskQueue.size() > 0) {
                this.executorService.submit(new CooperativeTaskWorker(this.taskQueue, this));
                return true;
            }
            return false;
        }
    }

    public final class CooperativeTaskWorker
    implements Runnable {
        AtomicBoolean keep = new AtomicBoolean(true);
        public AtomicReference<TaskTracker> exclusiveTaskTracker = new AtomicReference();
        final TaskCallTimer timer;
        public LinkedBlockingDeque<TaskTracker> taskqueue;

        public CooperativeTaskWorker(LinkedBlockingDeque<TaskTracker> taskqueue, RunBusWorkSupplier runBusWorkSupplier) {
            TaskExecutionService.this.logger.info(String.format("Created new BusWork : %s", this.hashCode()));
            this.taskqueue = taskqueue;
            this.timer = new TaskCallTimer(50L, this.keep, runBusWorkSupplier, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.keep.get() && TaskExecutionService.this.isRunning) {
                ProgressState call;
                TaskGroupExecutionTracker taskGroupExecutionTracker;
                TaskTracker taskTracker;
                block15: {
                    taskTracker = null != this.exclusiveTaskTracker.get() ? this.exclusiveTaskTracker.get() : this.taskqueue.takeFirst();
                    taskGroupExecutionTracker = taskTracker.taskGroupExecutionTracker;
                    if (taskGroupExecutionTracker.executionCompletedExceptionally()) {
                        taskGroupExecutionTracker.taskDone();
                        if (null == this.exclusiveTaskTracker.get()) continue;
                        break;
                    }
                    if (null == this.exclusiveTaskTracker.get()) {
                        this.timer.timerStart(taskTracker);
                    }
                    call = null;
                    try {
                        call = taskTracker.task.call();
                        TaskCallTimer taskCallTimer = this.timer;
                        synchronized (taskCallTimer) {
                            this.timer.timerStop();
                        }
                    }
                    catch (Throwable e) {
                        taskGroupExecutionTracker.exception(e);
                        taskGroupExecutionTracker.taskDone();
                        TaskExecutionService.this.logger.warning("Exception in " + taskTracker.task, e);
                        if (null == this.exclusiveTaskTracker.get()) break block15;
                        break;
                    }
                    finally {
                        this.timer.timerStop();
                    }
                }
                if (null == call) continue;
                if (call.isDone()) {
                    taskGroupExecutionTracker.taskDone();
                    if (null == this.exclusiveTaskTracker.get()) continue;
                    break;
                }
                if (null != this.exclusiveTaskTracker.get()) continue;
                this.taskqueue.offer(taskTracker);
            }
        }
    }

    private final class BlockingTaskThreadFactory
    implements ThreadFactory {
        private final AtomicInteger seq = new AtomicInteger();

        private BlockingTaskThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            if (r == null) {
                throw new NullPointerException("r is marked @NonNull but is null");
            }
            return new Thread(r, String.format("hz.%s.seaTunnel.task.thread-%d", TaskExecutionService.this.hzInstanceName, this.seq.getAndIncrement()));
        }
    }

    private final class BlockingWorker
    implements Runnable {
        private final TaskTracker tracker;
        private final CountDownLatch startedLatch;

        private BlockingWorker(TaskTracker tracker, CountDownLatch startedLatch) {
            this.tracker = tracker;
            this.startedLatch = startedLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader classLoader = ((TaskGroupContext)TaskExecutionService.this.executionContexts.get(this.tracker.taskGroupExecutionTracker.taskGroup.getTaskGroupLocation())).getClassLoader();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Task t = this.tracker.task;
            try {
                ProgressState result2;
                this.startedLatch.countDown();
                t.init();
                while (!(result2 = t.call()).isDone() && TaskExecutionService.this.isRunning && !this.tracker.taskGroupExecutionTracker.executionCompletedExceptionally()) {
                }
            }
            catch (Throwable e) {
                TaskExecutionService.this.logger.warning("Exception in " + t, e);
                this.tracker.taskGroupExecutionTracker.exception(e);
            }
            finally {
                this.tracker.taskGroupExecutionTracker.taskDone();
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

