/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;

public class SeaTunnelHazelcastClient {
    private final HazelcastClientInstanceImpl hazelcastClient;
    private final SerializationService serializationService;

    public SeaTunnelHazelcastClient(@NonNull ClientConfig clientConfig) {
        if (clientConfig == null) {
            throw new NullPointerException("clientConfig is marked @NonNull but is null");
        }
        Preconditions.checkNotNull(clientConfig, "config");
        this.hazelcastClient = ((HazelcastClientProxy)HazelcastClient.newHazelcastClient((ClientConfig)clientConfig)).client;
        this.serializationService = this.hazelcastClient.getSerializationService();
        ExceptionUtil.registerSeaTunnelExceptions(this.hazelcastClient.getClientExceptionFactory());
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    @NonNull
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastClient;
    }

    public ILogger getLogger(Class<?> clazz) {
        return this.hazelcastClient.getLoggingService().getLogger(clazz);
    }

    public <S> S requestOnMasterAndDecodeResponse(@NonNull ClientMessage request, @NonNull Function<ClientMessage, Object> decoder) {
        if (request == null) {
            throw new NullPointerException("request is marked @NonNull but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked @NonNull but is null");
        }
        UUID masterUuid = this.hazelcastClient.getClientClusterService().getMasterMember().getUuid();
        return this.requestAndDecodeResponse(masterUuid, request, decoder);
    }

    public <S> S requestAndDecodeResponse(@NonNull UUID uuid, @NonNull ClientMessage request, @NonNull Function<ClientMessage, Object> decoder) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked @NonNull but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked @NonNull but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked @NonNull but is null");
        }
        ClientInvocation invocation = new ClientInvocation(this.hazelcastClient, request, null, uuid);
        try {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            return (S)this.serializationService.toObject(decoder.apply(response));
        }
        catch (InterruptedException i) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public <T> PassiveCompletableFuture<T> requestAndGetCompletableFuture(@NonNull UUID uuid, @NonNull ClientMessage request, @NonNull ClientMessageDecoder<?> clientMessageDecoder) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked @NonNull but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked @NonNull but is null");
        }
        if (clientMessageDecoder == null) {
            throw new NullPointerException("clientMessageDecoder is marked @NonNull but is null");
        }
        ClientInvocation invocation = new ClientInvocation(this.hazelcastClient, request, null, uuid);
        try {
            return new PassiveCompletableFuture(new ClientDelegatingFuture(invocation.invoke(), this.serializationService, clientMessageDecoder));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public <T> PassiveCompletableFuture<T> requestOnMasterAndGetCompletableFuture(@NonNull ClientMessage request, @NonNull ClientMessageDecoder<?> clientMessageDecoder) {
        if (request == null) {
            throw new NullPointerException("request is marked @NonNull but is null");
        }
        if (clientMessageDecoder == null) {
            throw new NullPointerException("clientMessageDecoder is marked @NonNull but is null");
        }
        UUID masterUuid = this.hazelcastClient.getClientClusterService().getMasterMember().getUuid();
        return this.requestAndGetCompletableFuture(masterUuid, request, clientMessageDecoder);
    }

    public PassiveCompletableFuture<Void> requestAndGetCompletableFuture(@NonNull UUID uuid, @NonNull ClientMessage request) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked @NonNull but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked @NonNull but is null");
        }
        ClientInvocation invocation = new ClientInvocation(this.hazelcastClient, request, null, uuid);
        try {
            return new PassiveCompletableFuture<Void>(invocation.invoke().thenApply(r -> null));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public PassiveCompletableFuture<Void> requestOnMasterAndGetCompletableFuture(@NonNull ClientMessage request) {
        if (request == null) {
            throw new NullPointerException("request is marked @NonNull but is null");
        }
        UUID masterUuid = this.hazelcastClient.getClientClusterService().getMasterMember().getUuid();
        return this.requestAndGetCompletableFuture(masterUuid, request);
    }

    public void shutdown() {
        if (this.hazelcastClient != null) {
            this.hazelcastClient.shutdown();
        }
    }
}

