/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark.command;

import java.nio.file.Path;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.config.ConfigBuilder;
import org.apache.seatunnel.core.starter.exception.CommandExecuteException;
import org.apache.seatunnel.core.starter.spark.args.SparkCommandArgs;
import org.apache.seatunnel.core.starter.spark.execution.SparkExecution;
import org.apache.seatunnel.core.starter.utils.FileUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkApiTaskExecuteCommand
implements Command<SparkCommandArgs> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkApiTaskExecuteCommand.class);
    private final SparkCommandArgs sparkCommandArgs;

    public SparkApiTaskExecuteCommand(SparkCommandArgs sparkCommandArgs) {
        this.sparkCommandArgs = sparkCommandArgs;
    }

    @Override
    public void execute() throws CommandExecuteException {
        Path configFile = FileUtils.getConfigPath(this.sparkCommandArgs);
        Config config = new ConfigBuilder(configFile).getConfig();
        try {
            SparkExecution seaTunnelTaskExecution = new SparkExecution(config);
            seaTunnelTaskExecution.execute();
        }
        catch (Exception e) {
            LOGGER.error("Run SeaTunnel on spark failed.", e);
            throw new CommandExecuteException(e.getMessage());
        }
    }
}

