/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql;

import com.mongodb.spark.exceptions.MongoTypeConversionException;
import com.mongodb.spark.sql.BsonValueToJson$;
import com.mongodb.spark.sql.MapFunctions$isBsonNumber$;
import com.mongodb.spark.sql.MapFunctions$notNull$;
import com.mongodb.spark.sql.types.BsonCompatibility$Binary$;
import com.mongodb.spark.sql.types.BsonCompatibility$DbPointer$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScript$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScriptWithScope$;
import com.mongodb.spark.sql.types.BsonCompatibility$MaxKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$MinKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$ObjectId$;
import com.mongodb.spark.sql.types.BsonCompatibility$RegularExpression$;
import com.mongodb.spark.sql.types.BsonCompatibility$Symbol$;
import com.mongodb.spark.sql.types.BsonCompatibility$Timestamp$;
import com.mongodb.spark.sql.types.BsonCompatibility$Undefined$;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MapFunctions$ {
    public static final MapFunctions$ MODULE$;

    static {
        new MapFunctions$();
    }

    public Row documentToRow(BsonDocument bsonDocument, StructType schema2, String[] requiredColumns) {
        boolean bl;
        block4: {
            Tuple2[] tuple2Array;
            block3: {
                Tuple2[] values;
                block2: {
                    values = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).map(new scala.Serializable(bsonDocument){
                        public static final long serialVersionUID = 0L;
                        private final BsonDocument bsonDocument$1;

                        public final Tuple2<Object, StructField> apply(StructField field2) {
                            boolean bl;
                            block4: {
                                Tuple2<Object, StructField> tuple2;
                                block3: {
                                    block2: {
                                        bl = this.bsonDocument$1.containsKey(field2.name());
                                        if (!bl) break block2;
                                        tuple2 = new Tuple2<Object, StructField>(MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToDataType(this.bsonDocument$1.get(field2.name()), field2.dataType()), field2);
                                        break block3;
                                    }
                                    if (bl) break block4;
                                    tuple2 = new Tuple2<Object, StructField>(null, field2);
                                }
                                return tuple2;
                            }
                            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
                        }
                        {
                            this.bsonDocument$1 = bsonDocument$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    bl = Predef$.MODULE$.refArrayOps((Object[])requiredColumns).nonEmpty();
                    if (!bl) break block2;
                    Map requiredValueMap = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])values).collect(new scala.Serializable(requiredColumns){
                        public static final long serialVersionUID = 0L;
                        private final String[] requiredColumns$1;

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, StructField>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            void var6_8;
                            A1 A1 = x1;
                            if (A1 != null) {
                                Object rowValue = A1._1();
                                StructField rowField = A1._2();
                                if (Predef$.MODULE$.refArrayOps((Object[])this.requiredColumns$1).contains(rowField.name())) {
                                    Tuple2<String, Tuple2<Object, StructField>> tuple2 = new Tuple2<String, Tuple2<Object, StructField>>(rowField.name(), new Tuple2<Object, StructField>(rowValue, rowField));
                                    return var6_8;
                                }
                            }
                            B1 B1 = function1.apply(x1);
                            return var6_8;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Tuple2<Object, StructField> x1) {
                            Tuple2<Object, StructField> tuple2 = x1;
                            if (tuple2 == null) return false;
                            StructField rowField = tuple2._2();
                            if (!Predef$.MODULE$.refArrayOps((Object[])this.requiredColumns$1).contains(rowField.name())) return false;
                            return true;
                        }
                        {
                            this.requiredColumns$1 = requiredColumns$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
                    tuple2Array = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).collect(new scala.Serializable(requiredValueMap){
                        public static final long serialVersionUID = 0L;
                        private final Map requiredValueMap$1;

                        public final <A1 extends String, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            Null$ null$ = this.requiredValueMap$1.getOrElse(A1, new scala.Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Null$ apply() {
                                    return null;
                                }
                            });
                            return (B1)null$;
                        }

                        public final boolean isDefinedAt(String x2) {
                            String string2 = x2;
                            boolean bl = true;
                            return bl;
                        }
                        {
                            this.requiredValueMap$1 = requiredValueMap$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    break block3;
                }
                if (bl) break block4;
                tuple2Array = values;
            }
            Tuple2[] requiredValues = tuple2Array;
            return new GenericRowWithSchema((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredValues).map(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Tuple2<Object, StructField> x$1) {
                    return x$1._1();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any())), DataTypes.createStructType((StructField[])((StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredValues).map(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(Tuple2<Object, StructField> x$2) {
                    return x$2._2();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    public String[] documentToRow$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    /*
     * WARNING - void declaration
     */
    public BsonDocument rowToDocument(Row row) {
        void var2_2;
        BsonDocument document = new BsonDocument();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])row.schema().fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach(new scala.Serializable(row, document){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final BsonDocument document$1;

            public final Object apply(Tuple2<StructField, Object> x0$1) {
                Tuple2<StructField, Object> tuple2;
                block4: {
                    Serializable serializable;
                    block3: {
                        block2: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            StructField field2 = tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            if (!this.row$1.isNullAt(i)) break block2;
                            DataType dataType = field2.dataType();
                            NullType$ nullType$ = NullType$.MODULE$;
                            serializable = !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null) ? this.document$1.append(field2.name(), new BsonNull()) : BoxedUnit.UNIT;
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        StructField field3 = tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        serializable = this.document$1.append(field3.name(), MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToBsonValue(this.row$1.get(i), field3.dataType()));
                    }
                    return serializable;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
                this.document$1 = document$1;
            }
        });
        return var2_2;
    }

    public Object com$mongodb$spark$sql$MapFunctions$$convertToDataType(BsonValue element, DataType elementType) {
        block16: {
            Object object;
            block3: {
                block15: {
                    DataType dataType;
                    Tuple2<BsonType, DataType> tuple2;
                    block14: {
                        block13: {
                            BsonType bsonType;
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block4: {
                                                                block2: {
                                                                    tuple2 = new Tuple2<BsonType, DataType>(element.getBsonType(), elementType);
                                                                    if (tuple2 == null) break block2;
                                                                    BsonType bsonType2 = tuple2._1();
                                                                    DataType mapType = tuple2._2();
                                                                    if (!((Object)((Object)BsonType.DOCUMENT)).equals((Object)bsonType2) || !(mapType instanceof MapType)) break block2;
                                                                    MapType mapType2 = (MapType)mapType;
                                                                    object = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(element.asDocument()).asScala()).map(new scala.Serializable(mapType2){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final MapType x31$1;

                                                                        public final Tuple2<String, Object> apply(Tuple2<String, BsonValue> kv) {
                                                                            return new Tuple2<String, Object>(kv._1(), MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToDataType(kv._2(), this.x31$1.valueType()));
                                                                        }
                                                                        {
                                                                            this.x31$1 = x31$1;
                                                                        }
                                                                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                                                                    break block3;
                                                                }
                                                                if (tuple2 == null) break block4;
                                                                BsonType bsonType3 = tuple2._1();
                                                                DataType arrayType = tuple2._2();
                                                                if (!((Object)((Object)BsonType.ARRAY)).equals((Object)bsonType3) || !(arrayType instanceof ArrayType)) break block4;
                                                                ArrayType arrayType2 = (ArrayType)arrayType;
                                                                object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(element.asArray().getValues()).asScala()).map(new scala.Serializable(arrayType2){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final ArrayType x33$1;

                                                                    public final Object apply(BsonValue x$3) {
                                                                        return MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToDataType(x$3, this.x33$1.elementType());
                                                                    }
                                                                    {
                                                                        this.x33$1 = x33$1;
                                                                    }
                                                                }, Buffer$.MODULE$.canBuildFrom());
                                                                break block3;
                                                            }
                                                            if (tuple2 == null) break block5;
                                                            BsonType bsonType4 = tuple2._1();
                                                            DataType dataType2 = tuple2._2();
                                                            if (!((Object)((Object)BsonType.BINARY)).equals((Object)bsonType4) || !BinaryType$.MODULE$.equals(dataType2)) break block5;
                                                            object = element.asBinary().getData();
                                                            break block3;
                                                        }
                                                        if (tuple2 == null) break block6;
                                                        BsonType bsonType5 = tuple2._1();
                                                        DataType dataType3 = tuple2._2();
                                                        if (!((Object)((Object)BsonType.BOOLEAN)).equals((Object)bsonType5) || !BooleanType$.MODULE$.equals(dataType3)) break block6;
                                                        object = BoxesRunTime.boxToBoolean(element.asBoolean().getValue());
                                                        break block3;
                                                    }
                                                    if (tuple2 == null) break block7;
                                                    BsonType bsonType6 = tuple2._1();
                                                    DataType dataType4 = tuple2._2();
                                                    if (!((Object)((Object)BsonType.DATE_TIME)).equals((Object)bsonType6) || !DateType$.MODULE$.equals(dataType4)) break block7;
                                                    object = new Date(element.asDateTime().getValue());
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block8;
                                                BsonType bsonType7 = tuple2._1();
                                                DataType dataType5 = tuple2._2();
                                                if (!((Object)((Object)BsonType.DATE_TIME)).equals((Object)bsonType7) || !TimestampType$.MODULE$.equals(dataType5)) break block8;
                                                object = new Timestamp(element.asDateTime().getValue());
                                                break block3;
                                            }
                                            if (tuple2 == null) break block9;
                                            BsonType bsonType8 = tuple2._1();
                                            DataType dataType6 = tuple2._2();
                                            if (!((Object)((Object)BsonType.NULL)).equals((Object)bsonType8) || !NullType$.MODULE$.equals(dataType6)) break block9;
                                            object = null;
                                            break block3;
                                        }
                                        if (tuple2 == null) break block10;
                                        BsonType bsonType9 = tuple2._1();
                                        DataType dataType7 = tuple2._2();
                                        if (!MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType9) || !DoubleType$.MODULE$.equals(dataType7)) break block10;
                                        object = BoxesRunTime.boxToDouble(this.toDouble(element));
                                        break block3;
                                    }
                                    if (tuple2 == null) break block11;
                                    BsonType bsonType10 = tuple2._1();
                                    DataType dataType8 = tuple2._2();
                                    if (!MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType10) || !IntegerType$.MODULE$.equals(dataType8)) break block11;
                                    object = BoxesRunTime.boxToInteger(this.toInt(element));
                                    break block3;
                                }
                                if (tuple2 == null) break block12;
                                BsonType bsonType11 = tuple2._1();
                                DataType dataType9 = tuple2._2();
                                if (!MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType11) || !LongType$.MODULE$.equals(dataType9)) break block12;
                                object = BoxesRunTime.boxToLong(this.toLong(element));
                                break block3;
                            }
                            if (tuple2 == null || !MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType = tuple2._1()) || !elementType.typeName().startsWith("decimal")) break block13;
                            object = this.toDecimal(element);
                            break block3;
                        }
                        if (tuple2 == null) break block14;
                        BsonType bsonType = tuple2._1();
                        DataType schema2 = tuple2._2();
                        if (!MapFunctions$notNull$.MODULE$.unapply(bsonType) || !(schema2 instanceof StructType)) break block14;
                        StructType structType = (StructType)schema2;
                        object = this.castToStructType(element, structType);
                        break block3;
                    }
                    if (tuple2 == null || !StringType$.MODULE$.equals(dataType = tuple2._2())) break block15;
                    object = this.bsonValueToString(element);
                    break block3;
                }
                if (!element.isNull()) break block16;
                object = null;
            }
            return object;
        }
        throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a ", " (value: ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{element.getBsonType(), elementType, element})));
    }

    public BsonValue com$mongodb$spark$sql$MapFunctions$$convertToBsonValue(Object element, DataType elementType) {
        boolean bl = false;
        Failure failure = null;
        Try<BsonValue> try_ = Try$.MODULE$.apply(new scala.Serializable(element, elementType){
            public static final long serialVersionUID = 0L;
            private final Object element$1;
            private final DataType elementType$1;

            public final BsonValue apply() {
                return MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$elementTypeToBsonValue(this.element$1, this.elementType$1);
            }
            {
                this.element$1 = element$1;
                this.elementType$1 = elementType$1;
            }
        });
        if (try_ instanceof Success) {
            BsonValue bsonValue;
            Success success = (Success)try_;
            BsonValue bsonValue2 = bsonValue = (BsonValue)success.value();
            return bsonValue2;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (ex instanceof MongoTypeConversionException) {
                MongoTypeConversionException mongoTypeConversionException = (MongoTypeConversionException)ex;
                throw mongoTypeConversionException;
            }
        }
        if (bl) {
            throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{element, elementType})));
        }
        throw new MatchError(try_);
    }

    private String bsonValueToString(BsonValue element) {
        BsonType bsonType = element.getBsonType();
        String string2 = ((Object)((Object)BsonType.STRING)).equals((Object)bsonType) ? element.asString().getValue() : (((Object)((Object)BsonType.OBJECT_ID)).equals((Object)bsonType) ? element.asObjectId().getValue().toHexString() : (((Object)((Object)BsonType.INT64)).equals((Object)bsonType) ? ((Object)BoxesRunTime.boxToLong(element.asInt64().getValue())).toString() : (((Object)((Object)BsonType.INT32)).equals((Object)bsonType) ? ((Object)BoxesRunTime.boxToInteger(element.asInt32().getValue())).toString() : (((Object)((Object)BsonType.DOUBLE)).equals((Object)bsonType) ? ((Object)BoxesRunTime.boxToDouble(element.asDouble().getValue())).toString() : BsonValueToJson$.MODULE$.apply(element)))));
        return string2;
    }

    private Object castToStructType(BsonValue element, StructType elementType) {
        block14: {
            Row row;
            block3: {
                Tuple2<BsonType, StructType> tuple2;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        BsonType bsonType;
                                                        block2: {
                                                            tuple2 = new Tuple2<BsonType, StructType>(element.getBsonType(), elementType);
                                                            if (tuple2 == null) break block2;
                                                            BsonType bsonType2 = tuple2._1();
                                                            StructType structType = tuple2._2();
                                                            if (!((Object)((Object)BsonType.BINARY)).equals((Object)bsonType2) || !BsonCompatibility$Binary$.MODULE$.unapply(structType)) break block2;
                                                            row = BsonCompatibility$Binary$.MODULE$.apply((BsonBinary)element, elementType);
                                                            break block3;
                                                        }
                                                        if (tuple2 == null || !((Object)((Object)BsonType.DOCUMENT)).equals((Object)(bsonType = tuple2._1()))) break block4;
                                                        row = this.documentToRow((BsonDocument)element, elementType, this.documentToRow$default$3());
                                                        break block3;
                                                    }
                                                    if (tuple2 == null) break block5;
                                                    BsonType bsonType = tuple2._1();
                                                    StructType structType = tuple2._2();
                                                    if (!((Object)((Object)BsonType.DB_POINTER)).equals((Object)bsonType) || !BsonCompatibility$DbPointer$.MODULE$.unapply(structType)) break block5;
                                                    row = BsonCompatibility$DbPointer$.MODULE$.apply((BsonDbPointer)element, elementType);
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block6;
                                                BsonType bsonType = tuple2._1();
                                                StructType structType = tuple2._2();
                                                if (!((Object)((Object)BsonType.JAVASCRIPT)).equals((Object)bsonType) || !BsonCompatibility$JavaScript$.MODULE$.unapply(structType)) break block6;
                                                row = BsonCompatibility$JavaScript$.MODULE$.apply((BsonJavaScript)element, elementType);
                                                break block3;
                                            }
                                            if (tuple2 == null) break block7;
                                            BsonType bsonType = tuple2._1();
                                            StructType structType = tuple2._2();
                                            if (!((Object)((Object)BsonType.JAVASCRIPT_WITH_SCOPE)).equals((Object)bsonType) || !BsonCompatibility$JavaScriptWithScope$.MODULE$.unapply(structType)) break block7;
                                            row = BsonCompatibility$JavaScriptWithScope$.MODULE$.apply((BsonJavaScriptWithScope)element, elementType);
                                            break block3;
                                        }
                                        if (tuple2 == null) break block8;
                                        BsonType bsonType = tuple2._1();
                                        StructType structType = tuple2._2();
                                        if (!((Object)((Object)BsonType.MIN_KEY)).equals((Object)bsonType) || !BsonCompatibility$MinKey$.MODULE$.unapply(structType)) break block8;
                                        row = BsonCompatibility$MinKey$.MODULE$.apply((BsonMinKey)element, elementType);
                                        break block3;
                                    }
                                    if (tuple2 == null) break block9;
                                    BsonType bsonType = tuple2._1();
                                    StructType structType = tuple2._2();
                                    if (!((Object)((Object)BsonType.MAX_KEY)).equals((Object)bsonType) || !BsonCompatibility$MaxKey$.MODULE$.unapply(structType)) break block9;
                                    row = BsonCompatibility$MaxKey$.MODULE$.apply((BsonMaxKey)element, elementType);
                                    break block3;
                                }
                                if (tuple2 == null) break block10;
                                BsonType bsonType = tuple2._1();
                                StructType structType = tuple2._2();
                                if (!((Object)((Object)BsonType.OBJECT_ID)).equals((Object)bsonType) || !BsonCompatibility$ObjectId$.MODULE$.unapply(structType)) break block10;
                                row = BsonCompatibility$ObjectId$.MODULE$.apply((BsonObjectId)element, elementType);
                                break block3;
                            }
                            if (tuple2 == null) break block11;
                            BsonType bsonType = tuple2._1();
                            StructType structType = tuple2._2();
                            if (!((Object)((Object)BsonType.REGULAR_EXPRESSION)).equals((Object)bsonType) || !BsonCompatibility$RegularExpression$.MODULE$.unapply(structType)) break block11;
                            row = BsonCompatibility$RegularExpression$.MODULE$.apply((BsonRegularExpression)element, elementType);
                            break block3;
                        }
                        if (tuple2 == null) break block12;
                        BsonType bsonType = tuple2._1();
                        StructType structType = tuple2._2();
                        if (!((Object)((Object)BsonType.SYMBOL)).equals((Object)bsonType) || !BsonCompatibility$Symbol$.MODULE$.unapply(structType)) break block12;
                        row = BsonCompatibility$Symbol$.MODULE$.apply((BsonSymbol)element, elementType);
                        break block3;
                    }
                    if (tuple2 == null) break block13;
                    BsonType bsonType = tuple2._1();
                    StructType structType = tuple2._2();
                    if (!((Object)((Object)BsonType.TIMESTAMP)).equals((Object)bsonType) || !BsonCompatibility$Timestamp$.MODULE$.unapply(structType)) break block13;
                    row = BsonCompatibility$Timestamp$.MODULE$.apply((BsonTimestamp)element, elementType);
                    break block3;
                }
                if (tuple2 == null) break block14;
                BsonType bsonType = tuple2._1();
                StructType structType = tuple2._2();
                if (!((Object)((Object)BsonType.UNDEFINED)).equals((Object)bsonType) || !BsonCompatibility$Undefined$.MODULE$.unapply(structType)) break block14;
                row = BsonCompatibility$Undefined$.MODULE$.apply((BsonUndefined)element, elementType);
            }
            return row;
        }
        throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a ", " (value: ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{element.getBsonType(), elementType, element})));
    }

    public BsonValue com$mongodb$spark$sql$MapFunctions$$elementTypeToBsonValue(Object element, DataType elementType) {
        block15: {
            BsonValue bsonValue;
            block3: {
                java.math.BigDecimal bigDecimal;
                block13: {
                    block14: {
                        DataType dataType;
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                dataType = elementType;
                                                                if (!BinaryType$.MODULE$.equals(dataType)) break block2;
                                                                bsonValue = new BsonBinary((byte[])element);
                                                                break block3;
                                                            }
                                                            if (!BooleanType$.MODULE$.equals(dataType)) break block4;
                                                            bsonValue = new BsonBoolean(BoxesRunTime.unboxToBoolean(element));
                                                            break block3;
                                                        }
                                                        if (!DateType$.MODULE$.equals(dataType)) break block5;
                                                        bsonValue = new BsonDateTime(((Date)element).getTime());
                                                        break block3;
                                                    }
                                                    if (!DoubleType$.MODULE$.equals(dataType)) break block6;
                                                    bsonValue = new BsonDouble(BoxesRunTime.unboxToDouble(element));
                                                    break block3;
                                                }
                                                if (!IntegerType$.MODULE$.equals(dataType)) break block7;
                                                bsonValue = new BsonInt32(BoxesRunTime.unboxToInt(element));
                                                break block3;
                                            }
                                            if (!LongType$.MODULE$.equals(dataType)) break block8;
                                            bsonValue = new BsonInt64(BoxesRunTime.unboxToLong(element));
                                            break block3;
                                        }
                                        if (!StringType$.MODULE$.equals(dataType)) break block9;
                                        bsonValue = new BsonString((String)element);
                                        break block3;
                                    }
                                    if (!TimestampType$.MODULE$.equals(dataType)) break block10;
                                    bsonValue = new BsonDateTime(((Timestamp)element).getTime());
                                    break block3;
                                }
                                if (!(dataType instanceof ArrayType)) break block11;
                                ArrayType arrayType = (ArrayType)dataType;
                                bsonValue = this.com$mongodb$spark$sql$MapFunctions$$arrayTypeToBsonValue(arrayType.elementType(), (Seq)element);
                                break block3;
                            }
                            if (!(dataType instanceof StructType)) break block12;
                            StructType structType = (StructType)dataType;
                            bsonValue = this.castFromStructType((Row)element, structType);
                            break block3;
                        }
                        if (!(dataType instanceof MapType)) break block13;
                        MapType mapType = (MapType)dataType;
                        DataType dataType2 = mapType.keyType();
                        if (!StringType$.MODULE$.equals(dataType2)) break block14;
                        BsonValue bsonValue2 = this.mapTypeToBsonValue(mapType.valueType(), (Map)element);
                        bsonValue = bsonValue2;
                        break block3;
                    }
                    throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a BsonValue. MapTypes must have keys of StringType for conversion into a BsonDocument"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{element})));
                }
                if (!elementType.typeName().startsWith("decimal")) break block15;
                Object object = element;
                java.math.BigDecimal bigDecimal2 = object instanceof java.math.BigDecimal ? (bigDecimal = (java.math.BigDecimal)object) : ((BigDecimal)element).bigDecimal();
                java.math.BigDecimal jBigDecimal = bigDecimal2;
                bsonValue = new BsonDecimal128(new Decimal128(jBigDecimal));
            }
            return bsonValue;
        }
        throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a BsonValue. ", " has no matching BsonValue."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{element, elementType})));
    }

    private BsonValue mapTypeToBsonValue(DataType valueType, Map<String, Object> data) {
        Iterable iterable;
        DataType dataType = valueType;
        if (dataType instanceof StructType) {
            iterable = data.map((Function1<String, Object>)((Object)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonElement apply(Tuple2<String, Object> kv) {
                    return new BsonElement(kv._1(), MapFunctions$.MODULE$.rowToDocument((Row)kv._2()));
                }
            }), Iterable$.MODULE$.canBuildFrom());
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            iterable = data.map((Function1<String, Object>)((Object)new scala.Serializable(arrayType){
                public static final long serialVersionUID = 0L;
                private final ArrayType x3$1;

                public final BsonElement apply(Tuple2<String, Object> kv) {
                    return new BsonElement(kv._1(), MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$arrayTypeToBsonValue(this.x3$1.elementType(), (Seq)kv._2()));
                }
                {
                    this.x3$1 = x3$1;
                }
            }), Iterable$.MODULE$.canBuildFrom());
        } else {
            iterable = data.map((Function1<String, Object>)((Object)new scala.Serializable(valueType){
                public static final long serialVersionUID = 0L;
                private final DataType valueType$1;

                public final BsonElement apply(Tuple2<String, Object> kv) {
                    return new BsonElement(kv._1(), MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToBsonValue(kv._2(), this.valueType$1));
                }
                {
                    this.valueType$1 = valueType$1;
                }
            }), Iterable$.MODULE$.canBuildFrom());
        }
        Iterable internalData = iterable;
        return new BsonDocument(JavaConverters$.MODULE$.seqAsJavaListConverter(internalData.toList()).asJava());
    }

    public BsonValue com$mongodb$spark$sql$MapFunctions$$arrayTypeToBsonValue(DataType elementType, Seq<Object> data) {
        List list;
        DataType dataType = elementType;
        if (dataType instanceof StructType) {
            list = JavaConverters$.MODULE$.seqAsJavaListConverter(data.map(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonDocument apply(Object x) {
                    return MapFunctions$.MODULE$.rowToDocument((Row)x);
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava();
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            list = JavaConverters$.MODULE$.seqAsJavaListConverter(data.map(new scala.Serializable(arrayType){
                public static final long serialVersionUID = 0L;
                private final ArrayType x3$2;

                public final BsonValue apply(Object x) {
                    return MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$arrayTypeToBsonValue(this.x3$2.elementType(), (Seq)x);
                }
                {
                    this.x3$2 = x3$2;
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava();
        } else {
            list = JavaConverters$.MODULE$.seqAsJavaListConverter(data.map(new scala.Serializable(elementType){
                public static final long serialVersionUID = 0L;
                private final DataType elementType$2;

                public final BsonValue apply(Object x) {
                    return MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToBsonValue(x, this.elementType$2);
                }
                {
                    this.elementType$2 = elementType$2;
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava();
        }
        List internalData = list;
        return new BsonArray(internalData);
    }

    private BsonValue castFromStructType(Row element, StructType dataType) {
        StructType structType = dataType;
        BsonValue bsonValue = BsonCompatibility$ObjectId$.MODULE$.unapply(structType) ? BsonCompatibility$ObjectId$.MODULE$.apply(element) : (BsonCompatibility$MinKey$.MODULE$.unapply(structType) ? BsonCompatibility$MinKey$.MODULE$.apply(element) : (BsonCompatibility$MaxKey$.MODULE$.unapply(structType) ? BsonCompatibility$MaxKey$.MODULE$.apply(element) : (BsonCompatibility$Timestamp$.MODULE$.unapply(structType) ? BsonCompatibility$Timestamp$.MODULE$.apply(element) : (BsonCompatibility$JavaScript$.MODULE$.unapply(structType) ? BsonCompatibility$JavaScript$.MODULE$.apply(element) : (BsonCompatibility$JavaScriptWithScope$.MODULE$.unapply(structType) ? BsonCompatibility$JavaScriptWithScope$.MODULE$.apply(element) : (BsonCompatibility$RegularExpression$.MODULE$.unapply(structType) ? BsonCompatibility$RegularExpression$.MODULE$.apply(element) : (BsonCompatibility$Undefined$.MODULE$.unapply(structType) ? BsonCompatibility$Undefined$.MODULE$.apply(element) : (BsonCompatibility$Binary$.MODULE$.unapply(structType) ? BsonCompatibility$Binary$.MODULE$.apply(element) : (BsonCompatibility$Symbol$.MODULE$.unapply(structType) ? BsonCompatibility$Symbol$.MODULE$.apply(element) : (BsonCompatibility$DbPointer$.MODULE$.unapply(structType) ? BsonCompatibility$DbPointer$.MODULE$.apply(element) : this.rowToDocument(element)))))))))));
        return bsonValue;
    }

    private int toInt(BsonValue bsonValue) {
        block6: {
            int n;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!((Object)((Object)BsonType.DECIMAL128)).equals((Object)bsonType)) break block2;
                            n = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().intValue();
                            break block3;
                        }
                        if (!((Object)((Object)BsonType.INT32)).equals((Object)bsonType)) break block4;
                        n = bsonValue.asInt32().intValue();
                        break block3;
                    }
                    if (!((Object)((Object)BsonType.INT64)).equals((Object)bsonType)) break block5;
                    n = bsonValue.asInt64().intValue();
                    break block3;
                }
                if (!((Object)((Object)BsonType.DOUBLE)).equals((Object)bsonType)) break block6;
                n = bsonValue.asDouble().intValue();
            }
            return n;
        }
        throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a Int"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{bsonValue.getBsonType()})));
    }

    private long toLong(BsonValue bsonValue) {
        block6: {
            long l;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!((Object)((Object)BsonType.DECIMAL128)).equals((Object)bsonType)) break block2;
                            l = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().longValue();
                            break block3;
                        }
                        if (!((Object)((Object)BsonType.INT32)).equals((Object)bsonType)) break block4;
                        l = bsonValue.asInt32().longValue();
                        break block3;
                    }
                    if (!((Object)((Object)BsonType.INT64)).equals((Object)bsonType)) break block5;
                    l = bsonValue.asInt64().longValue();
                    break block3;
                }
                if (!((Object)((Object)BsonType.DOUBLE)).equals((Object)bsonType)) break block6;
                l = bsonValue.asDouble().longValue();
            }
            return l;
        }
        throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a Long"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{bsonValue.getBsonType()})));
    }

    private double toDouble(BsonValue bsonValue) {
        block6: {
            double d;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!((Object)((Object)BsonType.DECIMAL128)).equals((Object)bsonType)) break block2;
                            d = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().doubleValue();
                            break block3;
                        }
                        if (!((Object)((Object)BsonType.INT32)).equals((Object)bsonType)) break block4;
                        d = bsonValue.asInt32().doubleValue();
                        break block3;
                    }
                    if (!((Object)((Object)BsonType.INT64)).equals((Object)bsonType)) break block5;
                    d = bsonValue.asInt64().doubleValue();
                    break block3;
                }
                if (!((Object)((Object)BsonType.DOUBLE)).equals((Object)bsonType)) break block6;
                d = bsonValue.asDouble().doubleValue();
            }
            return d;
        }
        throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a Double"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{bsonValue.getBsonType()})));
    }

    private BigDecimal toDecimal(BsonValue bsonValue) {
        block6: {
            BigDecimal bigDecimal;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!((Object)((Object)BsonType.DECIMAL128)).equals((Object)bsonType)) break block2;
                            bigDecimal = BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bsonValue.asDecimal128().decimal128Value().bigDecimalValue());
                            break block3;
                        }
                        if (!((Object)((Object)BsonType.INT32)).equals((Object)bsonType)) break block4;
                        bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asInt32().intValue());
                        break block3;
                    }
                    if (!((Object)((Object)BsonType.INT64)).equals((Object)bsonType)) break block5;
                    bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asInt64().longValue());
                    break block3;
                }
                if (!((Object)((Object)BsonType.DOUBLE)).equals((Object)bsonType)) break block6;
                bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asDouble().doubleValue());
            }
            return bigDecimal;
        }
        throw new MongoTypeConversionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a BigDecimal"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{bsonValue.getBsonType()})));
    }

    private MapFunctions$() {
        MODULE$ = this;
    }
}

