/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.operation.BaseWriteOperation;
import com.mongodb.operation.OperationHelper;
import java.util.List;

public class UpdateOperation
extends BaseWriteOperation {
    private final List<UpdateRequest> updates;

    public UpdateOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern2, List<UpdateRequest> updates) {
        super(namespace, ordered, writeConcern2);
        this.updates = Assertions.notNull("update", updates);
    }

    public List<UpdateRequest> getUpdateRequests() {
        return this.updates;
    }

    @Override
    protected WriteConcernResult executeProtocol(Connection connection) {
        OperationHelper.validateWriteRequestCollations(connection, this.updates, this.getWriteConcern());
        return connection.update(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.updates);
    }

    @Override
    protected void executeProtocolAsync(AsyncConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        OperationHelper.validateWriteRequestCollations(connection, this.updates, this.getWriteConcern(), new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    connection.updateAsync(UpdateOperation.this.getNamespace(), UpdateOperation.this.isOrdered(), UpdateOperation.this.getWriteConcern(), UpdateOperation.this.updates, callback);
                }
            }
        });
    }

    @Override
    protected BulkWriteResult executeCommandProtocol(Connection connection) {
        OperationHelper.validateWriteRequestCollations(connection, this.updates, this.getWriteConcern());
        return connection.updateCommand(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.updates);
    }

    @Override
    protected void executeCommandProtocolAsync(AsyncConnection connection, final SingleResultCallback<BulkWriteResult> callback) {
        OperationHelper.validateWriteRequestCollations(connection, this.updates, this.getWriteConcern(), new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    connection.updateCommandAsync(UpdateOperation.this.getNamespace(), UpdateOperation.this.isOrdered(), UpdateOperation.this.getWriteConcern(), UpdateOperation.this.getBypassDocumentValidation(), UpdateOperation.this.updates, callback);
                }
            }
        });
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.UPDATE;
    }

    @Override
    protected int getCount(BulkWriteResult bulkWriteResult) {
        return bulkWriteResult.getMatchedCount() + bulkWriteResult.getUpserts().size();
    }

    @Override
    protected boolean getUpdatedExisting(BulkWriteResult bulkWriteResult) {
        return bulkWriteResult.getMatchedCount() > 0;
    }
}

