/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.IndexHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteConcernHelper;
import com.mongodb.operation.WriteOperation;
import org.bson.BsonDocument;
import org.bson.BsonString;

public class DropIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final String indexName;
    private final WriteConcern writeConcern;

    @Deprecated
    public DropIndexOperation(MongoNamespace namespace, String indexName) {
        this(namespace, indexName, null);
    }

    @Deprecated
    public DropIndexOperation(MongoNamespace namespace, BsonDocument keys) {
        this(namespace, keys, null);
    }

    public DropIndexOperation(MongoNamespace namespace, String indexName, WriteConcern writeConcern2) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexName = Assertions.notNull("indexName", indexName);
        this.writeConcern = writeConcern2;
    }

    public DropIndexOperation(MongoNamespace namespace, BsonDocument keys, WriteConcern writeConcern2) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexName = IndexHelper.generateIndexName(Assertions.notNull("keys", keys));
        this.writeConcern = writeConcern2;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(final WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                try {
                    CommandOperationHelper.executeWrappedCommandProtocol(binding, DropIndexOperation.this.namespace.getDatabaseName(), DropIndexOperation.this.getCommand(connection.getDescription()), connection, WriteConcernHelper.writeConcernErrorTransformer());
                }
                catch (MongoCommandException e) {
                    CommandOperationHelper.rethrowIfNotNamespaceError(e);
                }
                return null;
            }
        });
    }

    @Override
    public void executeAsync(final AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback releasingCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                    CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, DropIndexOperation.this.namespace.getDatabaseName(), DropIndexOperation.this.getCommand(connection.getDescription()), connection, WriteConcernHelper.writeConcernErrorTransformer(), new SingleResultCallback<Void>(){

                        @Override
                        public void onResult(Void result2, Throwable t) {
                            if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                                releasingCallback.onResult(null, t);
                            } else {
                                releasingCallback.onResult(result2, null);
                            }
                        }
                    });
                }
            }
        });
    }

    private BsonDocument getCommand(ConnectionDescription description) {
        BsonDocument commandDocument = new BsonDocument("dropIndexes", new BsonString(this.namespace.getCollectionName())).append("index", new BsonString(this.indexName));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument, description);
        return commandDocument;
    }
}

