/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.BaseWriteCommandMessage;
import com.mongodb.connection.MessageSettings;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.EncoderContext;
import org.bson.io.BsonOutput;

class UpdateCommandMessage
extends BaseWriteCommandMessage {
    private final List<UpdateRequest> updates;

    public UpdateCommandMessage(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern2, Boolean bypassDocumentValidation, MessageSettings settings, List<UpdateRequest> updates) {
        super(namespace, ordered, writeConcern2, bypassDocumentValidation, settings);
        this.updates = updates;
    }

    public List<UpdateRequest> getRequests() {
        return Collections.unmodifiableList(this.updates);
    }

    @Override
    protected UpdateCommandMessage writeTheWrites(BsonOutput bsonOutput, int commandStartPosition, BsonBinaryWriter writer) {
        UpdateCommandMessage nextMessage = null;
        writer.writeStartArray("updates");
        for (int i = 0; i < this.updates.size(); ++i) {
            writer.mark();
            UpdateRequest update2 = this.updates.get(i);
            writer.writeStartDocument();
            writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
            writer.writeName("q");
            this.getCodec(update2.getFilter()).encode(writer, update2.getFilter(), EncoderContext.builder().build());
            writer.writeName("u");
            int bufferPosition = bsonOutput.getPosition();
            this.getCodec(update2.getUpdate()).encode(writer, update2.getUpdate(), EncoderContext.builder().build());
            if (update2.getType() == WriteRequest.Type.UPDATE && bsonOutput.getPosition() == bufferPosition + 8) {
                throw new IllegalArgumentException("Invalid BSON document for an update");
            }
            if (update2.isMulti()) {
                writer.writeBoolean("multi", update2.isMulti());
            }
            if (update2.isUpsert()) {
                writer.writeBoolean("upsert", update2.isUpsert());
            }
            if (update2.getCollation() != null) {
                writer.writeName("collation");
                BsonDocument collation = update2.getCollation().asDocument();
                this.getCodec(collation).encode(writer, collation, EncoderContext.builder().build());
            }
            writer.popMaxDocumentSize();
            writer.writeEndDocument();
            if (!this.exceedsLimits(bsonOutput.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new UpdateCommandMessage(this.getWriteNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.getSettings(), this.updates.subList(i, this.updates.size()));
            break;
        }
        writer.writeEndArray();
        return nextMessage;
    }

    @Override
    public int getItemCount() {
        return this.updates.size();
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        HashMap<String, FieldNameValidator> rootMap = new HashMap<String, FieldNameValidator>();
        rootMap.put("updates", new UpdatesValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), rootMap);
    }

    @Override
    protected String getCommandName() {
        return "update";
    }

    private class UpdatesValidator
    implements FieldNameValidator {
        private int i = 0;

        private UpdatesValidator() {
        }

        @Override
        public boolean validate(String fieldName) {
            return true;
        }

        @Override
        public FieldNameValidator getValidatorForField(String fieldName) {
            if (!fieldName.equals("u")) {
                return new NoOpFieldNameValidator();
            }
            UpdateRequest updateRequest = UpdateCommandMessage.this.getRequests().get(this.i);
            ++this.i;
            if (updateRequest.getType() == WriteRequest.Type.REPLACE) {
                return new CollectibleDocumentFieldNameValidator();
            }
            return new UpdateFieldNameValidator();
        }
    }
}

