/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.Collation;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class IndexOptions {
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Long expireAfterSeconds;
    private Integer version;
    private Bson weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textVersion;
    private Integer sphereVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private Double bucketSize;
    private Bson storageEngine;
    private Bson partialFilterExpression;
    private Collation collation;

    public boolean isBackground() {
        return this.background;
    }

    public IndexOptions background(boolean background) {
        this.background = background;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public IndexOptions unique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public IndexOptions name(String name) {
        this.name = name;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public IndexOptions sparse(boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Long getExpireAfter(TimeUnit timeUnit) {
        if (this.expireAfterSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.expireAfterSeconds, TimeUnit.SECONDS);
    }

    public IndexOptions expireAfter(Long expireAfter, TimeUnit timeUnit) {
        this.expireAfterSeconds = expireAfter == null ? null : Long.valueOf(TimeUnit.SECONDS.convert(expireAfter, timeUnit));
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public IndexOptions version(Integer version) {
        this.version = version;
        return this;
    }

    public Bson getWeights() {
        return this.weights;
    }

    public IndexOptions weights(Bson weights) {
        this.weights = weights;
        return this;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public IndexOptions defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public IndexOptions languageOverride(String languageOverride) {
        this.languageOverride = languageOverride;
        return this;
    }

    public Integer getTextVersion() {
        return this.textVersion;
    }

    public IndexOptions textVersion(Integer textVersion) {
        this.textVersion = textVersion;
        return this;
    }

    public Integer getSphereVersion() {
        return this.sphereVersion;
    }

    public IndexOptions sphereVersion(Integer sphereVersion) {
        this.sphereVersion = sphereVersion;
        return this;
    }

    public Integer getBits() {
        return this.bits;
    }

    public IndexOptions bits(Integer bits2) {
        this.bits = bits2;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public IndexOptions min(Double min2) {
        this.min = min2;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public IndexOptions max(Double max2) {
        this.max = max2;
        return this;
    }

    public Double getBucketSize() {
        return this.bucketSize;
    }

    public IndexOptions bucketSize(Double bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public Bson getStorageEngine() {
        return this.storageEngine;
    }

    public IndexOptions storageEngine(Bson storageEngine) {
        this.storageEngine = storageEngine;
        return this;
    }

    public Bson getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public IndexOptions partialFilterExpression(Bson partialFilterExpression) {
        this.partialFilterExpression = partialFilterExpression;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public IndexOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }
}

