/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.kafka.source;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.descriptors.ConnectTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.table.descriptors.Kafka;
import org.apache.flink.table.descriptors.Rowtime;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.PropertiesUtil;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.flink.BaseFlinkSource;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.enums.FormatType;
import org.apache.seatunnel.flink.stream.FlinkStreamSource;
import org.apache.seatunnel.flink.util.SchemaUtil;
import org.apache.seatunnel.flink.util.TableUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={BaseFlinkSource.class})
public class KafkaTableStream
implements FlinkStreamSource {
    private static final long serialVersionUID = 5287018194573371428L;
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaTableStream.class);
    private Config config;
    private final Properties kafkaParams = new Properties();
    private String topic;
    private Object schemaInfo;
    private String rowTimeField;
    private String tableName;
    private final String consumerPrefix = "consumer.";
    private long watermark;
    private FormatType format;
    private static final String TOPICS = "topics";
    private static final String ROWTIME_FIELD = "rowtime.field";
    private static final String WATERMARK_VAL = "watermark";
    private static final String SCHEMA = "schema";
    private static final String SOURCE_FORMAT = "format.type";
    private static final String GROUP_ID = "group.id";
    private static final String BOOTSTRAP_SERVERS = "bootstrap.servers";
    private static final String OFFSET_RESET = "offset.reset";
    private static final int DEFAULT_INITIAL_CAPACITY = 16;

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        CheckResult result = CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{TOPICS, SCHEMA, SOURCE_FORMAT, "result_table_name"});
        if (result.isSuccess()) {
            Config consumerConfig = TypesafeConfigUtils.extractSubConfig((Config)this.config, (String)"consumer.", (boolean)false);
            return CheckConfigUtil.checkAllExists((Config)consumerConfig, (String[])new String[]{BOOTSTRAP_SERVERS, GROUP_ID});
        }
        return result;
    }

    public void prepare(FlinkEnvironment env) {
        this.topic = this.config.getString(TOPICS);
        PropertiesUtil.setProperties((Config)this.config, (Properties)this.kafkaParams, (String)"consumer.", (boolean)false);
        this.tableName = this.config.getString("result_table_name");
        if (this.config.hasPath(ROWTIME_FIELD)) {
            this.rowTimeField = this.config.getString(ROWTIME_FIELD);
            if (this.config.hasPath(WATERMARK_VAL)) {
                this.watermark = this.config.getLong(WATERMARK_VAL);
            }
        }
        String schemaContent = this.config.getString(SCHEMA);
        this.format = FormatType.from((String)this.config.getString(SOURCE_FORMAT).trim().toLowerCase());
        this.schemaInfo = JsonUtils.parseArray((String)schemaContent);
    }

    public String getPluginName() {
        return "KafkaTableStream";
    }

    public DataStream<Row> getData(FlinkEnvironment env) {
        StreamTableEnvironment tableEnvironment = env.getStreamTableEnvironment();
        ((ConnectTableDescriptor)((ConnectTableDescriptor)tableEnvironment.connect((ConnectorDescriptor)this.getKafkaConnect()).withFormat(this.setFormat())).withSchema(this.getSchema()).inAppendMode()).createTemporaryTable(this.tableName);
        Table table = tableEnvironment.scan(new String[]{this.tableName});
        return TableUtil.tableToDataStream((StreamTableEnvironment)tableEnvironment, (Table)table, (boolean)true);
    }

    private Schema getSchema() {
        Schema schema = new Schema();
        SchemaUtil.setSchema((Schema)schema, (Object)this.schemaInfo, (FormatType)this.format);
        if (StringUtils.isNotBlank((CharSequence)this.rowTimeField)) {
            Rowtime rowtime = new Rowtime();
            rowtime.timestampsFromField(this.rowTimeField);
            rowtime.watermarksPeriodicBounded(this.watermark);
            schema.rowtime(rowtime);
        }
        return schema;
    }

    private Kafka getKafkaConnect() {
        Kafka kafka = new Kafka().version("universal");
        kafka.topic(this.topic);
        kafka.properties(this.kafkaParams);
        if (this.config.hasPath(OFFSET_RESET)) {
            String reset;
            switch (reset = this.config.getString(OFFSET_RESET)) {
                case "latest": {
                    kafka.startFromLatest();
                    break;
                }
                case "earliest": {
                    kafka.startFromEarliest();
                    break;
                }
                case "specific": {
                    String offset = this.config.getString("offset.reset.specific");
                    Map map = (Map)JsonUtils.parseObject((String)offset, (TypeReference)new TypeReference<Map<Integer, Long>>(){});
                    kafka.startFromSpecificOffsets(map);
                    break;
                }
            }
        }
        return kafka;
    }

    private FormatDescriptor setFormat() {
        try {
            return SchemaUtil.setFormat((FormatType)this.format, (Config)this.config);
        }
        catch (Exception e) {
            LOGGER.warn("set format exception", e);
            throw new RuntimeException("format config error");
        }
    }
}

