/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.kafka.sink;

import com.google.auto.service.AutoService;
import java.util.Properties;
import org.apache.flink.formats.json.JsonRowSerializationSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.PropertiesUtil;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.flink.BaseFlinkSink;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.stream.FlinkStreamSink;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={BaseFlinkSink.class})
public class KafkaSink
implements FlinkStreamSink {
    private static final long serialVersionUID = 3980751499724935230L;
    private static final String DEFAULT_KAFKA_SEMANTIC = "at_least_once";
    private Config config;
    private Properties kafkaParams = new Properties();
    private String topic;
    private String semantic = "at_least_once";

    public void outputStream(FlinkEnvironment env, DataStream<Row> dataStream) {
        FlinkKafkaProducer rowFlinkKafkaProducer = new FlinkKafkaProducer(this.topic, JsonRowSerializationSchema.builder().withTypeInfo(dataStream.getType()).build(), this.kafkaParams, null, this.getSemanticEnum(this.semantic), 5);
        dataStream.addSink(rowFlinkKafkaProducer);
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"topics"});
    }

    public void prepare(FlinkEnvironment env) {
        this.topic = this.config.getString("topics");
        if (this.config.hasPath("semantic")) {
            this.semantic = this.config.getString("semantic");
        }
        String producerPrefix = "producer.";
        PropertiesUtil.setProperties((Config)this.config, (Properties)this.kafkaParams, (String)producerPrefix, (boolean)false);
        this.kafkaParams.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.kafkaParams.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
    }

    public String getPluginName() {
        return "Kafka";
    }

    private FlinkKafkaProducer.Semantic getSemanticEnum(String semantic) {
        if ("exactly_once".equals(semantic)) {
            return FlinkKafkaProducer.Semantic.EXACTLY_ONCE;
        }
        if (DEFAULT_KAFKA_SEMANTIC.equals(semantic)) {
            return FlinkKafkaProducer.Semantic.AT_LEAST_ONCE;
        }
        return FlinkKafkaProducer.Semantic.NONE;
    }
}

