/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.config.OffsetCommitMode;
import org.apache.flink.streaming.connectors.kafka.internals.AbstractFetcher;
import org.apache.flink.streaming.connectors.kafka.internals.AbstractPartitionDiscoverer;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaDeserializationSchemaWrapper;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaFetcher;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaPartitionDiscoverer;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicsDescriptor;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.PropertiesUtil;
import org.apache.flink.util.SerializedValue;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

@PublicEvolving
public class FlinkKafkaConsumer<T>
extends FlinkKafkaConsumerBase<T> {
    private static final long serialVersionUID = 1L;
    public static final String KEY_POLL_TIMEOUT = "flink.poll-timeout";
    public static final long DEFAULT_POLL_TIMEOUT = 100L;
    protected final Properties properties;
    protected final long pollTimeout;

    public FlinkKafkaConsumer(String topic, DeserializationSchema<T> valueDeserializer, Properties props) {
        this(Collections.singletonList(topic), valueDeserializer, props);
    }

    public FlinkKafkaConsumer(String topic, KafkaDeserializationSchema<T> deserializer, Properties props) {
        this(Collections.singletonList(topic), deserializer, props);
    }

    public FlinkKafkaConsumer(List<String> topics, DeserializationSchema<T> deserializer, Properties props) {
        this(topics, new KafkaDeserializationSchemaWrapper<T>(deserializer), props);
    }

    public FlinkKafkaConsumer(List<String> topics, KafkaDeserializationSchema<T> deserializer, Properties props) {
        this(topics, null, deserializer, props);
    }

    public FlinkKafkaConsumer(Pattern subscriptionPattern, DeserializationSchema<T> valueDeserializer, Properties props) {
        this(null, subscriptionPattern, new KafkaDeserializationSchemaWrapper<T>(valueDeserializer), props);
    }

    public FlinkKafkaConsumer(Pattern subscriptionPattern, KafkaDeserializationSchema<T> deserializer, Properties props) {
        this(null, subscriptionPattern, deserializer, props);
    }

    private FlinkKafkaConsumer(List<String> topics, Pattern subscriptionPattern, KafkaDeserializationSchema<T> deserializer, Properties props) {
        super(topics, subscriptionPattern, deserializer, PropertiesUtil.getLong((Properties)((Properties)Preconditions.checkNotNull((Object)props, (String)"props")), (String)"flink.partition-discovery.interval-millis", (long)Long.MIN_VALUE), !PropertiesUtil.getBoolean((Properties)props, (String)"flink.disable-metrics", (boolean)false));
        this.properties = props;
        FlinkKafkaConsumer.setDeserializer(this.properties);
        try {
            this.pollTimeout = this.properties.containsKey(KEY_POLL_TIMEOUT) ? Long.parseLong(this.properties.getProperty(KEY_POLL_TIMEOUT)) : 100L;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse poll timeout for 'flink.poll-timeout'", e);
        }
    }

    @Override
    protected AbstractFetcher<T, ?> createFetcher(SourceFunction.SourceContext<T> sourceContext, Map<KafkaTopicPartition, Long> assignedPartitionsWithInitialOffsets, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, StreamingRuntimeContext runtimeContext, OffsetCommitMode offsetCommitMode, MetricGroup consumerMetricGroup, boolean useMetrics) throws Exception {
        FlinkKafkaConsumer.adjustAutoCommitConfig(this.properties, offsetCommitMode);
        return new KafkaFetcher<T>(sourceContext, assignedPartitionsWithInitialOffsets, watermarkStrategy, runtimeContext.getProcessingTimeService(), runtimeContext.getExecutionConfig().getAutoWatermarkInterval(), runtimeContext.getUserCodeClassLoader(), runtimeContext.getTaskNameWithSubtasks(), this.deserializer, this.properties, this.pollTimeout, runtimeContext.getMetricGroup(), consumerMetricGroup, useMetrics);
    }

    @Override
    protected AbstractPartitionDiscoverer createPartitionDiscoverer(KafkaTopicsDescriptor topicsDescriptor, int indexOfThisSubtask, int numParallelSubtasks) {
        return new KafkaPartitionDiscoverer(topicsDescriptor, indexOfThisSubtask, numParallelSubtasks, this.properties);
    }

    @Override
    protected Map<KafkaTopicPartition, Long> fetchOffsetsWithTimestamp(Collection<KafkaTopicPartition> partitions, long timestamp) {
        HashMap<TopicPartition, Long> partitionOffsetsRequest = new HashMap<TopicPartition, Long>(partitions.size());
        for (KafkaTopicPartition partition : partitions) {
            partitionOffsetsRequest.put(new TopicPartition(partition.getTopic(), partition.getPartition()), timestamp);
        }
        HashMap<KafkaTopicPartition, Long> result = new HashMap<KafkaTopicPartition, Long>(partitions.size());
        try (KafkaConsumer consumer = new KafkaConsumer(this.properties);){
            for (Map.Entry<TopicPartition, OffsetAndTimestamp> partitionToOffset : consumer.offsetsForTimes(partitionOffsetsRequest).entrySet()) {
                result.put(new KafkaTopicPartition(partitionToOffset.getKey().topic(), partitionToOffset.getKey().partition()), partitionToOffset.getValue() == null ? null : Long.valueOf(partitionToOffset.getValue().offset()));
            }
        }
        return result;
    }

    @Override
    protected boolean getIsAutoCommitEnabled() {
        return PropertiesUtil.getBoolean((Properties)this.properties, (String)"enable.auto.commit", (boolean)true) && PropertiesUtil.getLong((Properties)this.properties, (String)"auto.commit.interval.ms", (long)5000L) > 0L;
    }

    private static void setDeserializer(Properties props) {
        String deSerName = ByteArrayDeserializer.class.getName();
        Object keyDeSer = props.get("key.deserializer");
        Object valDeSer = props.get("value.deserializer");
        if (keyDeSer != null && !keyDeSer.equals(deSerName)) {
            LOG.warn("Ignoring configured key DeSerializer ({})", (Object)"key.deserializer");
        }
        if (valDeSer != null && !valDeSer.equals(deSerName)) {
            LOG.warn("Ignoring configured value DeSerializer ({})", (Object)"value.deserializer");
        }
        props.put("key.deserializer", deSerName);
        props.put("value.deserializer", deSerName);
    }
}

