/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class SniffedXmlInputStream
extends BufferedInputStream {
    public static int MAX_SNIFFED_BYTES = 192;
    private static Charset dummy1 = Charset.forName("UTF-8");
    private static Charset dummy2 = Charset.forName("UTF-16");
    private static Charset dummy3 = Charset.forName("UTF-16BE");
    private static Charset dummy4 = Charset.forName("UTF-16LE");
    private static Charset dummy5 = Charset.forName("ISO-8859-1");
    private static Charset dummy6 = Charset.forName("US-ASCII");
    private static Charset dummy7 = Charset.forName("Cp1252");
    private String _encoding = this.sniffFourBytes();
    private static char[] WHITESPACE = new char[]{' ', '\r', '\t', '\n'};
    private static char[] NOTNAME = new char[]{'=', ' ', '\r', '\t', '\n', '?', '>', '<', '\'', '\"'};

    public SniffedXmlInputStream(InputStream stream) throws IOException {
        super(stream);
        String encoding;
        if (this._encoding != null && this._encoding.equals("IBM037") && (encoding = this.sniffForXmlDecl(this._encoding)) != null) {
            this._encoding = encoding;
        }
        if (this._encoding == null) {
            this._encoding = this.sniffForXmlDecl("UTF-8");
        }
        if (this._encoding == null) {
            this._encoding = "UTF-8";
        }
    }

    private int readAsMuchAsPossible(byte[] buf, int startAt, int len) throws IOException {
        int total;
        int count2;
        for (total = 0; total < len && (count2 = this.read(buf, startAt + total, len - total)) >= 0; total += count2) {
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sniffFourBytes() throws IOException {
        this.mark(4);
        boolean skip = false;
        try {
            byte[] buf = new byte[4];
            if (this.readAsMuchAsPossible(buf, 0, 4) < 4) {
                String string2 = null;
                return string2;
            }
            long result2 = 0xFF000000 & buf[0] << 24 | 0xFF0000 & buf[1] << 16 | 0xFF00 & buf[2] << 8 | 0xFF & buf[3];
            if (result2 == 65279L) {
                String string3 = "UCS-4";
                return string3;
            }
            if (result2 == -131072L) {
                String string4 = "UCS-4";
                return string4;
            }
            if (result2 == 60L) {
                String string5 = "UCS-4BE";
                return string5;
            }
            if (result2 == 0x3C000000L) {
                String string6 = "UCS-4LE";
                return string6;
            }
            if (result2 == 3932223L) {
                String string7 = "UTF-16BE";
                return string7;
            }
            if (result2 == 1006649088L) {
                String string8 = "UTF-16LE";
                return string8;
            }
            if (result2 == 1010792557L) {
                String string9 = null;
                return string9;
            }
            if (result2 == 1282385812L) {
                String string10 = "IBM037";
                return string10;
            }
            if ((result2 & 0xFFFFFFFFFFFF0000L) == -16842752L) {
                String string11 = "UTF-16";
                return string11;
            }
            if ((result2 & 0xFFFFFFFFFFFF0000L) == -131072L) {
                String string12 = "UTF-16";
                return string12;
            }
            if ((result2 & 0xFFFFFFFFFFFFFF00L) == -272908544L) {
                String string13 = "UTF-8";
                return string13;
            }
            String string14 = null;
            return string14;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sniffForXmlDecl(String encoding) throws IOException {
        this.mark(MAX_SNIFFED_BYTES);
        try {
            int limit;
            int count2;
            byte[] bytebuf = new byte[MAX_SNIFFED_BYTES];
            int bytelimit = this.readAsMuchAsPossible(bytebuf, 0, MAX_SNIFFED_BYTES);
            Charset charset = Charset.forName(encoding);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytebuf, 0, bytelimit), charset);
            char[] buf = new char[bytelimit];
            for (limit = 0; limit < bytelimit && (count2 = ((Reader)reader).read(buf, limit, bytelimit - limit)) >= 0; limit += count2) {
            }
            String string2 = SniffedXmlInputStream.extractXmlDeclEncoding(buf, 0, limit);
            return string2;
        }
        finally {
            this.reset();
        }
    }

    public String getXmlEncoding() {
        return this._encoding;
    }

    static String extractXmlDeclEncoding(char[] buf, int offset, int size2) {
        int limit = offset + size2;
        int xmlpi = SniffedXmlInputStream.firstIndexOf("<?xml", buf, offset, limit);
        if (xmlpi >= 0) {
            int i = xmlpi + 5;
            ScannedAttribute attr = new ScannedAttribute();
            while (i < limit) {
                if ((i = SniffedXmlInputStream.scanAttribute(buf, i, limit, attr)) < 0) {
                    return null;
                }
                if (!attr.name.equals("encoding")) continue;
                return attr.value;
            }
        }
        return null;
    }

    private static int firstIndexOf(String s2, char[] buf, int startAt, int limit) {
        assert (s2.length() > 0);
        char[] lookFor = s2.toCharArray();
        char firstchar = lookFor[0];
        limit -= lookFor.length;
        while (startAt < limit) {
            block5: {
                if (buf[startAt] == firstchar) {
                    for (int i = 1; i < lookFor.length; ++i) {
                        if (buf[startAt + i] == lookFor[i]) {
                            continue;
                        }
                        break block5;
                    }
                    return startAt;
                }
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextNonmatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            block3: {
                char thischar = buf[startAt];
                for (int i = 0; i < lookFor.length; ++i) {
                    if (thischar != lookFor[i]) {
                        continue;
                    }
                    break block3;
                }
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            char thischar = buf[startAt];
            for (int i = 0; i < lookFor.length; ++i) {
                if (thischar != lookFor[i]) continue;
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            if (buf[startAt] == lookFor) {
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int scanAttribute(char[] buf, int startAt, int limit, ScannedAttribute attr) {
        int nameStart = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, startAt, limit);
        if (nameStart < 0) {
            return -1;
        }
        int nameEnd = SniffedXmlInputStream.nextMatchingByte(NOTNAME, buf, nameStart, limit);
        if (nameEnd < 0) {
            return -1;
        }
        int equals2 = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, nameEnd, limit);
        if (equals2 < 0) {
            return -1;
        }
        if (buf[equals2] != '=') {
            return -1;
        }
        int valQuote = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, equals2 + 1, limit);
        if (buf[valQuote] != '\'' && buf[valQuote] != '\"') {
            return -1;
        }
        int valEndquote = SniffedXmlInputStream.nextMatchingByte(buf[valQuote], buf, valQuote + 1, limit);
        if (valEndquote < 0) {
            return -1;
        }
        attr.name = new String(buf, nameStart, nameEnd - nameStart);
        attr.value = new String(buf, valQuote + 1, valEndquote - valQuote - 1);
        return valEndquote + 1;
    }

    private static class ScannedAttribute {
        public String name;
        public String value;

        private ScannedAttribute() {
        }
    }
}

