/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.streaming;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.IncrementalRelation;
import org.apache.hudi.MergeOnReadIncrementalRelation;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset$;
import org.apache.spark.sql.hudi.streaming.HoodieStreamSource$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001=\u0011!\u0003S8pI&,7\u000b\u001e:fC6\u001cv.\u001e:dK*\u00111\u0001B\u0001\ngR\u0014X-Y7j]\u001eT!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0007\u0001AAr$J\u0016\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!G\u000f\u000e\u0003iQ!aA\u000e\u000b\u0005q1\u0011!C3yK\u000e,H/[8o\u0013\tq\"D\u0001\u0004T_V\u00148-\u001a\t\u0003A\rj\u0011!\t\u0006\u0003E!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003I\u0005\u0012q\u0001T8hO&tw\r\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002-]5\tQF\u0003\u0002\u0006\u0015%\u0011q&\f\u0002\u0014'B\f'o[!eCB$XM]*vaB|'\u000f\u001e\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\u0005M\"T\"\u0001\u0004\n\u0005U2!AC*R\u0019\u000e{g\u000e^3yi\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\u0007nKR\fG-\u0019;b!\u0006$\b\u000e\u0005\u0002:y9\u0011aEO\u0005\u0003w\u001d\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111h\n\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006a1o\u00195f[\u0006|\u0005\u000f^5p]B\u0019aE\u0011#\n\u0005\r;#AB(qi&|g\u000e\u0005\u0002F\u00116\taI\u0003\u0002H\r\u0005)A/\u001f9fg&\u0011\u0011J\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003:\u001bbB\u0014B\u0001(?\u0005\ri\u0015\r\u001d\u0005\u0006!\u0002!\t!U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI#VKV,\u0011\u0005M\u0003Q\"\u0001\u0002\t\u000bEz\u0005\u0019\u0001\u001a\t\u000b]z\u0005\u0019\u0001\u001d\t\u000b\u0001{\u0005\u0019A!\t\u000b-{\u0005\u0019\u0001'\t\u000fe\u0003!\u0019!C\u00055\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\t\r|gN\u001a\u0006\u0003A*\ta\u0001[1e_>\u0004\u0018B\u00012^\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1A\r\u0001Q\u0001\nm\u000b1\u0002[1e_>\u00048i\u001c8gA!\u00121M\u001a\t\u0003M\u001dL!\u0001[\u0014\u0003\u0013Q\u0014\u0018M\\:jK:$\b\u0002\u00036\u0001\u0011\u000b\u0007I\u0011B6\u0002\u0013Q\f'\r\\3QCRDW#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=|\u0016A\u00014t\u0013\t\thN\u0001\u0003QCRD\u0007\u0002C:\u0001\u0011\u0003\u0005\u000b\u0015\u00027\u0002\u0015Q\f'\r\\3QCRD\u0007\u0005\u0003\u0005v\u0001!\u0015\r\u0011\"\u0003w\u0003)iW\r^1DY&,g\u000e^\u000b\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003y6\naaY8n[>t\u0017B\u0001@z\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RD\u0011\"!\u0001\u0001\u0011\u0003\u0005\u000b\u0015B<\u0002\u00175,G/Y\"mS\u0016tG\u000f\t\u0005\u000b\u0003\u000b\u0001\u0001R1A\u0005\n\u0005\u001d\u0011!\u0003;bE2,G+\u001f9f+\t\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tya_\u0001\u0006[>$W\r\\\u0005\u0005\u0003'\tiAA\bI_>$\u0017.\u001a+bE2,G+\u001f9f\u0011)\t9\u0002\u0001E\u0001B\u0003&\u0011\u0011B\u0001\u000bi\u0006\u0014G.\u001a+za\u0016\u0004\u0003bCA\u000e\u0001\u0001\u0007\t\u0019!C\u0005\u0003;\t!\u0002\\1ti>3gm]3u+\t\ty\u0002E\u0002T\u0003CI1!a\t\u0003\u0005IAun\u001c3jKN{WO]2f\u001f\u001a47/\u001a;\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013%\u0011\u0011F\u0001\u000fY\u0006\u001cHo\u00144gg\u0016$x\fJ3r)\u0011\tY#!\r\u0011\u0007\u0019\ni#C\u0002\u00020\u001d\u0012A!\u00168ji\"Q\u00111GA\u0013\u0003\u0003\u0005\r!a\b\u0002\u0007a$\u0013\u0007\u0003\u0005\u00028\u0001\u0001\u000b\u0015BA\u0010\u0003-a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0011)\u0007\u0005Ub\r\u0003\u0006\u0002>\u0001A)\u0019!C\u0005\u0003;\ta\"\u001b8ji&\fGn\u00144gg\u0016$8\u000f\u0003\u0006\u0002B\u0001A\t\u0011)Q\u0005\u0003?\tq\"\u001b8ji&\fGn\u00144gg\u0016$8\u000f\t\u0015\u0004\u0003\u007f1\u0007bBA$\u0001\u0011%\u0011\u0011J\u0001\u000bO\u0016$h+\u001a:tS>tG\u0003BA&\u0003#\u00022AJA'\u0013\r\tye\n\u0002\u0004\u0013:$\bbBA*\u0003\u000b\u0002\r\u0001O\u0001\fm\u0016\u00148/[8o\u0019&tW\rC\u0004\u0002X\u0001!\t%!\u0017\u0002\rM\u001c\u0007.Z7b+\u0005!\u0005bBA/\u0001\u0011\u0005\u0013qL\u0001\nO\u0016$xJ\u001a4tKR,\"!!\u0019\u0011\t\u0019\u0012\u00151\r\t\u00043\u0005\u0015\u0014bAA45\t1qJ\u001a4tKRDq!a\u001b\u0001\t\u0003\ni'\u0001\u0005hKR\u0014\u0015\r^2i)\u0019\ty'a%\u0002\u0018B!\u0011\u0011OAG\u001d\u0011\t\u0019(!#\u000f\t\u0005U\u0014q\u0011\b\u0005\u0003o\n)I\u0004\u0003\u0002z\u0005\re\u0002BA>\u0003\u0003k!!! \u000b\u0007\u0005}d\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\u0005-e!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0015\u0011\u0013\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a#\u0007\u0011!\t)*!\u001bA\u0002\u0005\u0005\u0014!B:uCJ$\b\u0002CAM\u0003S\u0002\r!a\u0019\u0002\u0007\u0015tG\rC\u0004\u0002\u001e\u0002!I!a(\u0002\u001fM$\u0018M\u001d;D_6l\u0017\u000e\u001e+j[\u0016$2\u0001OAQ\u0011!\t\u0019+a'A\u0002\u0005}\u0011aC:uCJ$xJ\u001a4tKRDq!a*\u0001\t\u0003\nI+\u0001\u0003ti>\u0004HCAA\u0016\u000f\u001d\tiK\u0001E\u0001\u0003_\u000b!\u0003S8pI&,7\u000b\u001e:fC6\u001cv.\u001e:dKB\u00191+!-\u0007\r\u0005\u0011\u0001\u0012AAZ'\u0015\t\t,!.&!\r1\u0013qW\u0005\u0004\u0003s;#AB!osJ+g\rC\u0004Q\u0003c#\t!!0\u0015\u0005\u0005=\u0006BCAa\u0003c\u0013\r\u0011\"\u0001\u0002D\u00069a+\u0012*T\u0013>sUCAA&\u0011%\t9-!-!\u0002\u0013\tY%\u0001\u0005W\u000bJ\u001b\u0016j\u0014(!\u0011)\tY-!-\u0002\u0002\u0013%\u0011QZ\u0001\fe\u0016\fGMU3t_24X\rF\u0001\u0011\u0001")
public class HoodieStreamSource
implements Source,
Logging,
Serializable,
SparkAdapterSupport {
    public final SQLContext org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext;
    public final String org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metadataPath;
    private final Option<StructType> schemaOption;
    private final Map<String, String> parameters;
    private final transient Configuration hadoopConf;
    private Path tablePath;
    private HoodieTableMetaClient org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient;
    private HoodieTableType tableType;
    private transient HoodieSourceOffset lastOffset;
    private transient HoodieSourceOffset org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets;
    private final SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int VERSION() {
        return HoodieStreamSource$.MODULE$.VERSION();
    }

    private Path tablePath$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Path path = new Path((String)this.parameters.getOrElse((Object)"path", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Missing 'path' option";
                    }
                }));
                FileSystem fs = path.getFileSystem(this.hadoopConf());
                this.tablePath = TablePathUtils.getTablePath(fs, path).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.tablePath;
        }
    }

    private HoodieTableMetaClient org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf()).setBasePath(this.tablePath().toString()).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient;
        }
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tableType = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient().getTableType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.tableType;
        }
    }

    private HoodieSourceOffset org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if (!this.bitmap$trans$0) {
                HDFSMetadataLog<HoodieSourceOffset> metadataLog = new HDFSMetadataLog<HoodieSourceOffset>(this){
                    private final /* synthetic */ HoodieStreamSource $outer;

                    public void serialize(HoodieSourceOffset metadata, OutputStream out) {
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                        writer.write(new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)HoodieStreamSource$.MODULE$.VERSION())).append((Object)"\n").toString());
                        writer.write(metadata.json());
                        writer.flush();
                    }

                    public HoodieSourceOffset deserialize(InputStream in) {
                        String content = FileIOUtils.readAsUTFString(in);
                        int firstLineEnd = content.indexOf("\n");
                        if (firstLineEnd > 0) {
                            int version = this.$outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$getVersion(content.substring(0, firstLineEnd));
                            if (version > HoodieStreamSource$.MODULE$.VERSION()) {
                                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnSupportVersion: max support version is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)HoodieStreamSource$.MODULE$.VERSION())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" current version is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)}))).toString());
                            }
                            return HoodieSourceOffset$.MODULE$.fromJson(content.substring(firstLineEnd + 1));
                        }
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad metadata format, failed to find the version line."})).s((Seq)Nil$.MODULE$));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.sparkSession(), $outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metadataPath, ClassTag$.MODULE$.apply(HoodieSourceOffset.class));
                    }
                };
                this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets = (HoodieSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0)new Serializable(this, (HDFSMetadataLog)metadataLog){
                    public static final long serialVersionUID = 0L;
                    private final HDFSMetadataLog metadataLog$1;

                    public final HoodieSourceOffset apply() {
                        this.metadataLog$1.add(0L, (Object)((Object)HoodieSourceOffset$.MODULE$.INIT_OFFSET()));
                        return HoodieSourceOffset$.MODULE$.INIT_OFFSET();
                    }
                    {
                        this.metadataLog$1 = metadataLog$1;
                    }
                }));
                this.bitmap$trans$0 = true;
            }
            return this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets;
        }
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public void commit(Offset end) {
        Source.class.commit((Source)this, (Offset)end);
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path tablePath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tablePath$lzycompute() : this.tablePath;
    }

    public HoodieTableMetaClient org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient$lzycompute() : this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient;
    }

    private HoodieTableType tableType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private HoodieSourceOffset lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(HoodieSourceOffset x$1) {
        this.lastOffset = x$1;
    }

    public HoodieSourceOffset org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets() {
        return this.bitmap$trans$0 ? this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets : this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets$lzycompute();
    }

    public int org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$getVersion(String versionLine) {
        if (versionLine.startsWith("v")) {
            return new StringOps(Predef$.MODULE$.augmentString(versionLine.substring(1))).toInt();
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal version line: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versionLine}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in the streaming metadata path"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public StructType schema() {
        return (StructType)this.schemaOption.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieStreamSource $outer;

            public final StructType apply() {
                TableSchemaResolver schemaUtil = new TableSchemaResolver(this.$outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient());
                return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaUtil.getTableAvroSchema());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Offset> getOffset() {
        this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient().reloadActiveTimeline();
        HoodieTimeline activeInstants = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient().getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        if (activeInstants.empty()) {
            this.lastOffset_$eq(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets());
        } else {
            String currentLatestCommitTime = activeInstants.lastInstant().get().getTimestamp();
            if (this.lastOffset() == null || new StringOps(Predef$.MODULE$.augmentString(currentLatestCommitTime)).$greater((Object)this.lastOffset().commitTime())) {
                this.lastOffset_$eq(new HoodieSourceOffset(currentLatestCommitTime));
            }
        }
        return new Some((Object)this.lastOffset());
    }

    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        block6: {
            Dataset dataset;
            block3: {
                RDD<Row> rDD;
                block5: {
                    HoodieTableType hoodieTableType;
                    Map incParams;
                    block4: {
                        HoodieSourceOffset endOffset;
                        HoodieSourceOffset startOffset;
                        block2: {
                            this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets();
                            startOffset = (HoodieSourceOffset)((Object)start.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final HoodieSourceOffset apply(Offset x$1) {
                                    return HoodieSourceOffset$.MODULE$.apply(x$1);
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ HoodieStreamSource $outer;

                                public final HoodieSourceOffset apply() {
                                    return this.$outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            endOffset = HoodieSourceOffset$.MODULE$.apply(end);
                            HoodieSourceOffset hoodieSourceOffset = startOffset;
                            HoodieSourceOffset hoodieSourceOffset2 = endOffset;
                            if (hoodieSourceOffset != null ? !((Object)((Object)hoodieSourceOffset)).equals((Object)hoodieSourceOffset2) : hoodieSourceOffset2 != null) break block2;
                            dataset = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.internalCreateDataFrame(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
                            break block3;
                        }
                        incParams = this.parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key()), (Object)this.startCommitTime(startOffset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key()), (Object)endOffset.commitTime())})));
                        hoodieTableType = this.tableType();
                        if (!((Object)((Object)HoodieTableType.COPY_ON_WRITE)).equals((Object)hoodieTableType)) break block4;
                        SparkRowSerDe serDe = this.sparkAdapter().createSparkRowSerDe((ExpressionEncoder<Row>)RowEncoder$.MODULE$.apply(this.schema()));
                        rDD = new IncrementalRelation(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext, (Map<String, String>)incParams, this.schema(), this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient()).buildScan().map((Function1)new Serializable(this, serDe){
                            public static final long serialVersionUID = 0L;
                            private final SparkRowSerDe serDe$1;

                            public final InternalRow apply(Row x$1) {
                                return this.serDe$1.serializeRow(x$1);
                            }
                            {
                                this.serDe$1 = serDe$1;
                            }
                        }, ClassTag$.MODULE$.apply(InternalRow.class));
                        break block5;
                    }
                    if (!((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieTableType)) break block6;
                    String[] requiredColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])this.schema().fields()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(StructField x$2) {
                            return x$2.name();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    rDD = new MergeOnReadIncrementalRelation(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext, (Map<String, String>)incParams, this.schema(), this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient()).buildScan(requiredColumns, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
                }
                RDD<Row> rdd = rDD;
                dataset = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.internalCreateDataFrame((RDD)rdd, this.schema(), true);
            }
            return dataset;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnSupport tableType: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableType()})));
    }

    private String startCommitTime(HoodieSourceOffset startOffset) {
        block4: {
            String string;
            block3: {
                HoodieSourceOffset hoodieSourceOffset;
                block2: {
                    hoodieSourceOffset = startOffset;
                    HoodieSourceOffset hoodieSourceOffset2 = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
                    HoodieSourceOffset hoodieSourceOffset3 = hoodieSourceOffset;
                    if (hoodieSourceOffset2 != null ? !((Object)((Object)hoodieSourceOffset2)).equals((Object)hoodieSourceOffset3) : hoodieSourceOffset3 != null) break block2;
                    string = startOffset.commitTime();
                    break block3;
                }
                if (hoodieSourceOffset == null) break block4;
                String commitTime = hoodieSourceOffset.commitTime();
                long time = HoodieActiveTimeline.parseDateFromInstantTime(commitTime).getTime();
                string = HoodieActiveTimeline.formatDate(new Date(time + 1000L));
            }
            return string;
        }
        throw new IllegalStateException("UnKnow offset type.");
    }

    public void stop() {
    }

    public HoodieStreamSource(SQLContext sqlContext, String metadataPath, Option<StructType> schemaOption, Map<String, String> parameters) {
        this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext = sqlContext;
        this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metadataPath = metadataPath;
        this.schemaOption = schemaOption;
        this.parameters = parameters;
        Source.class.$init$((Source)this);
        Logging.class.$init$((Logging)this);
        SparkAdapterSupport$class.$init$(this);
        this.hadoopConf = sqlContext.sparkSession().sessionState().newHadoopConf();
    }
}

