/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand;
import org.apache.spark.sql.execution.command.AlterTableDropPartitionCommand;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand;
import org.apache.spark.sql.execution.command.ShowPartitionsCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand;
import org.apache.spark.sql.hudi.HoodieSqlUtils$;
import org.apache.spark.sql.hudi.analysis.HoodiePostAnalysisRule$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableDropPartitionCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableRenameCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.ShowHoodieTablePartitionsCommand;
import org.apache.spark.sql.hudi.command.TruncateHoodieTableCommand;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001>\u0011a\u0003S8pI&,\u0007k\\:u\u0003:\fG._:jgJ+H.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\tA\u0001[;eS*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u0011'!\r\tb\u0003G\u0007\u0002%)\u00111\u0003F\u0001\u0006eVdWm\u001d\u0006\u0003+\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0003/I\u0011AAU;mKB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\bY><\u0017nY1m\u0015\tiB#A\u0003qY\u0006t7/\u0003\u0002 5\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u001d\u0001&o\u001c3vGR\u0004\"!I\u0014\n\u0005!\u0012#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0016\u0001\u0005+\u0007I\u0011A\u0016\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u00031\u0002\"!\f\u0018\u000e\u0003\u0019I!a\f\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u0011E\u0002!\u0011#Q\u0001\n1\nQb\u001d9be.\u001cVm]:j_:\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\b\u0006\u00026oA\u0011a\u0007A\u0007\u0002\u0005!)!F\ra\u0001Y!)\u0011\b\u0001C!u\u0005)\u0011\r\u001d9msR\u0011\u0001d\u000f\u0005\u0006ya\u0002\r\u0001G\u0001\u0005a2\fg\u000eC\u0004?\u0001\u0005\u0005I\u0011A \u0002\t\r|\u0007/\u001f\u000b\u0003k\u0001CqAK\u001f\u0011\u0002\u0003\u0007A\u0006C\u0004C\u0001E\u0005I\u0011A\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAI\u000b\u0002-\u000b.\na\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u0017\n\n!\"\u00198o_R\fG/[8o\u0013\ti\u0005JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dqa\u0014\u0001\u0002\u0002\u0013\u0005\u0003+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005Y\u0006twMC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&AB*ue&tw\rC\u0004[\u0001\u0005\u0005I\u0011A.\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003q\u0003\"!I/\n\u0005y\u0013#aA%oi\"9\u0001\rAA\u0001\n\u0003\t\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0003E\u0016\u0004\"!I2\n\u0005\u0011\u0014#aA!os\"9amXA\u0001\u0002\u0004a\u0016a\u0001=%c!9\u0001\u000eAA\u0001\n\u0003J\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003)\u00042a\u001b8c\u001b\u0005a'BA7#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003_2\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\bc\u0002\t\t\u0011\"\u0001s\u0003!\u0019\u0017M\\#rk\u0006dGCA:w!\t\tC/\u0003\u0002vE\t9!i\\8mK\u0006t\u0007b\u00024q\u0003\u0003\u0005\rA\u0019\u0005\bq\u0002\t\t\u0011\"\u0011z\u0003!A\u0017m\u001d5D_\u0012,G#\u0001/\t\u000fm\u0004\u0011\u0011!C!y\u0006AAo\\*ue&tw\rF\u0001R\u0011\u001dq\b!!A\u0005B}\fa!Z9vC2\u001cHcA:\u0002\u0002!9a-`A\u0001\u0002\u0004\u0011w!CA\u0003\u0005\u0005\u0005\t\u0012AA\u0004\u0003YAun\u001c3jKB{7\u000f^!oC2L8/[:Sk2,\u0007c\u0001\u001c\u0002\n\u0019A\u0011AAA\u0001\u0012\u0003\tYaE\u0003\u0002\n\u00055a\u0005\u0005\u0004\u0002\u0010\u0005UA&N\u0007\u0003\u0003#Q1!a\u0005#\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u0006\u0002\u0012\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000fM\nI\u0001\"\u0001\u0002\u001cQ\u0011\u0011q\u0001\u0005\tw\u0006%\u0011\u0011!C#y\"I\u0011(!\u0003\u0002\u0002\u0013\u0005\u0015\u0011\u0005\u000b\u0004k\u0005\r\u0002B\u0002\u0016\u0002 \u0001\u0007A\u0006\u0003\u0006\u0002(\u0005%\u0011\u0011!CA\u0003S\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002,\u0005E\u0002\u0003B\u0011\u0002.1J1!a\f#\u0005\u0019y\u0005\u000f^5p]\"I\u00111GA\u0013\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\u0002\u0004BCA\u001c\u0003\u0013\t\t\u0011\"\u0003\u0002:\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u0004E\u0002S\u0003{I1!a\u0010T\u0005\u0019y%M[3di\u0002")
public class HoodiePostAnalysisRule
extends Rule<LogicalPlan>
implements Product,
Serializable {
    private final SparkSession sparkSession;

    public static Option<SparkSession> unapply(HoodiePostAnalysisRule hoodiePostAnalysisRule) {
        return HoodiePostAnalysisRule$.MODULE$.unapply(hoodiePostAnalysisRule);
    }

    public static <A> Function1<SparkSession, A> andThen(Function1<HoodiePostAnalysisRule, A> function1) {
        return HoodiePostAnalysisRule$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, HoodiePostAnalysisRule> compose(Function1<A, SparkSession> function1) {
        return HoodiePostAnalysisRule$.MODULE$.compose(function1);
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LogicalPlan apply(LogicalPlan plan) {
        void var6_14;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof CreateDataSourceTableCommand) {
            CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)logicalPlan;
            CatalogTable table = createDataSourceTableCommand.table();
            boolean ignoreIfExists = createDataSourceTableCommand.ignoreIfExists();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(table)) {
                CreateHoodieTableCommand createHoodieTableCommand = new CreateHoodieTableCommand(table, ignoreIfExists);
                return var6_14;
            }
        }
        if (logicalPlan instanceof AlterTableDropPartitionCommand) {
            AlterTableDropPartitionCommand alterTableDropPartitionCommand = (AlterTableDropPartitionCommand)logicalPlan;
            TableIdentifier tableName = alterTableDropPartitionCommand.tableName();
            Seq specs = alterTableDropPartitionCommand.specs();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableDropPartitionCommand alterHoodieTableDropPartitionCommand = new AlterHoodieTableDropPartitionCommand(tableName, (Seq<Map<String, String>>)specs);
                return var6_14;
            }
        }
        if (logicalPlan instanceof AlterTableAddColumnsCommand) {
            AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)logicalPlan;
            TableIdentifier tableId = alterTableAddColumnsCommand.table();
            Seq colsToAdd = alterTableAddColumnsCommand.colsToAdd();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(tableId, this.sparkSession())) {
                AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand = new AlterHoodieTableAddColumnsCommand(tableId, (Seq<StructField>)colsToAdd);
                return var6_14;
            }
        }
        if (logicalPlan instanceof AlterTableRenameCommand) {
            AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)logicalPlan;
            TableIdentifier oldName = alterTableRenameCommand.oldName();
            TableIdentifier newName = alterTableRenameCommand.newName();
            boolean isView = alterTableRenameCommand.isView();
            if (!isView && HoodieSqlUtils$.MODULE$.isHoodieTable(oldName, this.sparkSession())) {
                AlterHoodieTableRenameCommand alterHoodieTableRenameCommand = new AlterHoodieTableRenameCommand(oldName, newName, isView);
                return var6_14;
            }
        }
        if (logicalPlan instanceof AlterTableChangeColumnCommand) {
            AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)logicalPlan;
            TableIdentifier tableName = alterTableChangeColumnCommand.tableName();
            String columnName = alterTableChangeColumnCommand.columnName();
            StructField newColumn = alterTableChangeColumnCommand.newColumn();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = new AlterHoodieTableChangeColumnCommand(tableName, columnName, newColumn);
                return var6_14;
            }
        }
        if (logicalPlan instanceof ShowPartitionsCommand) {
            ShowPartitionsCommand showPartitionsCommand = (ShowPartitionsCommand)logicalPlan;
            TableIdentifier tableName = showPartitionsCommand.tableName();
            Option specOpt = showPartitionsCommand.spec();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(tableName, this.sparkSession())) {
                ShowHoodieTablePartitionsCommand showHoodieTablePartitionsCommand = new ShowHoodieTablePartitionsCommand(tableName, (Option<Map<String, String>>)specOpt);
                return var6_14;
            }
        }
        if (logicalPlan instanceof TruncateTableCommand) {
            TruncateTableCommand truncateTableCommand = (TruncateTableCommand)logicalPlan;
            TableIdentifier tableName = truncateTableCommand.tableName();
            Option partitionSpec = truncateTableCommand.partitionSpec();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(tableName, this.sparkSession())) {
                TruncateHoodieTableCommand truncateHoodieTableCommand = new TruncateHoodieTableCommand(tableName, (Option<Map<String, String>>)partitionSpec);
                return var6_14;
            }
        }
        LogicalPlan logicalPlan2 = plan;
        return var6_14;
    }

    public HoodiePostAnalysisRule copy(SparkSession sparkSession) {
        return new HoodiePostAnalysisRule(sparkSession);
    }

    public SparkSession copy$default$1() {
        return this.sparkSession();
    }

    public String productPrefix() {
        return "HoodiePostAnalysisRule";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.sparkSession();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HoodiePostAnalysisRule;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HoodiePostAnalysisRule)) return false;
        boolean bl = true;
        if (!bl) return false;
        HoodiePostAnalysisRule hoodiePostAnalysisRule = (HoodiePostAnalysisRule)((Object)x$1);
        SparkSession sparkSession = this.sparkSession();
        SparkSession sparkSession2 = hoodiePostAnalysisRule.sparkSession();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!hoodiePostAnalysisRule.canEqual((Object)this)) return false;
        return true;
    }

    public HoodiePostAnalysisRule(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Product.class.$init$((Product)this);
    }
}

