/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType$;

public class DataTypeUtils {
    private static Map<Class<?>, Set<Class<?>>> sparkPrimitiveTypesCompatibilityMap = new HashMap<Class<?>, Set<Class<?>>>(){
        {
            this.put(ShortType$.class, DataTypeUtils.newHashSet(new Class[]{ByteType$.class, ShortType$.class}));
            this.put(IntegerType$.class, DataTypeUtils.newHashSet(new Class[]{ByteType$.class, ShortType$.class, IntegerType$.class}));
            this.put(LongType$.class, DataTypeUtils.newHashSet(new Class[]{ByteType$.class, ShortType$.class, IntegerType$.class, LongType$.class}));
            this.put(DoubleType$.class, DataTypeUtils.newHashSet(new Class[]{FloatType$.class, DoubleType$.class}));
            this.put(StringType$.class, DataTypeUtils.newHashSet(new Class[]{VarcharType$.class, StringType$.class}));
        }
    };

    public static boolean areCompatible(@Nonnull DataType left, @Nonnull DataType right) {
        if (Objects.equals(left, right)) {
            return true;
        }
        if (left instanceof StructType && right instanceof StructType) {
            return DataTypeUtils.areCompatible((StructType)left, (StructType)right);
        }
        return sparkPrimitiveTypesCompatibilityMap.getOrDefault(left.getClass(), Collections.emptySet()).contains(right.getClass());
    }

    private static boolean areCompatible(@Nonnull StructType left, @Nonnull StructType right) {
        StructField[] anotherSchemaFields;
        StructField[] oneSchemaFields = left.fields();
        if (oneSchemaFields.length != (anotherSchemaFields = right.fields()).length) {
            return false;
        }
        for (int i = 0; i < oneSchemaFields.length; ++i) {
            StructField oneField = oneSchemaFields[i];
            StructField anotherField = anotherSchemaFields[i];
            if (Objects.equals(oneField.name(), anotherField.name()) && DataTypeUtils.areCompatible(oneField.dataType(), anotherField.dataType()) && oneField.nullable() == anotherField.nullable()) continue;
            return false;
        }
        return true;
    }

    private static <T> HashSet<T> newHashSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }
}

