/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;

public class MarkerBasedRollbackUtils {
    public static List<String> getAllMarkerPaths(HoodieTable table, HoodieEngineContext context, String instant, int parallelism) throws IOException {
        String markerDir = table.getMetaClient().getMarkerFolderPath(instant);
        HoodieWrapperFileSystem fileSystem = table.getMetaClient().getFs();
        Option<MarkerType> markerTypeOption = MarkerUtils.readMarkerType(fileSystem, markerDir);
        if (!markerTypeOption.isPresent()) {
            WriteMarkers writeMarkers = WriteMarkersFactory.get(MarkerType.DIRECT, table, instant);
            return new ArrayList<String>(writeMarkers.allMarkerFilePaths());
        }
        switch (markerTypeOption.get()) {
            case TIMELINE_SERVER_BASED: {
                Map<String, Set<String>> markersMap = MarkerUtils.readTimelineServerBasedMarkersFromFileSystem(markerDir, fileSystem, context, parallelism);
                return markersMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
            }
        }
        throw new HoodieException("The marker type \"" + markerTypeOption.get().name() + "\" is not supported.");
    }
}

