/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.BoundedIOCompactionStrategy;

public class LogFileSizeBasedCompactionStrategy
extends BoundedIOCompactionStrategy
implements Comparator<HoodieCompactionOperation> {
    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        long threshold = writeConfig.getCompactionLogFileSizeThreshold();
        return super.orderAndFilter(writeConfig, operations.stream().filter(e -> e.getMetrics().getOrDefault("TOTAL_LOG_FILES_SIZE", 0.0) >= (double)threshold).sorted(this).collect(Collectors.toList()), pendingCompactionPlans);
    }

    @Override
    public int compare(HoodieCompactionOperation op1, HoodieCompactionOperation op2) {
        Long totalLogSize1 = op1.getMetrics().get("TOTAL_LOG_FILES_SIZE").longValue();
        Long totalLogSize2 = op2.getMetrics().get("TOTAL_LOG_FILES_SIZE").longValue();
        return totalLogSize2.compareTo(totalLogSize1);
    }
}

