/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.SparkBoundedInMemoryExecutor;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.AbstractMergeHelper;
import org.apache.spark.api.java.JavaRDD;

public class SparkMergeHelper<T extends HoodieRecordPayload>
extends AbstractMergeHelper<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private SparkMergeHelper() {
    }

    public static SparkMergeHelper newInstance() {
        return MergeHelperHolder.SPARK_MERGE_HELPER;
    }

    @Override
    public void runMerge(HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, HoodieMergeHandle<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> upsertHandle) throws IOException {
        GenericDatumReader gReader;
        GenericDatumWriter gWriter;
        Schema readSchema;
        boolean externalSchemaTransformation = table.getConfig().shouldUseExternalSchemaTransformation();
        Configuration cfgForHoodieFile = new Configuration(table.getHadoopConf());
        HoodieMergeHandle<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> mergeHandle = upsertHandle;
        HoodieBaseFile baseFile = mergeHandle.baseFileForMerge();
        if (externalSchemaTransformation || baseFile.getBootstrapBaseFile().isPresent()) {
            readSchema = HoodieFileReaderFactory.getFileReader(table.getHadoopConf(), mergeHandle.getOldFilePath()).getSchema();
            gWriter = new GenericDatumWriter(readSchema);
            gReader = new GenericDatumReader(readSchema, mergeHandle.getWriterSchemaWithMetaFields());
        } else {
            gReader = null;
            gWriter = null;
            readSchema = mergeHandle.getWriterSchemaWithMetaFields();
        }
        SparkBoundedInMemoryExecutor<Object, Object, Void> wrapper = null;
        HoodieFileReader<GenericRecord> reader = HoodieFileReaderFactory.getFileReader(cfgForHoodieFile, mergeHandle.getOldFilePath());
        try {
            Iterator<Object> readerIterator = baseFile.getBootstrapBaseFile().isPresent() ? this.getMergingIterator(table, mergeHandle, baseFile, reader, readSchema, externalSchemaTransformation) : reader.getRecordIterator(readSchema);
            ThreadLocal encoderCache = new ThreadLocal();
            ThreadLocal decoderCache = new ThreadLocal();
            wrapper = new SparkBoundedInMemoryExecutor<Object, Object, Void>(table.getConfig(), readerIterator, new AbstractMergeHelper.UpdateHandler(mergeHandle), record -> {
                if (!externalSchemaTransformation) {
                    return record;
                }
                return this.transformRecordBasedOnNewSchema((GenericDatumReader<GenericRecord>)gReader, (GenericDatumWriter<GenericRecord>)gWriter, encoderCache, decoderCache, (GenericRecord)record);
            });
            wrapper.execute();
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            mergeHandle.close();
            if (null != wrapper) {
                wrapper.shutdownNow();
            }
        }
    }

    private static class MergeHelperHolder {
        private static final SparkMergeHelper SPARK_MERGE_HELPER = new SparkMergeHelper();

        private MergeHelperHolder() {
        }
    }
}

