/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.SparkInsertOverwriteCommitActionExecutor;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class SparkInsertOverwriteTableCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends SparkInsertOverwriteCommitActionExecutor<T> {
    public SparkInsertOverwriteTableCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, JavaRDD<HoodieRecord<T>> inputRecordsRDD) {
        super(context, config, table, instantTime, inputRecordsRDD, WriteOperationType.INSERT_OVERWRITE_TABLE);
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieWriteMetadata<JavaRDD<WriteStatus>> writeMetadata) {
        Map<String, List<String>> partitionToExistingFileIds = new HashMap<String, List<String>>();
        List<String> partitionPaths = FSUtils.getAllPartitionPaths(this.context, this.config.getMetadataConfig(), this.table.getMetaClient().getBasePath());
        JavaSparkContext jsc = HoodieSparkEngineContext.getSparkContext(this.context);
        if (partitionPaths != null && partitionPaths.size() > 0) {
            this.context.setJobStatus(this.getClass().getSimpleName(), "Getting ExistingFileIds of all partitions");
            JavaRDD partitionPathRdd = jsc.parallelize(partitionPaths, partitionPaths.size());
            partitionToExistingFileIds = partitionPathRdd.mapToPair((PairFunction & Serializable)partitionPath -> new Tuple2(partitionPath, this.getAllExistingFileIds((String)partitionPath))).collectAsMap();
        }
        return partitionToExistingFileIds;
    }
}

