/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import org.apache.hudi.org.apache.jetty.client.AbstractConnectorHttpClientTransport;
import org.apache.hudi.org.apache.jetty.client.DuplexConnectionPool;
import org.apache.hudi.org.apache.jetty.client.HttpDestination;
import org.apache.hudi.org.apache.jetty.client.Origin;
import org.apache.hudi.org.apache.jetty.client.api.Connection;
import org.apache.hudi.org.apache.jetty.client.http.HttpConnectionOverHTTP;
import org.apache.hudi.org.apache.jetty.client.http.HttpDestinationOverHTTP;
import org.apache.hudi.org.apache.jetty.io.EndPoint;
import org.apache.hudi.org.apache.jetty.util.ProcessorUtils;
import org.apache.hudi.org.apache.jetty.util.Promise;
import org.apache.hudi.org.apache.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public org.apache.hudi.org.apache.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }
}

