/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class CustomKeyGenerator
extends BuiltinKeyGenerator {
    private final CustomAvroKeyGenerator customAvroKeyGenerator;

    public CustomKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(",")).map(String::trim).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).collect(Collectors.toList());
        this.customAvroKeyGenerator = new CustomAvroKeyGenerator(props);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.customAvroKeyGenerator.getRecordKey(record);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.customAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.validateRecordKeyFields();
        return this.getRecordKeyFields().size() == 1 ? new SimpleKeyGenerator(this.config).getRecordKey(row) : new ComplexKeyGenerator(this.config).getRecordKey(row);
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.getPartitionPath(Option.empty(), Option.of(row), Option.empty());
    }

    @Override
    public String getPartitionPath(InternalRow row, StructType structType) {
        return this.getPartitionPath(Option.empty(), Option.empty(), Option.of(Pair.of(row, structType)));
    }

    private String getPartitionPath(Option<GenericRecord> record, Option<Row> row, Option<Pair<InternalRow, StructType>> internalRowStructTypePair) {
        if (this.getPartitionPathFields() == null) {
            throw new HoodieKeyException("Unable to find field names for partition path in cfg");
        }
        StringBuilder partitionPath = new StringBuilder();
        if (this.getPartitionPathFields().size() == 1 && this.getPartitionPathFields().get(0).isEmpty()) {
            return "";
        }
        for (String field : this.getPartitionPathFields()) {
            String[] fieldWithType = field.split(":");
            if (fieldWithType.length != 2) {
                throw new HoodieKeyGeneratorException("Unable to find field names for partition path in proper format");
            }
            String partitionPathField = fieldWithType[0];
            CustomAvroKeyGenerator.PartitionKeyType keyType = CustomAvroKeyGenerator.PartitionKeyType.valueOf(fieldWithType[1].toUpperCase());
            switch (keyType) {
                case SIMPLE: {
                    if (record.isPresent()) {
                        partitionPath.append(new SimpleKeyGenerator(this.config, partitionPathField).getPartitionPath(record.get()));
                        break;
                    }
                    if (row.isPresent()) {
                        partitionPath.append(new SimpleKeyGenerator(this.config, partitionPathField).getPartitionPath(row.get()));
                        break;
                    }
                    partitionPath.append(new SimpleKeyGenerator(this.config, partitionPathField).getPartitionPath(internalRowStructTypePair.get().getKey(), internalRowStructTypePair.get().getValue()));
                    break;
                }
                case TIMESTAMP: {
                    try {
                        if (record.isPresent()) {
                            partitionPath.append(new TimestampBasedKeyGenerator(this.config, partitionPathField).getPartitionPath(record.get()));
                            break;
                        }
                        if (row.isPresent()) {
                            partitionPath.append(new TimestampBasedKeyGenerator(this.config, partitionPathField).getPartitionPath(row.get()));
                            break;
                        }
                        partitionPath.append(new TimestampBasedKeyGenerator(this.config, partitionPathField).getPartitionPath(internalRowStructTypePair.get().getKey(), internalRowStructTypePair.get().getValue()));
                        break;
                    }
                    catch (IOException ioe) {
                        throw new HoodieKeyGeneratorException("Unable to initialise TimestampBasedKeyGenerator class", ioe);
                    }
                }
                default: {
                    throw new HoodieKeyGeneratorException("Please provide valid PartitionKeyType with fields! You provided: " + (Object)((Object)keyType));
                }
            }
            partitionPath.append(this.customAvroKeyGenerator.getDefaultPartitionPathSeparator());
        }
        partitionPath.deleteCharAt(partitionPath.length() - 1);
        return partitionPath.toString();
    }

    private void validateRecordKeyFields() {
        if (this.getRecordKeyFields() == null || this.getRecordKeyFields().isEmpty()) {
            throw new HoodieKeyException("Unable to find field names for record key in cfg");
        }
    }
}

