/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriter;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriterFactory;
import org.apache.hudi.io.storage.row.HoodieRowCreateHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class HoodieRowCreateHandleWithoutMetaFields
extends HoodieRowCreateHandle {
    public HoodieRowCreateHandleWithoutMetaFields(HoodieTable table, HoodieWriteConfig writeConfig, String partitionPath, String fileId, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType) {
        super(table, writeConfig, partitionPath, fileId, instantTime, taskPartitionId, taskId, taskEpochId, structType);
    }

    @Override
    public void write(InternalRow record) throws IOException {
        try {
            this.fileWriter.writeRow(record);
            this.writeStatus.markSuccess();
        }
        catch (Throwable ge) {
            this.writeStatus.setGlobalError(ge);
            throw new HoodieException("Exception thrown while writing spark InternalRows to file ", ge);
        }
    }

    @Override
    protected HoodieInternalRowFileWriter createNewFileWriter(Path path, HoodieTable hoodieTable, HoodieWriteConfig config, StructType schema2) throws IOException {
        return HoodieInternalRowFileWriterFactory.getInternalRowFileWriterWithoutMetaFields(path, hoodieTable, config, schema2);
    }
}

