/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.KeyRangeLookupTree;
import org.apache.hudi.index.bloom.KeyRangeNode;

class IntervalTreeBasedIndexFileFilter
implements IndexFileFilter {
    private final Map<String, KeyRangeLookupTree> partitionToFileIndexLookUpTree = new HashMap<String, KeyRangeLookupTree>();
    private final Map<String, Set<String>> partitionToFilesWithNoRanges = new HashMap<String, Set<String>>();

    IntervalTreeBasedIndexFileFilter(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo) {
        partitionToFileIndexInfo.forEach((partition, bloomIndexFiles) -> {
            Collections.shuffle(bloomIndexFiles);
            KeyRangeLookupTree lookUpTree = new KeyRangeLookupTree();
            bloomIndexFiles.forEach(indexFileInfo -> {
                if (indexFileInfo.hasKeyRanges()) {
                    lookUpTree.insert(new KeyRangeNode(indexFileInfo.getMinRecordKey(), indexFileInfo.getMaxRecordKey(), indexFileInfo.getFileId()));
                } else {
                    if (!this.partitionToFilesWithNoRanges.containsKey(partition)) {
                        this.partitionToFilesWithNoRanges.put((String)partition, new HashSet());
                    }
                    this.partitionToFilesWithNoRanges.get(partition).add(indexFileInfo.getFileId());
                }
            });
            this.partitionToFileIndexLookUpTree.put((String)partition, lookUpTree);
        });
    }

    @Override
    public Set<Pair<String, String>> getMatchingFilesAndPartition(String partitionPath, String recordKey) {
        HashSet<Pair<String, String>> toReturn = new HashSet<Pair<String, String>>();
        if (this.partitionToFileIndexLookUpTree.containsKey(partitionPath)) {
            this.partitionToFileIndexLookUpTree.get(partitionPath).getMatchingIndexFiles(recordKey).forEach(file -> toReturn.add(Pair.of(partitionPath, file)));
        }
        if (this.partitionToFilesWithNoRanges.containsKey(partitionPath)) {
            this.partitionToFilesWithNoRanges.get(partitionPath).forEach(file -> toReturn.add(Pair.of(partitionPath, file)));
        }
        return toReturn;
    }
}

