/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedIndexFileFilter;
import org.apache.hudi.io.HoodieRangeInfoHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieBloomIndex<T extends HoodieRecordPayload<T>>
extends HoodieIndex<T, Object, Object, Object> {
    private static final Logger LOG = LogManager.getLogger(HoodieBloomIndex.class);
    private final BaseHoodieBloomIndexHelper bloomIndexHelper;

    public HoodieBloomIndex(HoodieWriteConfig config, BaseHoodieBloomIndexHelper bloomIndexHelper) {
        super(config);
        this.bloomIndexHelper = bloomIndexHelper;
    }

    @Override
    public HoodieData<HoodieRecord<T>> tagLocation(HoodieData<HoodieRecord<T>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        if (this.config.getBloomIndexUseCaching()) {
            records.persist(new HoodieConfig(this.config.getProps()).getString(HoodieIndexConfig.BLOOM_INDEX_INPUT_STORAGE_LEVEL_VALUE));
        }
        HoodiePairData<String, String> partitionRecordKeyPairs = records.mapToPair(record -> new ImmutablePair<String, String>(record.getPartitionPath(), record.getRecordKey()));
        HoodiePairData<HoodieKey, HoodieRecordLocation> keyFilenamePairs = this.lookupIndex(partitionRecordKeyPairs, context, hoodieTable);
        if (this.config.getBloomIndexUseCaching()) {
            keyFilenamePairs.persist("MEMORY_AND_DISK_SER");
        }
        if (LOG.isDebugEnabled()) {
            long totalTaggedRecords = keyFilenamePairs.count();
            LOG.debug((Object)("Number of update records (ones tagged with a fileID): " + totalTaggedRecords));
        }
        HoodieData<HoodieRecord<T>> taggedRecords = this.tagLocationBacktoRecords(keyFilenamePairs, records);
        if (this.config.getBloomIndexUseCaching()) {
            records.unpersist();
            keyFilenamePairs.unpersist();
        }
        return taggedRecords;
    }

    private HoodiePairData<HoodieKey, HoodieRecordLocation> lookupIndex(HoodiePairData<String, String> partitionRecordKeyPairs, HoodieEngineContext context, HoodieTable hoodieTable) {
        Map<String, Long> recordsPerPartition = partitionRecordKeyPairs.countByKey();
        ArrayList<String> affectedPartitionPathList = new ArrayList<String>(recordsPerPartition.keySet());
        List<Pair<String, BloomIndexFileInfo>> fileInfoList = this.loadInvolvedFiles(affectedPartitionPathList, context, hoodieTable);
        Map<String, List<BloomIndexFileInfo>> partitionToFileInfo = fileInfoList.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        HoodieData<ImmutablePair<String, HoodieKey>> fileComparisonPairs = this.explodeRecordsWithFileComparisons(partitionToFileInfo, partitionRecordKeyPairs);
        return this.bloomIndexHelper.findMatchingFilesForRecordKeys(this.config, context, hoodieTable, partitionRecordKeyPairs, fileComparisonPairs, partitionToFileInfo, recordsPerPartition);
    }

    List<Pair<String, BloomIndexFileInfo>> loadInvolvedFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        List partitionPathFileIDList = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, context, hoodieTable).stream().map(pair -> Pair.of(pair.getKey(), ((HoodieBaseFile)pair.getValue()).getFileId())).collect(Collectors.toList());
        if (this.config.getBloomIndexPruneByRanges()) {
            context.setJobStatus(this.getClass().getName(), "Obtain key ranges for file slices (range pruning=on)");
            return context.map(partitionPathFileIDList, pf -> {
                try {
                    HoodieRangeInfoHandle rangeInfoHandle = new HoodieRangeInfoHandle(this.config, hoodieTable, (Pair<String, String>)pf);
                    String[] minMaxKeys = rangeInfoHandle.getMinMaxKeys();
                    return Pair.of(pf.getKey(), new BloomIndexFileInfo((String)pf.getValue(), minMaxKeys[0], minMaxKeys[1]));
                }
                catch (MetadataNotFoundException me) {
                    LOG.warn((Object)("Unable to find range metadata in file :" + pf));
                    return Pair.of(pf.getKey(), new BloomIndexFileInfo((String)pf.getValue()));
                }
            }, Math.max(partitionPathFileIDList.size(), 1));
        }
        return partitionPathFileIDList.stream().map(pf -> Pair.of(pf.getKey(), new BloomIndexFileInfo((String)pf.getValue()))).collect(Collectors.toList());
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    HoodieData<ImmutablePair<String, HoodieKey>> explodeRecordsWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, HoodiePairData<String, String> partitionRecordKeyPairs) {
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedIndexFileFilter(partitionToFileIndexInfo) : new ListBasedIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairs.map(partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair.getRight();
            String partitionPath = (String)partitionRecordKeyPair.getLeft();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new ImmutablePair(partitionFileIdPair.getRight(), new HoodieKey(recordKey, partitionPath))).collect(Collectors.toList());
        }).flatMap(List::iterator);
    }

    protected HoodieData<HoodieRecord<T>> tagLocationBacktoRecords(HoodiePairData<HoodieKey, HoodieRecordLocation> keyFilenamePair, HoodieData<HoodieRecord<T>> records) {
        HoodiePairData keyRecordPairs = records.mapToPair(record -> new ImmutablePair<HoodieKey, HoodieRecord>(record.getKey(), (HoodieRecord)record));
        return keyRecordPairs.leftOuterJoin(keyFilenamePair).values().map(v -> HoodieIndexUtils.getTaggedRecord((HoodieRecord)v.getLeft(), Option.ofNullable(((Option)v.getRight()).orElse(null))));
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatusData, HoodieEngineContext context, HoodieTable hoodieTable) {
        return writeStatusData;
    }
}

