/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;

public class BaseFileWithLogsSplit
extends FileSplit {
    private boolean belongToIncrementalSplit = false;
    private List<HoodieLogFile> deltaLogFiles = new ArrayList<HoodieLogFile>();
    private String maxCommitTime = "";
    private String basePath = "";
    private String baseFilePath = "";

    public BaseFileWithLogsSplit(Path file, long start, long length, String[] hosts) {
        super(file, start, length, hosts);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.belongToIncrementalSplit);
        Text.writeString((DataOutput)out, (String)this.maxCommitTime);
        Text.writeString((DataOutput)out, (String)this.basePath);
        Text.writeString((DataOutput)out, (String)this.baseFilePath);
        out.writeInt(this.deltaLogFiles.size());
        for (HoodieLogFile logFile : this.deltaLogFiles) {
            Text.writeString((DataOutput)out, (String)logFile.getPath().toString());
            out.writeLong(logFile.getFileSize());
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.belongToIncrementalSplit = in.readBoolean();
        this.maxCommitTime = Text.readString((DataInput)in);
        this.basePath = Text.readString((DataInput)in);
        this.baseFilePath = Text.readString((DataInput)in);
        int deltaLogSize = in.readInt();
        ArrayList<HoodieLogFile> tempDeltaLogs = new ArrayList<HoodieLogFile>();
        for (int i = 0; i < deltaLogSize; ++i) {
            String logPath = Text.readString((DataInput)in);
            long logFileSize = in.readLong();
            tempDeltaLogs.add(new HoodieLogFile(new Path(logPath), logFileSize));
        }
        this.deltaLogFiles = tempDeltaLogs;
    }

    public boolean getBelongToIncrementalSplit() {
        return this.belongToIncrementalSplit;
    }

    public void setBelongToIncrementalSplit(boolean belongToIncrementalSplit) {
        this.belongToIncrementalSplit = belongToIncrementalSplit;
    }

    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    public void setDeltaLogFiles(List<HoodieLogFile> deltaLogFiles) {
        this.deltaLogFiles = deltaLogFiles;
    }

    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    public void setMaxCommitTime(String maxCommitTime) {
        this.maxCommitTime = maxCommitTime;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBaseFilePath() {
        return this.baseFilePath;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }
}

