/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.GlobalSortPartitioner;
import org.apache.hudi.execution.bulkinsert.NonSortPartitioner;
import org.apache.hudi.execution.bulkinsert.RDDPartitionSortPartitioner;
import org.apache.hudi.table.BulkInsertPartitioner;

public abstract class BulkInsertInternalPartitionerFactory {
    public static BulkInsertPartitioner get(BulkInsertSortMode sortMode) {
        switch (sortMode) {
            case NONE: {
                return new NonSortPartitioner();
            }
            case GLOBAL_SORT: {
                return new GlobalSortPartitioner();
            }
            case PARTITION_SORT: {
                return new RDDPartitionSortPartitioner();
            }
        }
        throw new HoodieException("The bulk insert sort mode \"" + sortMode.name() + "\" is not supported.");
    }
}

