/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metrics Configurations for Jmx", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics using Jmx.  Hudi publishes metrics on every commit, clean, rollback etc.")
public class HoodieMetricsJmxConfig
extends HoodieConfig {
    public static final String JMX_PREFIX = "hoodie.metrics.jmx";
    public static final ConfigProperty<String> JMX_HOST_NAME = ConfigProperty.key("hoodie.metrics.jmx.host").defaultValue("localhost").sinceVersion("0.5.1").withDocumentation("Jmx host to connect to");
    public static final ConfigProperty<Integer> JMX_PORT_NUM = ConfigProperty.key("hoodie.metrics.jmx.port").defaultValue(9889).sinceVersion("0.5.1").withDocumentation("Jmx port to connect to");
    @Deprecated
    public static final String JMX_HOST = JMX_HOST_NAME.key();
    @Deprecated
    public static final String DEFAULT_JMX_HOST = JMX_HOST_NAME.defaultValue();
    @Deprecated
    public static final String JMX_PORT = JMX_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_JMX_PORT = JMX_PORT_NUM.defaultValue();

    private HoodieMetricsJmxConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMetricsJmxConfig hoodieMetricsJmxConfig = new HoodieMetricsJmxConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.hoodieMetricsJmxConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsJmxConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder toJmxHost(String host) {
            this.hoodieMetricsJmxConfig.setValue(JMX_HOST_NAME, host);
            return this;
        }

        public Builder onJmxPort(String port) {
            this.hoodieMetricsJmxConfig.setValue(JMX_PORT_NUM, port);
            return this;
        }

        public HoodieMetricsJmxConfig build() {
            this.hoodieMetricsJmxConfig.setDefaults(HoodieMetricsJmxConfig.class.getName());
            return this.hoodieMetricsJmxConfig;
        }
    }
}

